;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;;;  Rich Acuff, Stanford KSL, Dec-88

;;;  File loaded by Server type machines in the KSL at Boot time.

;; Don't waste cycles on the screen saver
(setf tv:*screen-saver-hacks* nil)

;; Load the Visidoc namepace if I'm the server
(when (find-package "DOX")
  (let ((sym (find-symbol "BOOT-VISIDOC-SERVER-NAMED" "DOX")))
    (funcall sym "visidoc-server-REL-5-0" :rel-5-0)))

(defparameter *servers-to-backup*
	      (loop for host in '(X1 X5 X23)
		    collect (net:parse-host host))
  "These hosts are automatically backed up.")

(when (member (net:parse-host "LM") *servers-to-backup*)
  ;; Load and configure the batch processor for backup
  (load-tools '(:batch-processor backup-to-file-system))
  (load "SYS:SITE;SERVER-BACKUP")
  (setq sys:*Batch-Processor-Enabled* t)
  (setq sys:*Batch-input-command-file-name*
	"LM:SYSTEM;SERVER-BACKUP-BATCH.LISP#>")
  (setq sys:*Batch-log-file-name* "LM:SYSTEM;BATCH.LOG")
  (unless (sys:find-process-named sys:batch-process-name)
    (sys:initialise-batch-evaluator)))

(defparameter *master-batch-backup-script*
	      (pathname "SYS:SITE;SERVER-BACKUP-BATCH.LISP#>"))

(defun install-backup-batch-script ()
  (loop for host in *servers-to-backup*
	as to-file = (make-pathname :defaults *master-batch-backup-script*
				     :directory "SYSTEM"
				     :host host)
	do (copy-file *master-batch-backup-script* to-file
		      :create-directories t)
	(format t "~A~%" to-file)))

;(install-backup-batch-script)