;;; -*- Mode:Common-Lisp; Base:10 -*-


(defun install-system-source ()
  
  (let*  ((syshost (send (pathname-host (si:translated-pathname "sys:~;")) :name))
	  
	  (install-patch (y-or-n-p "~%Install microcode and help files on sys-host ~a"
				   syshost))
	  (install-source (y-or-n-p "~%Install system source and patch files on syshost ~a"
				    syshost))
	  
	  (install-decnet (y-or-n-p "~%Install DECNET patch files on DECNET host ~a" (find-host "DECNET")))
	  
	  (install-nlmenu (y-or-n-p "~%Install NLMENU patch files on NLMENU host ~a" (find-host "NLMENU")))
	  
	  (install-rtms (y-or-n-p "~%Install RTMS patch files on RTMS host ~a" (find-host "RTMS")))
	  
	  (install-ti-prolog (y-or-n-p "~%Install TI-PROLOG patch files on TI-PROLOG host ~a" (find-host "TI-PROLOG")))
	  
	  (install-bn (y-or-n-p "~%Install BUSNET patch files on BUSNET host ~a" (find-host "BN")))
	  
	  (install-nfs (y-or-n-p "~%Install NFS patch files on NFS host ~a" (find-host "NFS")))
	  
	  (install-lx (y-or-n-p "~%Install LX patch files on LX host ~a" (find-host "LX")))
	  
	  (install-ip (y-or-n-p "~%Install IP patch files on LX host ~a" (find-host "IP")))
	  
	  (install-sna (y-or-n-p "~%Install SNA client patch files on SNA host ~a" (find-host "SNA")))
	  
	  (install-public (y-or-n-p "~%Install public files on sys-host ~a" syshost)))
    
    (if install-patch
	(progn
	  (mt:restore-directory "SYS:SITE;*.*#*" :verbose t :create-directories t)
	  (mt:restore-directory "SYS:STREAMER-TAPE;*.*#*" :verbose t :create-directories t)
	  (mt:restore-directory "SYS:UBIN;*.*#*" :VERBOSE T :create-directories t))
	(dotimes (x 3 t)
	  (mt:list-contents nil :stop-at-double-eof t)))
    (if install-source
	(progn
	  (mt:restore-directory "SYS: BAND-TOOLS;" :create-directories t)
	  (mt:restore-directory "SYS: BASIC-FILE;" :create-directories t)
	  (mt:restore-directory "SYS: CHAOSNET;" :create-directories t)
	  (mt:restore-directory "SYS: CLEH;" :create-directories t)
	  (mt:restore-directory "SYS: CLOS;" :create-directories t)
	  (mt:restore-directory "SYS: CLUE;" :create-directories t)
	  (mt:restore-directory "SYS: CLX;" :create-directories t)
	  (mt:restore-directory "SYS: COLOR-MAP-EDITOR;" :create-directories t)
	  (mt:restore-directory "SYS: COMPILER;" :create-directories t)
	  (mt:restore-directory "SYS: DATALINK;" :create-directories t)
	  (mt:restore-directory "SYS: DEBUG-TOOLS;" :create-directories t)
	  (mt:restore-directory "SYS: DISK-IO;" :create-directories t)
	  (mt:restore-directory "SYS: DOCUMENTER;" :create-directories t)
	  (mt:restore-directory "SYS: EH;" :create-directories t)
	  (mt:restore-directory "SYS: FONT-EDITOR;" :create-directories t)
	  (mt:restore-directory "SYS: FONTS;" :create-directories t)
	  (mt:restore-directory "SYS: FRED;" :create-directories t)
	  (mt:restore-directory "SYS: GED;" :create-directories t)
	  (mt:restore-directory "SYS: GWIN;" :create-directories t)
	  (mt:restore-directory "SYS: IMAGEN;" :create-directories t)
	  (mt:restore-directory "SYS: INPUT-EDITOR;" :create-directories t)
	  (mt:restore-directory "SYS: KERNEL;" :create-directories t)
	  (mt:restore-directory "SYS: LOCAL-FILE;" :create-directories t)
	  (mt:restore-directory "SYS: MAIL-DAEMON;" :create-directories t)
	  (mt:restore-directory "SYS: MAIL-READER;" :create-directories t)
	  (mt:restore-directory "SYS: MAKE-SYSTEM;" :create-directories t)
	  (mt:restore-directory "SYS: MEMORY-MANAGEMENT;" :create-directories t)
	  (mt:restore-directory "SYS: METER;" :create-directories t)
	  (mt:restore-directory "SYS: MICRONET;" :create-directories t)
	  (mt:restore-directory "SYS: MMON;" :create-directories t)
	  (mt:restore-directory "SYS: NAMESPACE;" :create-directories t)
	  (mt:restore-directory "SYS: NAMESPACE-EDITOR;" :create-directories t)
	  (mt:restore-directory "SYS: NETWORK-SERVICE;" :create-directories t)
	  (mt:restore-directory "SYS: NETWORK-SUPPORT;" :create-directories t)
	  (mt:restore-directory "SYS: NVRAM;" :create-directories t)
	  (mt:restore-directory "SYS: PATCH;" :create-directories t)
	  (mt:restore-directory "SYS: PATHNAME;" :create-directories t)
	  (mt:restore-directory "SYS: PRINTER;" :create-directories t)
	  (mt:restore-directory "SYS: PRINTER-TYPES;" :create-directories t)
	  (mt:restore-directory "SYS: PROFILE;" :create-directories t)
	  (mt:restore-directory "SYS: RPC;" :create-directories t)
	  (mt:restore-directory "SYS: SERIAL;" :create-directories t)
	  (mt:restore-directory "SYS: SUGGESTIONS;" :create-directories t)
	  (mt:restore-directory "SYS: SYSLOG;" :create-directories t)
	  (mt:restore-directory "SYS: TELNET;" :create-directories t)
	  (mt:restore-directory "SYS: TI-EXAMPLES;" :create-directories t)
	  (mt:restore-directory "SYS: TREE-EDITOR;" :create-directories t)
	  (mt:restore-directory "SYS: UCL;" :create-directories t)
	  (mt:restore-directory "SYS: UCODE;" :create-directories t)
	  (mt:restore-directory "SYS: VISIDOC;" :create-directories t)
	  (mt:restore-directory "SYS: VT100;" :create-directories t)
	  (mt:restore-directory "SYS: WINDOW;" :create-directories t)
	  (mt:restore-directory "SYS: X11M;" :create-directories t)
	  (mt:restore-directory "SYS: ZMACS;" :create-directories t))
	(dotimes (x 55 t) 
	  (mt:list-contents nil :stop-at-double-eof t)))
    (if install-decnet
	(mt:restore-directory (make-pathname :host (find-host "DECNET") :directory "DECNET-PATCH"
					     :version :wild) :create-directories t)
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-nlmenu
	(mt:restore-directory (make-pathname :host (find-host "NLMENU") :directory "NLMENU-PATCH"
					     :version :wild) :create-directories t)
	(mt:list-contents nil :stop-at-double-eof t))
    
    (if install-rtms
	(progn
	  (mt:restore-directory (make-pathname :host (find-host "RTMS") :directory "RTMS-PATCH"
					       :version :wild) :create-directories t)
	  (mt:restore-directory (make-pathname :host (find-host "RTMS") :directory "NLMENU-RTMS-INTERFACE-PATCH"
					       :version :wild) :create-directories t))
	(progn
	  (mt:list-contents nil :stop-at-double-eof t)
	  (mt:list-contents nil :stop-at-double-eof t)))
    
    (if install-ti-prolog
	(mt:restore-directory (make-pathname :host (find-host "TI-PROLOG") :directory "TI-PROLOG-PATCH"
					     :version :wild) :create-directories t)
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-bn
	(mt:restore-directory (make-pathname :host (find-host "BN") :directory "BN-PATCH"
					     :version :wild) :create-directories t)
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-nfs
	(mt:restore-directory (make-pathname :host (find-host "NFS") :directory "NFS-PATCH"
					     :version :wild) :create-directories t)
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-lx
	(mt:restore-directory (make-pathname :host (find-host "LX") :directory "LX-PATCH"
					     :version :wild) :create-directories t)
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-ip
	(mt:restore-directory (make-pathname :host (find-host "IP") :directory "IP-PATCH"
					     :version :wild) :create-directories t)
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-sna
	(progn
	(mt:restore-directory (make-pathname :host (find-host "SNA") :directory "SNA-CLIENT-PATCH"
					     :version :wild) :create-directories t)
	(mt:restore-directory (make-pathname :host (find-host "SNA") :directory "SNA-GATEWAY-PATCH"
					     :version :wild) :create-directories t)
	(mt:restore-directory (make-pathname :host (find-host "SNA") :directory "SNA-STANDALONE-PATCH"
					     :version :wild) :create-directories t))
	(dotimes (x 3 t) 
	  (mt:list-contents nil :stop-at-double-eof t)))
    (if install-public
	(progn
	  (mt:restore-directory "sys:public;*.*#*" :create-directories t)
	  (mt:restore-directory "sys:demo;*.*#*" :create-directories t))
	(dotimes (x 2 t)
	  (mt:list-contents nil :stop-at-double-eof t)))
    (format t "~% Rewinding to verify")
    (mt:rewind)
    (mt:verify-file "sys:site;*.*#*")
    (if install-patch
	(progn
	  (mt:verify-directory "SYS:SITE;*.*#*" :verbose t)
	  (mt:verify-directory "SYS:STREAMER-TAPE;*.*#*" :verbose t)
	  (mt:verify-directory "SYS:UBIN;*.*#*" :VERBOSE T   ))
	(dotimes (x 3 t) (mt:list-contents nil :stop-at-double-eof t)))
    (if install-source 
	(progn
	  (mt:verify-directory "SYS: BAND-TOOLS;")
	  (mt:verify-directory "SYS: BASIC-FILE;")
	  (mt:verify-directory "SYS: CHAOSNET;")
	  (mt:verify-directory "SYS: CLEH;")
	  (mt:verify-directory "SYS: CLOS;")
	  (mt:verify-directory "SYS: CLUE;")
	  (mt:verify-directory "SYS: CLX;")
	  (mt:verify-directory "SYS: COLOR-MAP-EDITOR;")
	  (mt:verify-directory "SYS: COMPILER;")
	  (mt:verify-directory "SYS: DATALINK;")
	  (mt:verify-directory "SYS: DEBUG-TOOLS;")
	  (mt:verify-directory "SYS: DISK-IO;")
	  (mt:verify-directory "SYS: DOCUMENTER;")
	  (mt:verify-directory "SYS: EH;")
	  (mt:verify-directory "SYS: FONT-EDITOR;")
	  (mt:verify-directory "SYS: FONTS;")
	  (mt:verify-directory "SYS: FRED;")
	  (mt:verify-directory "SYS: GED;")
	  (mt:verify-directory "SYS: GWIN;")
	  (mt:verify-directory "SYS: IMAGEN;")
	  (mt:verify-directory "SYS: INPUT-EDITOR;")
	  (mt:verify-directory "SYS: KERNEL;")
	  (mt:verify-directory "SYS: LOCAL-FILE;")
	  (mt:verify-directory "SYS: MAIL-DAEMON;")
	  (mt:verify-directory "SYS: MAIL-READER;")
	  (mt:verify-directory "SYS: MAKE-SYSTEM;")
	  (mt:verify-directory "SYS: MEMORY-MANAGEMENT;")
	  (mt:verify-directory "SYS: METER;")
	  (mt:verify-directory "SYS: MICRONET;")
	  (mt:verify-directory "SYS: MMON;")
	  (mt:verify-directory "SYS: NAMESPACE;")
	  (mt:verify-directory "SYS: NAMESPACE-EDITOR;")
	  (mt:verify-directory "SYS: NETWORK-SERVICE;")
	  (mt:verify-directory "SYS: NETWORK-SUPPORT;")
	  (mt:verify-directory "SYS: NVRAM;")
	  (mt:verify-directory "SYS: PATCH;")
	  (mt:verify-directory "SYS: PATHNAME;")
	  (mt:verify-directory "SYS: PRINTER;")
	  (mt:verify-directory "SYS: PRINTER-TYPES;")
	  (mt:verify-directory "SYS: PROFILE;")
	  (mt:verify-directory "SYS: RPC;")
	  (mt:verify-directory "SYS: SERIAL;")
	  (mt:verify-directory "SYS: SUGGESTIONS;")
	  (mt:verify-directory "SYS: SYSLOG;")
	  (mt:verify-directory "SYS: TELNET;")
	  (mt:verify-directory "SYS: TI-EXAMPLES;")
	  (mt:verify-directory "SYS: TREE-EDITOR;")
	  (mt:verify-directory "SYS: UCL;")
	  (mt:verify-directory "SYS: UCODE;")
	  (mt:verify-directory "SYS: VISIDOC;")
	  (mt:verify-directory "SYS: VT100;")
	  (mt:verify-directory "SYS: WINDOW;")
	  (mt:verify-directory "SYS: X11M;")
	  (mt:verify-directory "SYS: ZMACS;"))
	
	(dotimes (x 55 t) (mt:list-contents nil :stop-at-double-eof t)))
    (if install-decnet
	(mt:verify-directory (make-pathname :host (find-host "DECNET") :directory "DECNET-PATCH"
					    :version :wild) )
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-nlmenu
	(mt:verify-directory (make-pathname :host (find-host "NLMENU") :directory "NLMENU-PATCH"
					    :version :wild) )
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-rtms
	(progn
	  (mt:verify-directory (make-pathname :host (find-host "RTMS") :directory "RTMS-PATCH"
					      :version :wild) )
	  (mt:verify-directory (make-pathname :host (find-host "RTMS") :directory "NLMENU-RTMS-INTERFACE-PATCH"
					      :version :wild) ))
	(progn
	  (mt:list-contents nil :stop-at-double-eof t)
	  (mt:list-contents nil :stop-at-double-eof t)))
    
    (if install-ti-prolog
	(mt:verify-directory (make-pathname :host (find-host "TI-PROLOG") :directory "TI-PROLOG-PATCH"
					    :version :wild) )
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-bn
	(mt:verify-directory (make-pathname :host (find-host "BN") :directory "BN-PATCH"
					    :version :wild) )
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-nfs
	(mt:verify-directory (make-pathname :host (find-host "NFS") :directory "NFS-PATCH"
					    :version :wild) )
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-lx
	(mt:verify-directory (make-pathname :host (find-host "LX") :directory "LX-PATCH"
					    :version :wild) )
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-ip
	(mt:verify-directory (make-pathname :host (find-host "IP") :directory "IP-PATCH"
					    :version :wild) )
	(mt:list-contents nil :stop-at-double-eof t))
    (if install-sna
	(progn
	  (mt:verify-directory (make-pathname :host (find-host "SNA") :directory "SNA-CLIENT-PATCH"
					    :version :wild) )
	  (mt:verify-directory (make-pathname :host (find-host "SNA") :directory "SNA-GATEWAY-PATCH"
					    :version :wild) )
	  (mt:verify-directory (make-pathname :host (find-host "SNA") :directory "SNA-STANDALONE-PATCH"
					    :version :wild) ))
	(dotimes (x 3 t) (mt:list-contents nil :stop-at-double-eof t)))
    (if install-public
	(progn
	  (mt:verify-directory "sys:public;*.*#*")
	  (mt:verify-directory "sys:demo;*.*#*"))
	(dotimes (x 2 t) (mt:list-contents nil :stop-at-double-eof t)))
    
    t
    ))


(defun find-host ( host-name )
  (send (pathname-host (if (si:parse-host host-name t)
			   (si:translated-pathname (make-pathname :host host-name))
			   (si:translated-pathname "SYS:~;"))) :name))


