;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TALK; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "*ENGLISH-PHONEMES1"*
;1;; English to Phoneme rules.  Depends on the file 3PHONEME-TRANSLATOR.LISP*.*
;1;; The code in this file is derived from an (apparently) public domain C program.*
;1;; See the file 3PHONEME-TRANSLATOR.LISP* for details on phoneme codes, rules, procedure, and special context symbols.*
;1;;*
;1;; Copyright  1989 David Forster.  Permission is granted for non-commercial use and distribution.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;*		1David Forster*	1Created.*
;1;;   28 Feb 89*	1Jamie Zawinski*	1Added changelog, and call to *CLEAR-ALL-RULES1.*
;1;;*

(in-package "3TALK*")

(clear-all-rules)


;1; Note: the following rules are in5 REVERSE* order, since we're pushing!*

(add-phonemic-rule :Anything	"!"		:Anything	Pause)
(add-phonemic-rule :Anything	"?"		:Anything	Pause)
(add-phonemic-rule :Anything	"."		:Anything	Pause)
(add-phonemic-rule :Anything	","		:Anything	Pause)
(add-phonemic-rule :Anything	"'"		:Anything	Silent)
(add-phonemic-rule "#"		"'S"		:Anything	"z")
(add-phonemic-rule "#:.E"	"'S"		:Anything	"z")
(add-phonemic-rule "."		"'S"		:Anything	"z")
(add-phonemic-rule :Anything	"-"		:Anything	Silent)
(add-phonemic-rule :Anything	" "		:Anything	Pause)

(add-phonemic-rule :Anything	"A"		:Anything	"AE")
(add-phonemic-rule :Anything	"ANG"		"+"		"EYnj")
(add-phonemic-rule :Anything	"ABLE"		:Anything	"AXbAXl")
(add-phonemic-rule " :"		"ABLE"		:Anything	"EYbAXl")
(add-phonemic-rule :Anything	"AL"		"^"		"AOl")
(add-phonemic-rule :Anything	"ALK"		:Anything	"AOk")
(add-phonemic-rule "#:"		"ALS"		:Nothing	"AXlz")
(add-phonemic-rule "#:"		"AL"		:Nothing	"AXl")
(add-phonemic-rule :Anything	"AU"		:Anything	"AO")
(add-phonemic-rule :Anything	"AY"		:Anything	"EY")
(add-phonemic-rule :Anything	"AI"		:Anything	"EY")
(add-phonemic-rule :Anything	"AIR"		:Anything	"EHr")
(add-phonemic-rule :Anything	"AR"		:Anything	"AAr")
(add-phonemic-rule :Anything	"AR"		:Nothing	"ER")
(add-phonemic-rule " :"		"AR"		:Nothing	"AAr")
(add-phonemic-rule :Anything	"ARR"		:Anything	"AEr")
(add-phonemic-rule :Nothing	"ARR"		:Anything	"AXr")
(add-phonemic-rule :Anything	"A"		"^%"		"EY")
(add-phonemic-rule " :"		"A"		"^+ "		"EY")
(add-phonemic-rule :Anything	"A"		"^+:#"		"AE")
(add-phonemic-rule "#:"		"AG"		"E"		"IHj")
(add-phonemic-rule :Anything	"AGAIN"		:Anything	"AXgEHn")
(add-phonemic-rule :Nothing	"AL"		"#"		"AXl")
(add-phonemic-rule "#:"		"ALLY"		:Anything	"AXlIY")
(add-phonemic-rule :Anything	"A"		"^+#"		"EY")
(add-phonemic-rule " :"		"ANY"		:Anything	"EHnIY")
(add-phonemic-rule :Anything	"AW"		:Anything	"AO")
(add-phonemic-rule :Anything	"A"		"WA"		"AX")
(add-phonemic-rule "^"		"AS"		"#"		"EYs")
(add-phonemic-rule :Anything	"AR"		"#"		"EHr")
(add-phonemic-rule :Nothing	"AR"		"O"		"AXr")
(add-phonemic-rule :Nothing	"ARE"		:Nothing	"AAr")
(add-phonemic-rule :Anything	"A"		:Nothing	"AX")

(add-phonemic-rule :Anything	"B"		:Anything	"b")
(add-phonemic-rule :Anything	"BUIL"		:Anything	"bIHl")
(add-phonemic-rule :Nothing	"BUS"		"#"		"bIHz")
(add-phonemic-rule :Nothing	"BOTH"		:Nothing	"bOWTH")
(add-phonemic-rule :Anything	"BEING"		:Anything	"bIYIHNG")
(add-phonemic-rule :Nothing	"BE"		"^#"		"bIH")

(add-phonemic-rule :Anything	"C"		:Anything	"k")
(add-phonemic-rule :Anything	"COM"		"%"		"kAHm")
(add-phonemic-rule :Anything	"CK"		:Anything	"k")
(add-phonemic-rule :Anything	"C"		"+"		"s")
(add-phonemic-rule :Anything	"CI"		"EN"		"SH")
(add-phonemic-rule :Anything	"CI"		"O"		"SH")
(add-phonemic-rule :Anything	"CI"		"A"		"SH")
(add-phonemic-rule " S"		"CI"		"#"		"sAY")
(add-phonemic-rule :Anything	"CH"		:Anything	"CH")
(add-phonemic-rule "^E"		"CH"		:Anything	"k")
(add-phonemic-rule :Nothing	"CH"		"^"		"k")

(add-phonemic-rule :Anything	"D"		:Anything	"d")
(add-phonemic-rule :Anything	"DU"		"A"		"jUW")
(add-phonemic-rule :Nothing	"DOW"		:Anything	"dAW")
(add-phonemic-rule :Nothing	"DOING"		:Anything	"dUWIHNG")
(add-phonemic-rule :Nothing	"DOES"		:Anything	"dAHz")
(add-phonemic-rule :Nothing	"DO"		:Nothing	"dUW")
(add-phonemic-rule :Nothing	"DE"		"^#"		"dIH")
(add-phonemic-rule "#:^E"	"D"		:Nothing	"t")
(add-phonemic-rule ".E"		"D"		:Nothing	"d")
(add-phonemic-rule "#:"		"DED"		:Nothing	"dIHd")

(add-phonemic-rule :Anything	"E"		:Anything	"EH")
(add-phonemic-rule :Anything	"EU"		:Anything	"yUW")
(add-phonemic-rule :Anything	"EY"		:Anything	"IY")
(add-phonemic-rule :Nothing	"EYE"		:Anything	"AY")
(add-phonemic-rule :Anything	"EI"		:Anything	"IY")
(add-phonemic-rule :Anything	"EIGH"		:Anything	"EY")
(add-phonemic-rule :Anything	"EA"		:Anything	"IY")
(add-phonemic-rule :Anything	"EA"		"SU"		"EH")
(add-phonemic-rule "#:"		"EA"		:Nothing	"IYAX")
(add-phonemic-rule :Anything	"EAD"		:Anything	"EHd")
(add-phonemic-rule :Nothing	"EAR"		"^"		"ER")
(add-phonemic-rule :Anything	"EARN"		:Anything	"ERn")
(add-phonemic-rule :Anything	"EE"		:Anything	"IY")
(add-phonemic-rule :Anything	"EFUL"		:Anything	"fUHl")
(add-phonemic-rule "#:"		"EMENT"		:Anything	"mEHnt")
(add-phonemic-rule "#:"		"ELY"		:Nothing	"lIY")
(add-phonemic-rule "#:"		"E"		"S "		Silent)
(add-phonemic-rule "#:SH"	"ES"		:Nothing	"IHz")
(add-phonemic-rule "#:CH"	"ES"		:Nothing	"IHz")
(add-phonemic-rule "#:J"	"ES"		:Nothing	"IHz")
(add-phonemic-rule "#:X"	"ES"		:Nothing	"IHz")
(add-phonemic-rule "#:Z"	"ES"		:Nothing	"IHz")
(add-phonemic-rule "#:G"	"ES"		:Nothing	"IHz")
(add-phonemic-rule "#:C"	"ES"		:Nothing	"IHz")
(add-phonemic-rule "#:S"	"ES"		:Nothing	"IHz")
(add-phonemic-rule :Anything	"E"		"O"		"IY")
(add-phonemic-rule :Anything	"EW"		:Anything	"yUW")
(add-phonemic-rule "SH"		"EW"		:Anything	"UW")
(add-phonemic-rule "CH"		"EW"		:Anything	"UW")
(add-phonemic-rule "TH"		"EW"		:Anything	"UW")
(add-phonemic-rule "J"		"EW"		:Anything	"UW")
(add-phonemic-rule "N"		"EW"		:Anything	"UW")
(add-phonemic-rule "Z"		"EW"		:Anything	"UW")
(add-phonemic-rule "L"		"EW"		:Anything	"UW")
(add-phonemic-rule "D"		"EW"		:Anything	"UW")
(add-phonemic-rule "R"		"EW"		:Anything	"UW")
(add-phonemic-rule "S"		"EW"		:Anything	"UW")
(add-phonemic-rule "T"		"EW"		:Anything	"UW")
(add-phonemic-rule "#:"		"E"		"W"		Silent)
(add-phonemic-rule :Nothing	"EVEN"		:Anything	"IYvEHn")
(add-phonemic-rule :Anything	"ER"		:Anything	"ER")
(add-phonemic-rule :Anything	"ER"		"#"		"EHr")
(add-phonemic-rule "#:"		"ER"		"#"		"ER")
(add-phonemic-rule :Anything	"ERI"		:Anything	"EHrIH")
(add-phonemic-rule :Anything	"ERI"		"#"		"IYrIY")
(add-phonemic-rule :Anything	"E"		"^%"		"IY")
(add-phonemic-rule :Anything	"EV"		"ER"		"EHv")
(add-phonemic-rule "#:"		"E"		"D "		Silent)
(add-phonemic-rule "#"		"ED"		:Nothing	"d")
(add-phonemic-rule " :"		"E"		:Nothing	"IY")
(add-phonemic-rule "':^"	"E"		:Nothing	Silent)
(add-phonemic-rule "#:"		"E"		:Nothing	Silent)

(add-phonemic-rule :Anything	"F"		:Anything	"f")
(add-phonemic-rule :Anything	"FUL"		:Anything	"fUHl")

(add-phonemic-rule :Anything	"G"		:Anything	"g")
(add-phonemic-rule "#"		"GH"		:Anything	Silent)
(add-phonemic-rule :Anything	"GREAT"		:Anything	"grEYt")
(add-phonemic-rule :Anything	"G"		"+"		"j")
(add-phonemic-rule " B#"	"G"		:Anything	"g")
(add-phonemic-rule :Anything	"GG"		:Anything	"g")
(add-phonemic-rule "SU"		"GGES"		:Anything	"gjEHs")
(add-phonemic-rule :Anything	"GE"		"T"		"gEH")
(add-phonemic-rule :Nothing	"G"		"I^"		"g")
(add-phonemic-rule :Anything	"GIV"		:Anything	"gIHv")

(add-phonemic-rule :Anything	"H"		:Anything	Silent)
(add-phonemic-rule :Anything	"H"		"#"		"h")
(add-phonemic-rule :Anything	"HOW"		:Anything	"hAW")
(add-phonemic-rule :Nothing	"HOUR"		:Anything	"AWER")
(add-phonemic-rule :Nothing	"HERE"		:Anything	"hIYr")
(add-phonemic-rule :Nothing	"HAV"		:Anything	"hAEv")

(add-phonemic-rule :Anything	"I"		:Anything	"IH")
(add-phonemic-rule :Anything	"IQUE"		:Anything	"IYk")
(add-phonemic-rule :Anything	"IGN"		"%"		"AYn")
(add-phonemic-rule :Anything	"IGN"		"^"		"AYn")
(add-phonemic-rule :Anything	"IGN"		:Nothing	"AYn")
(add-phonemic-rule :Anything	"ILD"		:Anything	"AYld")
(add-phonemic-rule :Anything	"IGH"		:Anything	"AY")
(add-phonemic-rule :Anything	"IR"		:Anything	"ER")
(add-phonemic-rule :Anything	"I"		"^+"		"AY")
(add-phonemic-rule "#:^"	"I"		"^+"		"IH")
(add-phonemic-rule :Anything	"I"		"T%"		"AY")
(add-phonemic-rule "+^"		"I"		"^+"		"IH")
(add-phonemic-rule :Anything	"I"		"D%"		"AY")
(add-phonemic-rule :Anything	"IS"		"%"		"AYz")
(add-phonemic-rule :Anything	"IZ"		"%"		"AYz")
(add-phonemic-rule :Anything	"IR"		"#"		"AYr")
(add-phonemic-rule :Anything	"I"		"^+:#"		"IH")
(add-phonemic-rule :Anything	"IE"		:Anything	"IY")
(add-phonemic-rule :Anything	"I"		"%"		"IY")
(add-phonemic-rule " :"		"I"		"%"		"AY")
(add-phonemic-rule :Anything	"IE"		"T"		"AYEH")
(add-phonemic-rule :Anything	"IEN"		:Anything	"IYEHn")
(add-phonemic-rule :Anything	"IED"		:Nothing	"AYd")
(add-phonemic-rule "#:R"	"IED"		:Anything	"IYd")
(add-phonemic-rule :Anything	"IER"		:Anything	"IYER")
(add-phonemic-rule :Anything	"IN"		"D"		"AYn")
(add-phonemic-rule :Nothing	"IN"		:Anything	"IHn")

(add-phonemic-rule :Anything	"J"		:Anything	"j")

(add-phonemic-rule :Anything	"K"		:Anything	"k")
(add-phonemic-rule :Nothing	"K"		"N"		Silent)

(add-phonemic-rule :Anything	"L"		:Anything	"l")
(add-phonemic-rule :Anything	"LEAD"		:Anything	"lIYd")
(add-phonemic-rule "#:^"	"L"		"%"		"AXl")
(add-phonemic-rule "L"		"L"		:Anything	Silent)
(add-phonemic-rule :Anything	"LO"		"C#"		"lOW")

(add-phonemic-rule :Anything	"M"		:Anything	"m")
(add-phonemic-rule :Anything	"MOV"		:Anything	"mUWv")

(add-phonemic-rule :Anything	"N"		:Anything	"n")
(add-phonemic-rule :Nothing	"NOW"		:Nothing	"nAW")
(add-phonemic-rule :Anything	"NK"		:Anything	"NGk")
(add-phonemic-rule :Anything	"NG"		:Anything	"NG")
(add-phonemic-rule :Anything	"NGL"		"%"		"NGgAXl")
(add-phonemic-rule :Anything	"NG"		"#"		"NGg")
(add-phonemic-rule :Anything	"NG"		"R"		"NGg")
(add-phonemic-rule "E"		"NG"		"+"		"nj")

(add-phonemic-rule :Anything	"O"		:Anything	"AA")
(add-phonemic-rule "#:^"	"OM"		:Anything	"AHm")
(add-phonemic-rule :Anything	"OSS"		:Nothing	"AOs")
(add-phonemic-rule :Anything	"OTHER"		:Anything	"AHDHER")
(add-phonemic-rule :Anything	"OF"		"^"		"AOf")
(add-phonemic-rule :Anything	"O"		"ST "		"OW")
(add-phonemic-rule "#^"		"ON"		:Anything	"AXn")
(add-phonemic-rule "#:"		"ON"		:Nothing	"AXn")
(add-phonemic-rule "I"		"ON"		:Anything	"AXn")
(add-phonemic-rule " :^"	"O"		"N"		"AH")
(add-phonemic-rule :Anything	"O"		"NG"		"AO")
(add-phonemic-rule "C"		"O"		"N"		"AA")
(add-phonemic-rule :Anything	"ON'T"		:Anything	"OWnt")
(add-phonemic-rule :Nothing	"ONCE"		:Anything	"wAHns")
(add-phonemic-rule :Nothing	"ONLY"		:Anything	"OWnlIY")
(add-phonemic-rule :Anything	"OA"		:Anything	"OW")
(add-phonemic-rule :Anything	"O"		:Nothing	"OW")
(add-phonemic-rule :Anything	"O"		"E"		"OW")
(add-phonemic-rule :Anything	"OO"		:Anything	"UW")
(add-phonemic-rule :Anything	"OOD"		:Anything	"UHd")
(add-phonemic-rule :Anything	"OOK"		:Anything	"UHk")
(add-phonemic-rule :Anything	"OOR"		:Anything	"AOr")
(add-phonemic-rule :Anything	"OI"		:Anything	"OY")
(add-phonemic-rule :Anything	"OING"		:Anything	"OWIHNG")
(add-phonemic-rule :Anything	"OY"		:Anything	"OY")
(add-phonemic-rule :Anything	"OU"		:Anything	"AW")
(add-phonemic-rule :Anything	"OUP"		:Anything	"UWp")
(add-phonemic-rule "^"		"OU"		"^L"		"AH")
(add-phonemic-rule :Anything	"OULD"		:Anything	"UHd")
(add-phonemic-rule :Anything	"OUR"		:Anything	"AOr")
(add-phonemic-rule :Anything	"OUS"		:Anything	"AXs")
(add-phonemic-rule "H"		"OU"		"S#"		"AW")
(add-phonemic-rule :Nothing	"OU"		:Anything	"AW")
(add-phonemic-rule :Anything	"OUGH"		:Anything	"AHf")
(add-phonemic-rule :Anything	"OUGHT"		:Anything	"AOt")
(add-phonemic-rule :Anything	"OL"		"D"		"OWl")
(add-phonemic-rule :Anything	"O"		"^I#"		"OW")
(add-phonemic-rule :Anything	"O"		"^EN"		"OW")
(add-phonemic-rule :Anything	"O"		"^%"		"OW")
(add-phonemic-rule :Anything	"OV"		:Anything	"AHv")
(add-phonemic-rule :Nothing	"OVER"		:Anything	"OWvER")
(add-phonemic-rule :Anything	"OW"		:Anything	"OW")
(add-phonemic-rule :Nothing	"ONE"		:Anything	"wAHn")
(add-phonemic-rule :Anything	"OR"		:Anything	"AOr")
(add-phonemic-rule "#:"		"ORS"		:Nothing	"ERz")
(add-phonemic-rule "#:"		"OR"		:Nothing	"ER")
(add-phonemic-rule :Anything	"OROUGH"	:Anything	"EROW")
(add-phonemic-rule :Anything	"OF"		:Nothing	"AXv")

(add-phonemic-rule :Anything	"P"		:Anything	"p")
(add-phonemic-rule :Anything	"PUT"		:Nothing	"pUHt")
(add-phonemic-rule :Anything	"POW"		:Anything	"pAW")
(add-phonemic-rule :Anything	"PEOP"		:Anything	"pIYp")
(add-phonemic-rule :Anything	"PH"		:Anything	"f")

(add-phonemic-rule :Anything	"Q"		:Anything	"k")
(add-phonemic-rule :Anything	"QU"		:Anything	"kw")
(add-phonemic-rule :Anything	"QUAR"		:Anything	"kwAOr")

(add-phonemic-rule :Anything	"R"		:Anything	"r")
(add-phonemic-rule :Nothing	"RE"		"^#"		"rIY")

(add-phonemic-rule :Anything	"S"		:Anything	"s")
(add-phonemic-rule "#"		"SN"		"'"		"zAXn")
(add-phonemic-rule "#"		"SM"		:Anything	"zm")
(add-phonemic-rule :Anything	"S"		"C+"		Silent)
(add-phonemic-rule :Nothing	"SCH"		:Anything	"sk")
(add-phonemic-rule " :#"	"S"		:Nothing	"z")
(add-phonemic-rule "U"		"S"		:Nothing	"s")
(add-phonemic-rule "#:^#"	"S"		:Nothing	"s")
(add-phonemic-rule "#:^##"	"S"		:Nothing	"z")
(add-phonemic-rule "#:.E"	"S"		:Nothing	"z")
(add-phonemic-rule "."		"S"		:Nothing	"z")
(add-phonemic-rule :Anything	"S"		"S"		Silent)
(add-phonemic-rule "^"		"SION"		:Anything	"SHAXn")
(add-phonemic-rule :Anything	"SAID"		:Anything	"sEHd")
(add-phonemic-rule "#"		"S"		"#"		"z")
(add-phonemic-rule "#"		"SED"		:Nothing	"zd")
(add-phonemic-rule "#"		"SSU"		"#"		"SHUW")
(add-phonemic-rule "#"		"SU"		"#"		"ZHUW")
(add-phonemic-rule :Anything	"SUR"		"#"		"SHER")
(add-phonemic-rule "#"		"SUR"		"#"		"ZHER")
(add-phonemic-rule :Anything	"SOME"		:Anything	"sAHm")
(add-phonemic-rule "#"		"SION"		:Anything	"ZHAXn")
(add-phonemic-rule :Anything	"SH"		:Anything	"SH")

(add-phonemic-rule :Anything	"T"		:Anything	"t")
(add-phonemic-rule :Nothing	"TWO"		:Anything	"tUW")
(add-phonemic-rule :Anything	"TU"		"A"		"CHUW")
(add-phonemic-rule :Anything	"TUR"		"#"		"CHER")
(add-phonemic-rule :Anything	"TIEN"		:Anything	"SHAXn")
(add-phonemic-rule :Anything	"TI"		"A"		"SH")
(add-phonemic-rule :Anything	"TI"		"O"		"SH")
(add-phonemic-rule "S"		"TI"		"#N"		"CH")
(add-phonemic-rule "#:"		"TED"		:Nothing	"tIHd")
(add-phonemic-rule :Anything	"TH"		:Anything	"TH")
(add-phonemic-rule :Nothing	"THUS"		:Anything	"DHAHs")
(add-phonemic-rule :Anything	"THOUGH"	:Nothing	"DHOW")
(add-phonemic-rule :Anything	"THOSE"		:Anything	"DHOWz")
(add-phonemic-rule :Anything	"THROUGH"	:Anything	"THrUW")
(add-phonemic-rule :Nothing	"THEN"		:Anything	"DHEHn")
(add-phonemic-rule :Anything	"THESE"		:Nothing	"DHIYz")
(add-phonemic-rule :Nothing	"THEM"		:Nothing	"DHEHm")
(add-phonemic-rule :Nothing	"THAN"		:Nothing	"DHAEn")
(add-phonemic-rule :Anything	"THEIR"		:Anything	"DHEHr")
(add-phonemic-rule :Anything	"THER"		:Anything	"DHER")
(add-phonemic-rule :Nothing	"THERE"		:Anything	"DHEHr")
(add-phonemic-rule :Nothing	"THEY"		:Anything	"DHEY")
(add-phonemic-rule :Nothing	"THIS"		:Nothing	"DHIHs")
(add-phonemic-rule :Anything	"THAT"		:Nothing	"DHAEt")
(add-phonemic-rule :Anything	"TO"		:Nothing	"tUW")
(add-phonemic-rule :Nothing	"THE"		:Nothing	"DHAX")

(add-phonemic-rule :Anything	"U"		:Anything	"yUW")
(add-phonemic-rule "SH"		"U"		:Anything	"UW")
(add-phonemic-rule "CH"		"U"		:Anything	"UW")
(add-phonemic-rule "TH"		"U"		:Anything	"UW")
(add-phonemic-rule "J"		"U"		:Anything	"UW")
(add-phonemic-rule "N"		"U"		:Anything	"UW")
(add-phonemic-rule "Z"		"U"		:Anything	"UW")
(add-phonemic-rule "L"		"U"		:Anything	"UW")
(add-phonemic-rule "D"		"U"		:Anything	"UW")
(add-phonemic-rule "R"		"U"		:Anything	"UW")
(add-phonemic-rule "S"		"U"		:Anything	"UW")
(add-phonemic-rule "T"		"U"		:Anything	"UW")
(add-phonemic-rule "#N"		"U"		:Anything	"yUW")
(add-phonemic-rule "G"		"U"		"#"		"w")
(add-phonemic-rule "G"		"U"		"%"		Silent)
(add-phonemic-rule " G"		"U"		"#"		Silent)
(add-phonemic-rule :Anything	"UY"		:Anything	"AY")
(add-phonemic-rule :Anything	"U"		"^^"		"AH")
(add-phonemic-rule :Anything	"U"		"^ "		"AH")
(add-phonemic-rule :Anything	"UR"		:Anything	"ER")
(add-phonemic-rule :Anything	"UR"		"#"		"yUHr")
(add-phonemic-rule "SH"		"UR"		"#"		"UHr")
(add-phonemic-rule "CH"		"UR"		"#"		"UHr")
(add-phonemic-rule "TH"		"UR"		"#"		"UHr")
(add-phonemic-rule "J"		"UR"		"#"		"UHr")
(add-phonemic-rule "N"		"UR"		"#"		"UHr")
(add-phonemic-rule "Z"		"UR"		"#"		"UHr")
(add-phonemic-rule "L"		"UR"		"#"		"UHr")
(add-phonemic-rule "D"		"UR"		"#"		"UHr")
(add-phonemic-rule "R"		"UR"		"#"		"UHr")
(add-phonemic-rule "S"		"UR"		"#"		"UHr")
(add-phonemic-rule "T"		"UR"		"#"		"UHr")
(add-phonemic-rule :Nothing	"UPON"		:Anything	"AXpAOn")
(add-phonemic-rule :Nothing	"UN"		:Anything	"AHn")
(add-phonemic-rule :Nothing	"UN"		"I"		"yUWn")

(add-phonemic-rule :Anything	"V"		:Anything	"v")
(add-phonemic-rule :Anything	"VIEW"		:Anything	"vyUW")

(add-phonemic-rule :Anything	"W"		:Anything	"w")
(add-phonemic-rule :Anything	"WR"		:Anything	"r")
(add-phonemic-rule :Anything	"WOR"		"^"		"wER")
(add-phonemic-rule :Anything	"WAR"		:Anything	"wAOr")
(add-phonemic-rule :Anything	"WH"		:Anything	"WH")
(add-phonemic-rule :Anything	"WHO"		:Anything	"hUW")
(add-phonemic-rule :Anything	"WHOL"		:Anything	"hOWl")
(add-phonemic-rule :Anything	"WHAT"		:Anything	"WHAAt")
(add-phonemic-rule :Anything	"WHERE"		:Anything	"WHEHr")
(add-phonemic-rule :Anything	"WA"		"T"		"wAA")
(add-phonemic-rule :Anything	"WA"		"S"		"wAA")
(add-phonemic-rule :Nothing	"WERE"		:Anything	"wER")

(add-phonemic-rule :Anything	"X"		:Anything	"ks")

(add-phonemic-rule :Anything	"Y"		:Anything	"IH")
(add-phonemic-rule " :"		"Y"		"^#"		"AY")
(add-phonemic-rule " :"		"Y"		"^+:#"		"IH")
(add-phonemic-rule " :"		"Y"		"#"		"AY")
(add-phonemic-rule " :"		"Y"		:Nothing	"AY")
(add-phonemic-rule "#:^"	"Y"		"I"		"IY")
(add-phonemic-rule "#:^"	"Y"		:Nothing	"IY")
(add-phonemic-rule :Nothing	"Y"		:Anything	"y")
(add-phonemic-rule :Nothing	"YES"		:Anything	"yEHs")
(add-phonemic-rule :Nothing	"YOU"		:Anything	"yUW")
(add-phonemic-rule :Anything	"YOUNG"		:Anything	"yAHNG")

(add-phonemic-rule :Anything	"Z"		:Anything	"z")

;1; Make sure we can always say the alphabet:*
(add-phonemic-rule :Nothing	"A"		:Nothing	"EY")
(add-phonemic-rule :Nothing	"B"		:Nothing	"bIY")
(add-phonemic-rule :Nothing	"C"		:Nothing	"sIY")
(add-phonemic-rule :Nothing	"D"		:Nothing	"dIY")
(add-phonemic-rule :Nothing	"E"		:Nothing	"IY")
(add-phonemic-rule :Nothing	"F"		:Nothing	"EHf")
(add-phonemic-rule :Nothing	"G"		:Nothing	"jIY")
(add-phonemic-rule :Nothing	"H"		:Nothing	"EYtCH")
(add-phonemic-rule :Nothing	"I"		:Nothing	"AY")
(add-phonemic-rule :Nothing	"J"		:Nothing	"jEY")
(add-phonemic-rule :Nothing	"K"		:Nothing	"kEY")
(add-phonemic-rule :Nothing	"L"		:Nothing	"EHl")
(add-phonemic-rule :Nothing	"M"		:Nothing	"EHm")
(add-phonemic-rule :Nothing	"N"		:Nothing	"EHn")
(add-phonemic-rule :Nothing	"O"		:Nothing	"AA")
(add-phonemic-rule :Nothing	"P"		:Nothing	"pIY")
(add-phonemic-rule :Nothing	"Q"		:Nothing	"kw")
(add-phonemic-rule :Nothing	"R"		:Nothing	"AAr")
(add-phonemic-rule :Nothing	"S"		:Nothing	"EHz")
(add-phonemic-rule :Nothing	"T"		:Nothing	"tIY")
(add-phonemic-rule :Nothing	"U"		:Nothing	"AHw")
(add-phonemic-rule :Nothing	"V"		:Nothing	"vIY")
(add-phonemic-rule :Nothing	"W"		:Nothing	"dAHblyUWw")
(add-phonemic-rule :Nothing	"X"		:Nothing	"EHks")
(add-phonemic-rule :Nothing	"Y"		:Nothing	"wAYIY")
(add-phonemic-rule :Nothing	"Z"		:Nothing	"zEHd")
