;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI) -*-

;1;; File "3SENDMAIL-FINGER*".*
;1;; Makes the list of addresses that send-mail prints out be mouseable; you can finger someone by clicking on their address.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   14 Nov 89*	1Jamie Zawinski*	1Created.*
;1;;*

(w:add-typeout-item-type *typeout-command-alist* address "2Finger User*" typeout-finger-address t
			 "2Finger this host or address.*")
(w:add-typeout-item-type *typeout-command-alist* address "2Describe Host*" typeout-describe-host nil
			 "2Describe this host or address.*")

(defmacro 4with-pop-up-output *(label &body body)
  "2For the duration of body, bind *terminal-io* and *standard-output* to a pop-up window (like Terminal-F uses).*"
  (let* ((window (gensym)))
    `(using-resource (,window tv:pop-up-finger-window)
       (setf (tv:sheet-truncate-line-out-flag ,window) 1)
       (send ,window :set-process w:current-process)
       (send ,window :set-label ,label)
       (tv:window-call (,window :deactivate)
	 (let* ((*terminal-io* ,window)
		(*debug-io* ,window))
	   (progn ,@body
		  (unwind-protect (progn
				    (send ,window :set-current-font fonts:hl12bi t)
				    (format ,window "3~2%Any character to flush.*")
				    (send ,window :any-tyi))
		    (send ,window :set-current-font 0))))))))


(defun 4typeout-finger-address *(thing)
  "2Called by clicking on a mouse-sensitive text item.  If the thing clicked on is an address or host, finger it.*"
  (flet ((finger (host user-id)
	   (with-pop-up-output (format nil "3Fingering ~A@~A...*" (or user-id "") host)
	     (with-open-stream (finger-stream (send host :show-users :connect (or user-id "")))
	       (fresh-line)
	       (if (typep finger-stream 'condition)
		   (princ finger-stream)
		   (sys:stream-copy-until-eof finger-stream *standard-output*))))))
    (etypecase thing
      (MAIL:ADDRESS
       (let* ((host (send thing :destination-host))
	      (name (send thing :local-part-string)))
	 (if host
	     (finger host name)
	     (format t "3~&Host unknown.*" 'zwei:address host))))
      (NET:HOST
       (finger thing ""))
      (STRING
       (block nil
	 (if (position #\@ thing)
	     (typeout-finger-address (or (mail:parse-address thing 0 nil nil :address t)
					 (return (format t "3~&~S unrecognised.*" thing))))
	     (typeout-finger-address (or (net:parse-host thing t nil)
					 (return (format t "3~&~S unrecognised.*" thing))))))))))

(defun 4typeout-describe-host *(thing)
  "2Called by clicking on a mouse-sensitive text item.  If the thing clicked on is an address or host, prettily describe the host it represents.*"
  (etypecase thing
    (MAIL:ADDRESS
     (let* ((host (send thing :destination-host)))
       (if host
	   (typeout-describe-host host)
	   (format t "3~&Unknown host.*"))))
    (NET:HOST
     (with-pop-up-output (format nil "3Describing host ~A...*" thing)
       (format t "3~&Host ~A, in domain ~A of site ~A*" thing (send thing :domain) (send thing :site))
       (format t "3~&System Type: ~A*" (send thing :system-type))
       (format t "3~&Addresses: *")
       (dolist (cons (send thing :addresses))
	 (format t "3~13t~8A *" (car cons))
	 (funcall (get (car cons) :network-address-printer) (cadr cons) *standard-output* nil)
	 (terpri))
       (format t "3~&Services: ~{~13t~S~%~}*" (send thing :service-list))
       (flet ((show-plist (plist)
		(do* ((rest plist (cddr rest)))
		     ((null rest))
		  (format t "3~13t~A~35t~A~%*" (car rest) (cadr rest)))))
	 (format t "3~&Attributes:~%*")
	 (show-plist (send thing :host-attributes))
	 (format t "3~&Properties:~%*")
	 (show-plist (send thing :property-list)))))
    (STRING
     (block nil
       (if (position #\@ thing)
	   (typeout-describe-host (or (mail:parse-address thing 0 nil nil :address t)
				      (return (format t "3~&~S unrecognised.*" thing))))
	   (typeout-describe-host (or (net:parse-host thing t nil)
				      (return (format t "3~&~S unrecognised.*" thing)))))))))


;1;; jwz: modified this to use 5~vM* instead of 5~A* so that hosts and addresses are printed mousably.*
;1;;*
(defun 4mail:print-address-disposition* (stream address disposition arg report)
  (case disposition
    (:delivered
     ;1; arg is host that accepted*
     (setf (get address :last-delivery-host) arg)
     (format stream "3~&~vM~16T-- Delivered to host ~vM*" 'ZWEI:ADDRESS address
	     'ZWEI:ADDRESS (mail:short-host-string arg)))
    (:rejected
     ;1; arg is host that rejected*
     (setf (get address :last-delivery-host) arg)
     (format stream "3~&~vM~16T-- Rejected by host ~vM: ~A*" 'ZWEI:ADDRESS address
	     'ZWEI:ADDRESS (mail:short-host-string arg) report))
    (:translated 
     (when arg
       ;1; arg is new address or a string*
       (format stream "3~&~vM~16T-- Translated to ~vM*" 'ZWEI:ADDRESS address 'ZWEI:ADDRESS arg)))
    (:forward-unknown
     (format stream "3~&~vM~16T-- Unknown.  Fowarding to a primary server.*" 'ZWEI:ADDRESS address))
    (:expansion-error
     ;1; arg is address that expanded into a mailing list*
     (format stream "3~&~vM~16T-- ~A  (from mailing list ~:@(~A~))*"
	     'ZWEI:ADDRESS address report arg))
    (:deferred
     (format stream "3~&~vM~16T-- Deferred.  ~A*" 'ZWEI:ADDRESS address report))
    (:queued
     (format stream "3~&~vM~16T-- Queued for ~A*" 'ZWEI:ADDRESS address
	     (cond ((eq arg :uucp)
		    "3UUCP gateway host.*")
		   ((eq arg :server)
		    "3a primary mail server.*")
		   (t
		    (mail:short-host-string arg)))))
    (:smtp-error
     (format stream "3~&~vM~16T-- SMTP error with ~A: ~A*" 'ZWEI:ADDRESS address (mail:short-host-string arg) report))
    ((:expanded :translated)
     )
    (:otherwise
     (if report
	 (format stream "3~&~vM~16T-- ~A*" 'ZWEI:ADDRESS address report)
	 (format stream "3~&~vM~16T-- Status unknown. ~@[~A~]*" 'ZWEI:ADDRESS address disposition)))))
