;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TV; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONTB HL12B CPTFONTBI HL12BI) -*-

;1;; File "3RORSCHACH-SCREENHACK*".*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   27 Jul 89*	1Jamie Zawinski*	1Created, based on some code from Peter Norvig.*
;1;;*  123 Feb 90*	1Jamie Zawinski *	1Added a fancy fade, lifted from John Nguyen's 5Helix* demo.*
;1;;*


;1;; 5Rorschach!7  (hurm...)***
;1;;*

(defun 4rorschach *(&optional (y-symmetry t) (x-symmetry t) (jump 5) (window tv:selected-window) (iterations 4000))
  "2I'm fine, Happy Harry.  Yourself?*"
  (declare (fixnum iterations jump))
  (let* ((width  (1- (tv:sheet-inside-width window)))
	 (height (1- (tv:sheet-inside-height window)))
	 (screen-array (tv:sheet-screen-array window))
	 (fg (if (w:color-system-p window) (tv:sheet-foreground-color window) 1)))
    (declare (fixnum width height)
	     (optimize speed (safety 0)))
    (flet ((4+-random* (n)
	3    * "2Returns a random integer from -n to +n*"
	      (- (random (1+ (* n 2))) n))
	   (4dp* (x y)
	     "2Draw a point.*"
	     (setf (aref screen-array y x) fg)))
      (tv:prepare-sheet (window)
	(do* ((x (round width  2) (max 0 (min width  (+ x (+-random jump)))))
	      (y (round height 2) (max 0 (min height (+ y (+-random jump)))))
	      (i 0 (1+ i)))
	     ((> i iterations))
	  (declare (fixnum x y i))
	  (dp x y)
	  (when y-symmetry (dp x (- height y)))
	  (when x-symmetry (dp (- width x) y))
	  (when (and x-symmetry y-symmetry)
	    (dp (- width x) (- height y))))))))

(defun 4rorschach-screenhack *(&optional (window tv:selected-window))
    (send window :clear-screen)
  (loop
    (rorschach nil t 5 window 6000)
    (let ((height (send window :height))
	  (width (send window :width))
	  (array (send window :screen-array)))
      (sleep 2)
      (dotimes (i (lsh height 1))
	(let ((line (random height)))
	  (tv:%draw-line 0 line width line w:erase t array)))
      (send window :clear-screen)
      (sleep 1))))

(when (boundp 'tv:*screen-saver-hacks-list*)
  (pushnew 'RORSCHACH-SCREENHACK tv:*screen-saver-hacks-list*))
