;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Fonts:(CPTFONT HL12B HL12I MEDFNB) -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;1;;*
;1;; Defparameters*
;1;;*
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defparameter 4*BACKUP-NEWSRC-FILE-APPEND-STRING** "~")

(defparameter 4*DEFAULT-CVV-MARGIN-CHOICES** '("2Do it []*" ("Abort []" (SIGNAL-CONDITION EH:*ABORT-OBJECT*)))
  "2Exit Options*")

(defparameter 4*DEFAULT-FORWARD-NEWS-MAIL-TEMPLATE** 'zwei:default-forward-news-mail-template
  "2Mail template to use when forwarding a news article.*")

(defparameter 4*DEFAULT-POST-NEWS-MAIL-TEMPLATE** 'zwei:default-post-news-mail-template
  "2Mail template to use when posting a news article to a newsgroup.*")

(defparameter 4*DEFAULT-REPLY-NEWS-MAIL-TEMPLATE** 'zwei:default-reply-news-mail-template
  "2Mail template to use when replying to a news article.*")

(defparameter 4*END-INDEX** -2
  "2Index indicating end of news.*")

(defparameter 4*EN-MOUSE-R**
	      '(("Write newsrc file"
		 :value write-the-newsrc-file
		 :documentation "Write out the newsrc file to the specified file.")
		
		("Change newsrc file/news host"
		 :value configure-news
		 :documentation "Allows you to change the newsrc file and newsrc host.  Note: changing the newsrc filename or news host will cause the news system to be    reinitialized. ")
		
		("Reset news connection"
		 :value reset-the-news-connection
		 :documentation "Clears all pending operations to the news server by closing the current connection.  This command should be used if the news reader gets out of sync with the news server.")
		
		("Restart background news process"
		 :value restart-the-background-news-process
		 :documentation "The background news process checks for new news every 15 minutes (by default).  Restarting the background news process will cause checking for new news immediately.")
		
		("Reinitialize news"
		 :value reinitialize-the-news-system
		 :documentation "Reinitializing the news system means rereading the newsrc file and system newsgroups and discarding the old information in memory.")
	       ))

(defparameter 4*POSTNEWS-WARNING-MESSAGE** "Posting a message to a2 *newsgroup is not the same as mailing a message to a2 *user.  Posting to a3 *newsgroup usually involves sending your message to bulletin boards3 *throughout the world.

Are you sure you want to do this?")

(defparameter 4*MODERATED** #\m
  "2Character indicating a moderated newsgroup.*")

(defparameter 4*NEWSGROUP-SUMMARY-BUFFER-ARTICLE-READ-COLUMN** 4.
  "2Summary buffer column of the read/unread indicator.*")

(defparameter 4*NEWSRC-KEYWORD** "OPTION"
  "2Newsrc keyword.*")

(defparameter 4*ROTL**
	      '("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ" .
		"nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM"))

(defparameter 4*START-INDEX** -1
  "2Index indicating start of news.*")

(defparameter 4*SUBSCRIBED** #\:
  "2Character to indicate a subscribed newsgroup.*")

(defparameter 4*UNSUBSCRIBED** #\!
  "2Character to indicate an unsubscribed newsgroup.*")

(defparameter 4*VERSION** "x22.7*"
  "2Program version number.*")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;1;;*
;1;; Defvars*
;1;;*
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar 4*ARTICLE-COMTAB** nil)

(defvar 4*ARTICLE-CONTROL-X-COMTAB** nil)

(defvar 4*ARTICLE-NUMBER** "")

(defvar 4*ARTICLE-SUBJECT** nil)

(defvar 4*BACKGROUND-CHECK-FOR-NEWNEWS** nil
  "2Background news daemon.*")

(defvar 4*BACKGROUND-CHECK-FOR-NEWNEWS-INTERVAL** 15.
  "2Interval in minutes between checking for new news in background.  Minimum value is 5 minutes.*")

(defvar 4*BOGUS-NEWSGROUP-LIST** nil
  "2List of newsgroups (strings) contained in the newsrc file but not in the system newsgroup file.*")

(defvar 4*BOGUS-NEWSGROUP-LIST-P** nil
  "2When NIL, suppress the listing of the bogus newsgroups during initialization.  A bogus newsgroup is a newsgroup found in your newsrc file but   not on the news host.*")

(defvar 4*DEBUG-EN-NNTP** nil
  "2Display debugging information for EN-... to the nntp server.*")

(defvar 4*DEBUG-EN-STREAM** nil
  "2Debugging output is written to this stream.  By default debugging output is written to *query-io*.*")

(defvar 4*DEFAULT-ARTICLE-SAVE-PATHNAME** nil
  "2Default pathname to use when saving an article into a file.*")

(defvar 4*EN** nil
  "2News window*")

(defvar 4*END-OF-ARTICLE-LINE** "<--------- End of Article --------->"
  "2Line to indicate that you are at the end of the article.*")

(defvar 4*INITIALIZED-NEWS-HOST** NIL
  "2Host that was used to initialize the current news data structures.  This variable is used to determine if the news data structures
must be reinitiazed.  It must not be modified by the user. *")

(defvar 4*INITIALIZED-NEWSRC-FILE** NIL
  "2Newsrc file that was used to initialize the current news data structures.  This variable is used to determine if the news data
structures must be reinitialized.  It must not be modified by the user.*")

(defvar 4*KEEP-BOGUS-P** t
  "2A bogus newsgroup is a newsgroup found in the newsrc file but not on the system.  T means to keep the bogus newsgroup
in the newsrc file.  Nil means to remove bogus newsgroups from the newsrc file.*")

(defvar 4*MAIL-NEWSGROUP-COMPONENT** nil
  "2Newsgroup component used by EN to generate mail templates.*")

(defvar 4*MERGE-NEWSRC-P** :subscribe
  "2When :SUBSCRIBE add the newsgroups contained in the system newsgroup list to the end of the .newsrc file and mark as subscribed.
:UNSUBSCRIBE is the same as :SUBSCRIBE except that the newsgroups are marked as unsubscribed.  :IGNORE means to ignore the system
newsgroups not contained in your .newsrc file.*")

(defvar 4*NEWSGROUP-COMTAB** nil)

(defvar 4*NEWSGROUP-CONTROL-X-COMTAB** nil)

(defvar 4*NEWSGROUP-SUMMARY-BUFFER** nil)

(defvar 4*NEWSGROUP-SUMMARY-COMTAB** nil)

(defvar 4*NEWSGROUP-SUMMARY-TEMPLATE** '(:subject 40 :from 30 :date :brief-date)
  "2List of alternating keyword/value pairs that determines the contents of summary lines and the order of items within each line.
Numeric values may be negative to indicate right justification.
The keywords and values are:
-Keyword--------Value------------------------------------------------------------
:SUBJECT*	2Number of spaces to allow for the message subject field.
:FROM*		2Number of spaces to allow for the message from field.
:DATE*		2:DATE-AND-TIME - Print day, month, year, and time of message.*
		2:DATE - Print day, month, and year of message.*
		2:BRIEF-DATE - Print day and month of message.*")

(defvar 4*NEWSRC-CHANGED** nil
  "2Used to determine whether or not the newsrc information has changed.*")

(defvar 4*NEWS-FILE-VERSIONS-KEPT** 3
  "2Number of old versions of mail files retained after writing out a new version.
When nil (or <= 1), never clean up old versions.*")

(defvar 4*NEWS-INITIALIZED-P** nil
  "2Used in conjunction with the function news-initialized-p do determine if the news system has been initialized.*")

(defvar 4*NEWS-USERNAME** nil
  "2Username that was used to initialize the current news data structures. * 2This variable is* 2used to determine if the news data structures
must be reinitiazed. * 2It must not* 2be modified by the user. * ")
  
(defvar 4*NEWSGROUP-COMPONENT-TABLE** (make-hash-table :size 1000. :test #'equal)
  "2Table containing all the newsgroup-component flavor instances from the system newsgroup file.  The flavor instances are hashed
by the newsgroup name string.*")

(defvar 4*NEWSRC-LIST** nil
  "2Ordered list of newsgroup-component flavor intances created from the newsrc file.*")

(defvar 4*NEWSRC-INDEX** -1
  "2Current index into *newrc-list**")

(defvar 4*NEXT-SCREEN-CONTEXT-LINES-FOR-ARTICLE** 1.
  "2The number of lines of overlap for next screenful of the article.*") 

(defvar 4*NNTP-STREAM** nil
  "2All NNTP activity to the NNTP server is done through this variable.*")

(defvar 4*NNTP-SERVER-STATUS** nil
  "2Open server status Non-nil is active, NIL is inactive.*")

(defvar 4*NNTP-SERVER-MESSAGE** nil
  "2Open server status message.*")

(defvar 4*NNTP-HOST** nil
  "2NNTP server host.*")

(defvar 4*NOTIFY-NEWSGROUP-LIST** nil
  "2A list of newsgroups to check to notify you if there is new news.  T means to notify you if there is any new news.  An example of the format is (\"rec.humor.funny\" \"comp.ai\")*")

(defvar 4*NPQ** "npq")

(defvar 4*POSTNEWS-WARNING-MESSAGE-P** t
  "2When T display the postnews warning message when posting to a newsgroup.*")

(defvar 4*PREVIOUS-NEWSRC-INDEX** -1
  "2Previous index into *newsrc-list**")

(defvar 4*REFORMAT-NEWSHEADERS-INCLUDE-LIST** nil
  "2List of header types to keep when formatting news headers.  Kept headers are also ordered according to this list.
If *reformat-headers-exclude-list* has a value, it takes precedence as to which headers to keep, but this list is
still used for ordering.*")

(defvar 4*REFORMAT-NEWSHEADERS-EXCLUDE-LIST** '(:XREF :NEWSGROUPS :PATH :MESSAGE-ID :ARTICLE-I.D. :POSTED :SENDER
							     :APPROVED :REFERENCES :REPLY-TO :KEYWORDS :SUMMARY
							     :REPLY-PATH)
  "2List of header types to eliminate when formatting news headers.  Takes precedence over *reformat-newsheaders-include-list*,
though the include-list still governs the ordering of headers.*")

(defvar 4*REFORMAT-NEWSHEADERS-FORWARD-INCLUDE-LIST** '(:DATE :FROM :SUBJECT :NEWSGROUPS)
  "2List of header types to include in the forwarded mail message yanked text.  Kept headers are also ordered according to this list.*")

(defvar 4*SAVED-PATHNAME** nil)

(defvar 4*SUBJECT-SEARCH-MODE** nil
  "2T means to enter subject search mode (^N) automatically whenever a newsgroup is started.*")

(defvar 4*SUBJECT-SEARCH-MODE-P** nil
  "2T means we are in subject search mode.*")

(defvar 4*SYSTEM-LIST** nil 
  "2Ordered list of newsgroup-component flavor instances created from the system newsgroups.*")

(defvar 4*USER-DEFAULT-NEWSRC-FILE** nil
  "2Newsrc file.*")

(defvar 4*VERBOSE-ARTICLE-NUMBER** nil)

(defvar 4*MARK-XREF-ARTICLES-P** t
  "2T means to mark XREF articles.  NIL means to ignore XREF articles.  When an article is cross posted to other newsgroups, the XREF
line of the article will contain the cross posted newsgroups and article numbers within those newsgroups.  When an article is read,
junked, or killed, all XREF articles in subscribed newsgroups are also marked as read.  When an article is marked as still unread, all
XREF articles will be marked as read.  Catching up a newsgroup will not mark XREF articles regardless of the value of this variable.*")

(defvar 4*/-STRING** "")






