;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Fonts:(CPTFONT HL12B HL12I MEDFNB) -*-


(defparameter 4*CONFIGURE-NEWS-MENU**
	      '((newsrc-file "Newsrc file"
			     :DOCUMENTATION  "Location of your newsrc file."
			     :pathname)
		(nntp-host "News host"
			   :DOCUMENTATION "Host containing news."
			   :string)))


(defun 4CONFIGURE-NEWS-MENU* (&optional (menu nil))
  "2Validate the newsrc file and news host.  If invalid values or menu is T then display a configuration menu to
allow changes.*"
  
  (let ((newsrc-file *user-default-newsrc-file*)
	(nntp-host *nntp-host*)
	ret)
    (declare (special newsrc-file nntp-host))
    
    (loop 

      (unless (or menu (null newsrc-file) (null nntp-host))
	(cond
	  ;1;;Validate the newsrc file.*
	  ((setf ret (validate-newsrc-filename newsrc-file))
	   (when
	     (cond
	       ((equal ret :new)
		(w:mouse-confirm (format nil "The newsrc file ~a does not exist.  ~a  Do you wish to continue?"
					 newsrc-file
					 (cond
					   ((equal *merge-newsrc-p* :subscribe)
					    "The newsrc file will be created with all the newsgroups marked as subscribed.")
					   ((equal *merge-newsrc-p* :unsubscribe)
					    "The newsrc file will be created with all the newsgroups marked as unsubscribed.")
					   (t
					    "An empty newsrc file will be created.")))))
	       
	       (t t))
	     (setf *user-default-newsrc-file* newsrc-file)
	     (default-newsrc-file)
	     
	     ;1;;Validate the news host.*
	     (cond
	       ((validate-news-host nntp-host)
		(setf *nntp-host* nntp-host)
		(default-news-host)
		(return t))
	       
	       (t
		(w:mouse-confirm (format nil "~a is not a news server" nntp-host) "Press any key to continue.")))))
	  
	  (t
	   (w:mouse-confirm (format nil "Cannot create or access the newsrc file ~a" newsrc-file) "Press any key to continue."))))

      (setf menu nil)
      (w:choose-variable-values
	
	*configure-news-menu*
	
	:label "Configure News"
	:margin-choices *default-cvv-margin-choices*
	:width 60
	))))
      
