;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "3NEWS-FONTS*"*
;1;; Hacks the EN newsreader to put the headers part of news messages in a different font.  Easier on the eyes...*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;     5 Sep 89*	1Jamie Zawinski*	1 Created.*
;1;;*   120 Sep 89*	1Jamie Zawinski *	 1Made the 5V* command (Verbose, or Display All Headers) also fontify the header fields.*
;1;;*   121 Sep 89*	1Jamie Zawinski *	 1Made 5background-check-for-newnews* say which newsgroups have acquired new articles.*
;1;;*    13 Oct 89*	1Jamie Zawinski *	 1Fixed 5background-check-for-newnews* to not mention newsgroups it shouldn't.*
;1;;*   130 Oct 89*	1Jamie Zawinski *	 1Added ``important'' headers, so that one can have the 5Subject:* field in a more noticeable font.*
;1;;* 1 * 131 Oct 89*	1Jamie Zawinski *	 1Added date-field hacking, so I don't have to look at netnews dates in GMT.*
;1;;*  1 12 Dec 89*	1Jamie Zawinski *	 1Made it not write font-change codes when saving to a file or buffer.*
;1;; * 1 14 Dec 89*	1Jamie Zawinski *	 1Fixed the Post command so that it is possible to not be prompted.*
;1;;*				 1Fixed the News-Yank-Message command to say 2"in article <blah> user@host writes:"* instead of*
;1;;*				 2 "in article <blah> 5you* write:"1 which is less than informative for news...**
;1;;*   124 Jan 90*	1Jamie Zawinski *	 1Made the 5Shift-S* command append to buffers instead of overwrite.*

(export '(4*en-fonts** *en-important-headers* 4*en-reformat-dates**))

(defvar 4*en-fonts* *'(FONTS:CPTFONT FONTS:HL12B FONTS:HL12I FONTS:HL12BI FONTS:TR12I)
  "2  The fonts to use in the news reader.  The fonts are used for (in this order):
  message body, header field names, header field bodies, the bodies of ``important'' headers (in *en-important-headers*), and article description lines.*")

(defvar 4*en-important-headers* *'(:subject :keywords) "2The headers to print in the ``important headers'' font.*")

(defvar 4*en-reformat-dates* *t "2If true, then the news reader will convert the Date: field to be in the local time zone (instead of GMT).*")

(profile:define-profile-variable *en-fonts* (:en) :cvv-type :sexp)
(profile:define-profile-variable *en-important-headers* (:en) :cvv-type :sexp)
(profile:define-profile-variable *en-reformat-dates* (:en) :cvv-type :boolean)

(defun 4FIND-OR-CREATE-EN-BUFFER* ()
  "2Return the buffer.*"
  (let (newbuf)
    (or (setq newbuf (find-en-buffer))
	(progn (setq newbuf (make-instance 'explorer-news
					   :name "Explorer News"))
	       (send newbuf :activate)
	       newbuf))
    (send newbuf :set-attribute :fonts *en-fonts* nil)
    (set-buffer-fonts newbuf)
    newbuf))

;1;; new.*
(defun 4write-news-header-field *(stream line &optional fonts-p)
  "2Write out a header line, fontifying the parts before and after the colon, and maybe translating the Date: field.*"
  (terpri stream)
  (when fonts-p (write-char #\Epsilon stream))
  (let* ((colon (and (char-not-equal (char line 0) #\Tab)
		     (char-not-equal (char line 0) #\Space)
		     (position #\: line :test #'char=)))
	 (special-header-p (and colon
				(member line *en-important-headers*
					:test #'(lambda (x y) (string-equal x y :end1 colon))))))
    ;1;*
    ;1; Date field hacking.  I like to see times in my local time, not GMT!  (so show both).*
    (when (and colon *en-reformat-dates* (string-equal line "3Date:*" :end1 (1+ colon) :end2 5))
      (let* ((ut (ignore-errors (time:parse-universal-time line (1+ colon) nil nil))))
	(when ut (setq line (format nil "3~A ~A ~A  (~A)*"
				    (subseq line 0 (1+ colon)) (time:print-universal-time ut nil) (time:timezone-string)
				    (string-left-trim #\Space (subseq line (1+ colon))))))))
    ;1;*
    ;1; Font hacking.*
    (when fonts-p (write-char (if colon #\1 #\2) stream))
    (cond (colon
	   (incf colon)
	   (write-string line stream :end colon)
	   (when fonts-p
	     (write-char #\Epsilon stream)
	     (write-char (if special-header-p #\3 #\2) stream))
	   (write-string line stream :start colon)
	   (when fonts-p
	     (write-string #.(string-append #\Epsilon #\*) stream)))
	  (t
	   (write-string line stream)))
    (when fonts-p
      (write-string #.(string-append #\Epsilon #\*) stream)))
  nil)


;1;; Changed this to call new function 5write-news-header-field.**
;1;;*
(defun 4WRITE-FORMATTED-HEADER* (stream newsgroup-component newsheader-include-list newsheader-exclude-list
			       &optional fonts-p)
  "2Format the current article header and write it to stream.  Display only the
newsheader fields.  The article header must have already been saved onto
the article number.  Return the number of lines printed.*"
  (let (line (count 0))
    ;1;;Write the include list header fields minus the exclude list.*
    (dolist (item newsheader-include-list nil)
      (unless (member item newsheader-exclude-list)
	(when (setf line (get-header-field newsgroup-component item))
	  (incf count)
	  (write-news-header-field stream line fonts-p))))
    ;1;;Merge the include list and exclude list and write the remaining header fields.*
    (setf newsheader-exclude-list (append newsheader-exclude-list newsheader-include-list))
    (dolist (item (reverse (get newsgroup-component (send newsgroup-component :current-article-number))) count)
      (unless (member (car item) newsheader-exclude-list)
	(when (setf line (get-header-field newsgroup-component (car item)))
	  (incf count)
	  (write-news-header-field stream line fonts-p))))))


;1;; Changed this to write out font change codes for special lines, and to call 5write-formatted-header* when appropriate.*
;1;;*
(defun 4EN-DISPLAY-ARTICLE-INTO-BUFFER* (buffer newsgroup-component &optional (verbose nil) (rotl nil))
"2Display article into the news buffer and mark the article as read.  If verbose is
nil then format the header.  If verbose is t then display the header as received
from the news server.  Return T if successful.  Return NIL if the article was
not found.*"
  (delete-interval buffer)			;1delete the contents of the buffer.*
  (cond
    ((en-header-p newsgroup-component)
     (send newsgroup-component :mark-article t *mark-xref-articles-p*)
     (let ((stream (interval-stream-into-bp (interval-first-bp buffer) t))
	   (count 0))
       (format stream "34*Article ~d ~@[(~a more) ~]in ~a~@[ (~a)~]:3**"
	       (send newsgroup-component :current-article-number)
	       (when (> (send newsgroup-component :unread-article-count) 0)
		 (send newsgroup-component :unread-article-count))
	       (send newsgroup-component :newsgroup-string)
	       (when (send newsgroup-component :moderated-p) "moderated"))
       (incf count)
       (cond
	 (verbose
	  (en-article-command newsgroup-component))
	 (t
	  (setf count (+ count (write-formatted-header stream newsgroup-component *reformat-newsheaders-include-list*
						       *reformat-newsheaders-exclude-list*
						       t)))
	  (format stream "~2%")
	  (incf count)
	  (en-body-command newsgroup-component t)))
       (cond
	 ((dotimes (i (+ (- 5 count) (window-n-plines *window*)) t)
	    (multiple-value-bind (line eof) (nntp:read-nntp-stream *nntp-stream*)
	      (cond
		((not eof)
		 ;1;*
		 ;1; If we are in verbose mode, then we must do the header-font formatting here.  When we reach the end of the*
		 ;1; headers (a blank line) then we turn off the verbose flag to resume normal processing.  Glitch: if the header part*
		 ;1; of the message is longer than the first page, header fields after the first page won't be fontified.  Who cares.*
		 ;1;*
		 (let* ((line (if rotl (rotl-line line) line)))
		   (when (and verbose (string= line "")) (setq verbose nil))
		   (cond (verbose (write-news-header-field stream line t))
			 (t (send stream :line-out line)))))
		(:else
		 (format stream "3~2%4~A**" *end-of-article-line*)
		 (return nil)))))
	  (redisplay *window* :start (interval-first-bp buffer) nil)
	  (redisplay-article-mode-line)
	  (loop 
	    (multiple-value-bind (line eof) (nntp:read-nntp-stream *nntp-stream*)
	      (cond
		(eof (return))
		(t (send stream :line-out (if rotl (rotl-line line) line))))))
	  (format stream "3~2%4~A**" *end-of-article-line*))
	 (t
	  (redisplay *window* :start (interval-first-bp buffer) nil)
	  (redisplay-article-mode-line)))
       t))
    (t
     (redisplay *window* :start (interval-first-bp buffer) nil)
     nil)))


;1;; this has nothing to do with fonts:  Modify the background check for news to say which newsgroups have acquired new articles.*
;1;;*

(defun 4BACKGROUND-CHECK-FOR-NEWNEWS* ()
  "2Background check for new news daemon.*"
  (loop2 with* last-wakeup-time2 do*
	(when (news-initialized-p)
	  (condition-case (cond-obj)
	      (let ((newsgroups (check-for-newnews)))
		(when newsgroups
		  (cond
		    ((equal *notify-newsgroup-list* t)
		     ;1; Trim it down if there are lots, so the notifications aren't very very long.*
		     (when (> (length newsgroups) 10) (setq newsgroups (subseq newsgroups 0 10)))
		     (tv:notify nil "3New news in ~A~{, ~A~}.*" (car newsgroups) (cdr newsgroups)))
		    ((dolist (item newsgroups nil)
		       (when (dolist (subitem *notify-newsgroup-list* nil)
			       (when (string-equal item subitem)
				 (return t)))
			 (return t)))
		     (let* ((subset (intersection newsgroups *notify-newsgroup-list* :test #'string-equal)))
		       (tv:notify nil "3New news in ~A~{, ~A~}.*" (car subset) (cdr subset)))))))
	    (error nil)))
	(setf last-wakeup-time (get-universal-time))
	(process-wait "2News Sleep*" #'(lambda (wakeup-time) (>= (get-universal-time) wakeup-time))
		      (max (+ (get-universal-time) (* 5 60))	;1Never loop faster than 5 minutes*
			   (+ last-wakeup-time (* 60 *background-check-for-newnews-interval*))))))


;1;; this has nothing to do with fonts:  It used to be that if **postnews-warning-message-p*1 was NIL, rather than *
;1;; being able to post without a prior confirmation, you were unable to post at all!!  *
;1;;*

(defcom 4COM-ARTICLE-META-P* "" ()
  (in-article-mode-context
    (when (or (null *postnews-warning-message-p*) (w:mouse-confirm (format nil "~a" *postnews-warning-message*)))
      (setf *mail-newsgroup-component* newsgroup-component)
      (en-postnews *default-post-news-mail-template*))))


;1;; this has nothing to do with fonts:  It used to be that when yanking a message, the header inserted was *
;1;; "in article <blah> you write:" instead of "in article <blah> user@host writes:"  Totally inappropriate for a post.*
;1;;*

(defcom 4COM-YANK-NEWS-MESSAGE*
	""
	()
  (let ((stream (interval-stream-into-bp (interval-last-bp *interval*))))
    (en-group-command *mail-newsgroup-component*)
    (en-body-command *mail-newsgroup-component*)
    (format stream "In article ~A 3~A* write3s*:" (get-header-field *mail-newsgroup-component* :message-id t)
	    (or (get-header-field *mail-newsgroup-component* :from t)
		(get-header-field *mail-newsgroup-component* :sender t)))
    (loop
      (multiple-value-bind (line eof) (nntp:read-nntp-stream *nntp-stream*)
	(cond
	  (eof (return :eof))
	  (t (format stream "~%~a~a" zwei:*yank-message-prefix* line)))))
    (format stream "~2%")
    (move-to-bp (send stream :read-bp)))
  dis-text)




(defun 4WRITE-TO-BUFFER-P* (buffername)
  "2Return T if it is ok to write to buffername.*"
  (cond
    ((zwei:find-buffer-named buffername)
     (if (y-or-n-p "3Buffer already exists; append? *")
	 (progn (zwei:insert-moving (zwei:interval-last-bp (zwei:find-buffer-named buffername))
				    #.(string-append #\Newline #\Page #\Newline #\Newline))
		t)
	 nil))
;    ((zwei:find-buffer-named buffername)
;     (if (fquery '(:choices ((nil #\o) (t #\a))) "3Buffer already exists.  Overwrite or append? *")
;	 (zwei:insert-moving (zwei:interval-last-bp (zwei:find-buffer-named buffername))
;			     #.(string-append #\Newline #\Page #\Newline #\Newline))
;	 (zwei:kill-buffer (zwei:find-buffer-named buffername)))
;     t)
    (t t)))


(defcom 4COM-ARTICLE-SHIFT-S*
	""
	()
  (in-article-mode-context
    (cond
      ((send newsgroup-component :start-or-end-of-newsgroup-p))
      (t
       (let ((buffername (prompt-and-read :string-or-nil "3Save into Buffer:  *")))
	 (when (and buffername (write-to-buffer-p buffername))
	   (zwei:with-editor-stream (stream :buffer-name buffername :create-p t :start :end)
	     (format *query-io* "3Saving article into ~a...*" buffername)
	     (en-display-article stream newsgroup-component)
	     (format *query-io* "3Done*"))))))))


;1;; Completion when going to a specific newsgroup.*
;1;;*
(let* ((sys:compile-encapsulations-flag t))
  (sys:advise-within COM-NEWSGROUP-G prompt-and-read :around completion nil
    (car (zwei:completing-read-from-mini-buffer "3Newsgroup: *"
						(mapcar #'(lambda (x)
							    (cons (send x :newsgroup-string)
								  (send x :newsgroup-string)))
							*newsrc-list*)))))
