;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:MAIL; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; This is a version of Biff that works with the KSL desktop code.  It uses a little window instead of a wholine blinker.*
;1;; Call the function 3BIFF* the same way you would call 3ANALOG-CLOCK*.*
;1;; If 3FONTS:BIFF* is loaded, the icon is a mailbox whose flag goes up when you have mail.  If this font is not loaded, then*
;1;; the icon is blank when you don't have mail, and an asterisk in 3FONTS:CMR18* when you do.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;     8 Sep 89*	1Jamie Zawinski*	1 Created.  Much code borrowed from my old 5mail:biff*, and from Acuff's 5w:analog-clock*.*
;1;;*   111 Sep 89*	1Jamie Zawinski *	 1Made the biff-window auto-expose itself before every update, so that what you see is not out of date.*
;1;;*   114 Sep 89*	1Jamie Zawinski *	 1Made BIFF not expose itself if the ScreenSaver is on.*
;1;;*


(export '(biff nobiff from pop-up-from))

(defvar 4*biff-interval* *30 "2Biff will probe for mail every this-many seconds.*")

(defvar 4*biff-font**	4 *   nil	"2The font for the BIFF icons.*")
(defvar 4*biff-no-mail-char* *nil	"2The character of *BIFF-FONT* to draw when there is no mail.*")
(defvar 4*biff-mail-char* *  4 *nil "2The character of *BIFF-FONT* to draw when there is mail.*")

(unless *biff-font*
  (if (boundp 'fonts:biff)
      (setq *biff-font* 'fonts:biff
	    *biff-no-mail-char* #\A
	    *biff-mail-char* #\B)
      (setq *biff-font* 'fonts:cmr18
	    4*biff-no-mail-char* *#\Space
	    4*biff-mail-char** #\*)))


(defvar 4*biff-wakeup* *nil "2If you set this flag to T, then biff will wake up right away instead of waiting for *biff-interval* to expire.*")


(defflavor 4biff-window*
	   ((char #\?))
	   (w:process-mixin w:window-accelerator-mixin w:window)
  (:default-init-plist :save-bits nil :blinker-p nil :label nil)
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)

(defmethod 4(biff-window :after :refresh)* (&optional (type :complete-redisplay))
  (when (eq type :complete-redisplay)
    (send self :clear-screen)
    (let* ((font (w:font-evaluate *biff-font*)))
      (unless (eq w:current-font font)
	(unless (position font (the vector w:font-map) :test #'eq) (send self :set-font-map (vector font)))
	(send self :set-current-font font)))
    (tv:sheet-display-x-y-centered-string self (string char))))

(defmethod (4biff*-window :screen-manage-deexposed-visibility) () t)

(defmethod 4(biff-window :deexposed-mouse-buttons*) (button-mask x y)
  "2Call standard :MOUSE-CLICK method.*"
  (send self :mouse-buttons button-mask x y))

(defmethod 4(biff-window :mouse-click*) (button x y)
  (case button
    ((#\Mouse-L-1 #\Mouse-L-2)
     (if (send self :exposed-p)
         (process-run-function '(:name "3Biff Menu*" :priority 0) #'biff-set-parameters self)
	 (send self :expose)))
    ((#\Mouse-M-1 #\Mouse-M-2)
     (if (and (boundp 'w:*dragging-enabled?*) w:*dragging-enabled?*
	      (char= #\Mouse-M-1 button))
	 (w:drag-window-from self x y)
	 (process-run-function '(:name "3Set Window Position*" :priority 1)
			       #'(lambda (window) (w:mouse-set-window-position window))
			       self)))
    ((#\Mouse-R-1) (w:mouse-call-system-menu))))

(defmethod 4(biff-window :deexposed-who-line-documentation-string*) ()
  `(:mouse-L-1 "3Expose this window*" :mouse-M-1 "3Move this window*" :mouse-R-1 "3System Menu*"))

(defmethod 4(biff-window :who-line-documentation-string*) ()
  `(:mouse-L-1 "3Menu of Biff operations*" :mouse-M-1 "3Move this window*" :mouse-R-1 "3System Menu*"))


(defun 4biff-set-parameters *(window)
  (w:menu-choose
    `(("3Redraw*" :eval (send ,window :refresh) :documentation "2Clear and redraw the window*")
      ("3Square*" :eval (w:square-window ,window) :documentation "2Make the window square*")
      ("3Set Interval*"
       :eval (w:choose-variable-values '("" (*biff-interval* "3Probe Mail Interval (in seconds)*" :fixnum 0) ""))
       :documentation "2Change the time delay between probes of your inbox.*")
      ("3No Biff*" :eval (nobiff) :documentation "2Remove this biff window.*")
      ("" :no-select t)
      ("3From*" :eval (pop-up-from) :documentation "2Pop up a window showing who your mail is from.*")
      ("3Read Mail*" :eval (zwei:read-mail) :documenation "2Select a Zmacs frame reading your mail.*")
      ("3View Mail*" :eval (zwei:kbd-view-mail nil)
       :documentation "2Pop up a window viewing the mail in your inbox.*"))))


(defun 4from *(&rest inboxes)
  "2Say who your mail is from.  INBOXES defaults to all of the inboxes on *MAIL:*INBOX-PROBE-LIST*2.*"
  (unless inboxes (setq inboxes (mapcar #'car mail:*inbox-probe-list*)))
  (let* ((any-mail nil))
    (dolist (file inboxes)
      (block ONE
	(let* ((printed nil))
	  (with-open-file (stream file :direction :input :if-does-not-exist nil)
	    (when stream
	      (loop
		(let* ((line (read-line stream nil nil)))
		  (unless line (return-from ONE))
		  (when (string-equal "3From:*" (the simple-string line) :end2 5)
		    (setq any-mail t)
		    (unless printed
		      (format t "3~2&In inbox ~A:~%*" (send stream :truename))
		      (setq printed t))
		    (princ "3  *")
		    (write-line line)))))))))
    any-mail))


(defun 4pop-up-from *(&optional ignore)
  "2Pop up a window running MAIL:FROM.*"
  (using-resource (window tv:pop-up-finger-window)
    (setf (tv:sheet-truncate-line-out-flag window) 1)
    (send window :set-process current-process)
    (let* ((inboxes (mapcar #'car mail:*inbox-probe-list*)))
      (send window :set-label
	    (cond ((null inboxes) "3No inboxes known.*")
		  ((null (cdr inboxes)) (format nil "3Listing mail in inbox ~A*" (car inboxes)))
		  (t (format nil "3Listing mail in inboxes ~A~{, ~A~}*" (car inboxes) (cdr inboxes)))))
      (tv:window-call (window :deactivate)
	(let* ((*terminal-io* window)
	       (*debug-io* window))
	  (and inboxes (or (from) (format window "3~2&No new mail.*"))))
	(format window "3~2%Any character to flush.*")
	(send window :any-tyi)))))


(defun 4biff-loop *(window)
  (send window :refresh)
  (loop
    (setq *biff-wakeup* nil)
    (catch 'TIMEOUT
      (let* ((mail-p (with-timeout ((* 60 60 5) (throw 'TIMEOUT nil))
		       (if (fboundp 'zwei:ckmail)	;1 Use Jamie's better version of *MAIL:PROBE-INBOXES1 if it's around.*
			   (zwei:ckmail)
			   (mail:probe-inboxes))))
	     (osw tv:selected-window))
	(send window :set-char (if mail-p *biff-mail-char* *biff-no-mail-char*))
	;1; If the window is on the screen, but not exposed, pop it to the top so it will update.  But not if the ScreenSaver is on.*
	(when (and (not (tv:sheet-exposed-p window))
		   (tv:sheet-exposed-p (tv:sheet-superior window))
		   (not (and (boundp 'tv:*the-screen-is-black*) tv:*the-screen-is-black*)))
	    (send window :expose))
	(tv:sheet-force-access (window) (send window :refresh))
	(unless (eq tv:selected-window osw) (and osw (send osw :select)))
	;1;*
	;1; Wait until the interval has expired, or someone has set the biff-wakeup flag.*
	(process-wait "3Biff Sleep*"
		      #'(lambda (start-time interval)
			  (or *biff-wakeup*
			      (>= (time-difference (time) start-time)
				  interval)))
		      (time) (round (* 60 *biff-interval*)))
	))))


;1;;*
;1;; Put advice on 3ZWEI:READ-INBOX* so that when the user reads their mail, the little flag will go down right away.*
;1;;*
(sys:advise zwei:read-inbox :after wake-biff nil
  (setq *biff-wakeup* t))


(defun 4biff *(&optional edges)
  "2Create a window with a cute glyph telling you when you have mail.*"
  (unless edges
    (let* ((size (+ 10 (max (w:font-char-height (w:font-evaluate *biff-font*))
			    (w:sheet-string-length w:default-screen (string *biff-mail-char*) 0 nil nil *biff-font*)
			    (w:sheet-string-length w:default-screen (string *biff-no-mail-char*) 0 nil nil *biff-font*)))))
      (setq edges (list (- (tv:sheet-inside-width tv:default-screen) size)
			0
			(tv:sheet-inside-width tv:default-screen)
			size))))
  (nobiff)
  (let* ((window (w:get-window 'biff-window edges)))
    (send window :set-process
	  (process-run-function '(:name "3Biff Background*" :restart-after-boot t :restart-after-reset t)
				#'biff-loop window))
    (send window :expose)
    window))


(defun 4nobiff *()
  "2Turns off BIFF.*"
  (dolist (proc sys:all-processes)
    (when (string= "3Biff Background*" (send proc :name))
      (send proc :kill)))
  (dolist (win (tv:sheet-inferiors tv:default-screen))
    (when (typep win 'biff-window) (send win :kill)))
  nil)


(compile-flavor-methods biff-window)
