;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TV; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "3INTERFERENCE*"*
;1;; Playing around with circular interference patterns.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    25 Aug 89*	1Jamie Zawinski*	1 Created.*
;1;;*


(defvar 4*interference-1* *(make-array '(512 512) :element-type 'bit))
(defvar 4*interference-2* *(make-array '(512 512) :element-type 'bit))
(defvar 4*interference-B* *(make-array '(512 512) :element-type 'bit))

(defun 4draw-concentric-circles *(array inc)
  "2Fill the bitmap ARRAY with concentric circles, their midpoints being at the center of the array, and their radii increasing in increments of INC.*"
  (let* ((size (min (array-dimension array 0) (array-dimension array 1)))
	 (center-x (round (array-dimension array 1) 2))
	 (center-y (round (array-dimension array 0) 2)))
    (declare (optimize speed)
	     (fixnum center-x center-y size))
    (fill array 0)
    (do* ((radius (- (floor size 2) 1) (- radius inc)))
	 ((<= radius 2))
      (declare (fixnum radius))
      (do* ((y 0)
	    (f 0)
	    (x radius))
	   (())
	(declare (fixnum x y f))
	(macrolet ((draw (x y)
			 `(setf (aref array ,x ,y) 1)))
	  (draw (+ center-x x) (- center-y y))
	  (draw (- center-x x) (+ center-y y))
	  (draw (+ center-x y) (+ center-y x))
	  (draw (- center-x y) (- center-y x))
	  (setq f (+ f y y 1) y (1+ y))
	  (when (>= f x) (setq f (- f x x -1) x (- x 1)))
	  (when (> y x) (return))
	  (draw (+ center-x x) (+ center-y y))
	  (draw (- center-x x) (- center-y y))
	  (draw (+ center-x y) (- center-y x))
	  (draw (- center-x y) (+ center-y x))
	  (when (= y x) (return)))))))


(defun 4interfere *(&optional (x 0) (y 0) (inc-1 2) (inc-2 2) (offset-x 0) (offset-y 1))
  "2  Inspect interference patterns.  3INC-[1,2]* are the radius-increments of the two sets of concentric circles.
  3OFFSET-X* and 3OFFSET-Y* are the difference between the midpoints of the sets of circles.
  3X* and 3Y* are the center position of the first set of circles.

  The cursor keys move the center of the second set of circles in relation to the first set.  Holding down Control or Meta moves faster.
  3<* and 3>* (or 3,* and 3.*) increment or decrement the radius increment of the first set of circles.  Holding down Control or Meta does it faster.
  3-* and 3+* (or 3_* and 3=*) increment or decrement the radius increment of the second set of circles.  Holding down Control or Meta does it faster.
  *"
  ;1;*
  ;1; Fill two arrays with concentric circles.*
  ;1;*
  (draw-concentric-circles *interference-1* inc-1)
  (draw-concentric-circles *interference-2* inc-2)
  (loop
    ;1;*
    ;1; Xor the two arrays into a third array, and then blit that onto the screen (the third array is for double buffering to prevent flicker).*
    ;1;*
    (let* ((width  (array-dimension *interference-B* 1))
	   (height (array-dimension *interference-B* 0))
	   (blitw  (min width  (- width (abs offset-x))))
	   (blith  (min height (- height (abs offset-y))))
	   (blitdx (max 0 offset-x))
	   (blitdy (max 0 offset-y))
	   (blitsx (if (plusp offset-x) 0 (- offset-x)))
	   (blitsy (if (plusp offset-y) 0 (- offset-y))))
    (bitblt tv:alu-seta width height *interference-1* 0 0 *interference-B* 0 0)
    (bitblt tv:alu-xor blitw blith *interference-2* blitsx blitsy *interference-B* blitdx blitdy)
    (send tv:selected-window :bitblt tv:alu-seta width height *interference-B* 0 0 x y))
    ;1;*
    ;1; Read a character, and change the various offsets based on it.*
    ;1;*
    (let* ((char (read-char))
	   (control-p (plusp (char-bits char)))
	   (inc (if control-p 5 1)))
      (setq char (make-char char))
      (case char
	(#\Left-Arrow  (decf offset-x inc))
	(#\Right-Arrow (incf offset-x inc))
	(#\Up-Arrow    (decf offset-y inc))
	(#\Down-Arrow  (incf offset-y inc))
	((#\, #\<)     (if (> inc-1 1) (draw-concentric-circles *interference-1* (decf inc-1 inc)) (beep)))
	((#\- #\_)     (if (> inc-2 1) (draw-concentric-circles *interference-2* (decf inc-2 inc)) (beep)))
	((#\= #\+)     (draw-concentric-circles *interference-2* (incf inc-1 inc)))
	((#\. #\>)     (draw-concentric-circles *interference-1* (incf inc-2 inc)))
	(t (beep))))))
