;;; -*- Mode:Common-Lisp; Package:DOMAIN-NAME-SYSTEM; Base:10 -*-
;;; 03-Mar-89 17:02:31, Bjrn Victor
;;; Copyright (c) 1989, Bjrn Victor, Department of Computer Systems, Uppsala University

;;; TTLs

(defvar *frozen-ttl-base* nil "The base for converting between absolute and relative TTLs.
NIL or, if TTL is frozen, the UT when it froze.
See macro WITH-FROZEN-TTL.")

(defmacro with-frozen-ttl (&body body)
  `(let ((*frozen-ttl-base* (or *frozen-ttl-base* (get-universal-time))))
     ,@body))

(defun make-absolute-ttl (relative)
  "Given a relative TTL, returns an absolute."
  (+ (or *frozen-ttl-base* (get-universal-time)) relative))

(defun make-relative-ttl (absolute)
  "Given an absolute TTL, returns a relative."
  (- absolute (or *frozen-ttl-base* (get-universal-time))))

(defun ttl-valid (absolute-ttl)
  "Is this absolute TTL still alive?"
  (>= (make-relative-ttl absolute-ttl) 0))
