;;; -*- Mode:Common-Lisp; Package:DOMAIN-NAME-SYSTEM; Base:10; Fonts:(CPTFONT 1HL10B* HL10 CPTFONT 1CPTFONTB*) -*-
;1;; 20-Mar-88 12:32:26, Bjrn Victor*
;1;; Copyright (c) 1988, Bjrn Victor, Department of Computer Systems, Uppsala University*

;1; OPCODEs*
(defconstant 4*opcode-query** 0 "2a standard query (QUERY)*")
(defconstant 4*opcode-iquery** 1 "2an inverse query (IQUERY)*")
(defconstant 4*opcode-status** 2 "2a server status request (STATUS)*")

;1; Response codes*
(defconstant 4*response-no-error** 0 "2No error condition*")
(defconstant 4*response-format-error** 1 "2Format error.
The name server was unable to interpret the query.*")
(defconstant 4*response-server-failure** 2 "2Server failure.
The name server was unable to process this query due to a problem with the name server.*")
(defconstant 4*response-name-error** 3 "2Name Error.
Meaningful only for responses from an authoritative name server,
this code signifies that the domain name referenced in the query does not exist.*")
(defconstant 4*response-not-implemented** 4 "2Not Implemented - The name server does not support the requested kind of query.*")
(defconstant 4*response-refused** 5 "2Refused.
The name server refuses to perform the specified operation for
policy reasons.  For example, a name server may not wish to provide the
information to the particular requester,or a name server may not wish to perform
a particular operation (e.g., zone transfer) for particular data.*")


;1; TYPEs*
(defconstant 4*type-address** 1 "2a host address*")
(defconstant 4*type-name-server** 2 "2an authoritative name server*")
(defconstant 4*type-mail-destination** 3 "2a mail destination (Obsolete - use MX)*")
(defconstant 4*type-mail-forwarder** 4 "2a mail forwarder (Obsolete - use MX)*")
(defconstant 4*type-canonical-name** 5 "2the canonical name for an alias*")
(defconstant 4*type-start-of-authority** 6 "2marks the start of a zone of authority*")
(defconstant 4*type-mailbox** 7 "2a mailbox domain name (EXPERIMENTAL)*")
(defconstant 4*type-mail-group** 8 "2a mail group member (EXPERIMENTAL)*")
(defconstant 4*type-mail-rename** 9 "2a mail rename domain name (EXPERIMENTAL)*")
(defconstant 4*type-null** 10 "2a null RR (EXPERIMENTAL)*")
(defconstant 4*type-well-known-service** 11 "2a well known service description*")
(defconstant 4*type-pointer** 12 "2a domain name pointer*")
(defconstant 4*type-host-info** 13 "2host information*")
(defconstant 4*type-mail-info** 14 "2mailbox or mail list information*")
(defconstant 4*type-mail-exchange** 15 "2mail exchange*")
(defconstant 4*type-text** 16 "2text strings*")

(defconstant 4*max-type-value** *type-text* "2The highest TYPE value (not QTYPE)*")

;1; QTYPEs*
(defconstant 4*type-zone-transfer** 252 "2A request for a transfer of an entire zone*")
(defconstant 4*type-mailbox-request** 253 "2A request for mailbox-related records (MB, MG or MR)*")
(defconstant 4*type-mail-agent-request** 254 "2A request for mail agent RRs (Obsolete - see MX)*")
(defconstant 4*type-wild-request** 255 "2A request for all records*")

;1; CLASSes*
(defconstant 4*class-internet** 1 "2the Internet*")
(defconstant 4*class-csnet** 2 "2the CSNET class (Obsolete - used only for examples in some obsolete RFCs)*")
(defconstant 4*class-chaos** 3 "2the CHAOS class*")
(defconstant 4*class-hesiod** 4 "2Hesiod [Dyer 87]*")
;1; Query classes*
(defconstant 4*class-wild** 255 "2any class*")


;;; Errors/Signals
#+Explorer
(progn
(ticl:defflavor dns-error () ())
(ticl:defflavor dns-hard-error () (dns-error eh:error))
(ticl:defflavor dns-soft-error () (dns-error eh:error))
(ticl:defflavor dns-no-such-domain () (dns-hard-error))
(ticl:defflavor dns-try-again-error () (dns-soft-error))
(ticl:defflavor dns-non-recoverable-error () (dns-hard-error))

(ticl:defsignal dns-no-data-available dns-hard-error (query)
  "3No data was available for this domain,type,class tuple*")

(ticl:defsignal dns-format-error dns-non-recoverable-error (query)
  "3The name server was unable to interpret the query*")
(ticl:defsignal dns-nyi-error dns-non-recoverable-error (query)
  "3The name server does not support the requested kind of query.*")
(ticl:defsignal dns-refused-error dns-non-recoverable-error (query)
  "3The name server refuses to perform the specified operation for
policy reasons.  For example, a name server may not wish to provide the
information to the particular requester,or a name server may not wish to perform
a particular operation (e.g., zone transfer) for particular data.*")
(ticl:defsignal dns-name-error dns-no-such-domain (query)
  "3This code signifies that the domain name referenced in the query does not exist.*")
(ticl:defsignal dns-server-failure dns-try-again-error (query)
  "3The name server was unable to process this query due to a problem with the name server.*")
(ticl:defsignal dns-no-response dns-try-again-error (query)
  "3No response was received for this query - try again LATER (not immediately)*")
)

(defun opcode-string (opcode)
  (cond ((= opcode *opcode-query*)
	 "QUERY")
	((= opcode *opcode-iquery*)
	 "IQUERY")
	((= opcode *opcode-status*)
	 "STATUS")
	(t
	 (format nil "Undefined: ~d." opcode))))
(defun response-code-string (code)
  (cond ((= code *response-no-error*)
	 "No error")
	((= code *response-format-error*)
	 "Format error")
	((= code *response-server-failure*)
	 "Server failure")
	((= code *response-name-error*)
	 "Name error")
	((= code *response-not-implemented*)
	 "Not implemented")
	((= code *response-refused*)
	 "Refused")
	(t (format nil "Undefined: ~d." code))))
(defun type-string (type)
  (cond ((= type *type-address*)
	 "Address")
	((= type *type-name-server*)
	 "Name server")
	((= type *type-mail-destination*)
	 "Mail destination (obs)")
	((= type *type-mail-forwarder*)
	 "Mail forwarder (obs)")
	((= type *type-canonical-name*)
	 "Canonical name")
	((= type *type-start-of-authority*)
	 "Start of authority")
	((= type *type-mailbox*)
	 "Mailbox")
	((= type *type-mail-group*)
	 "Mail group")
	((= type *type-mail-rename*)
	 "Mail rename")
	((= type *type-null*)
	 "NULL")
	((= type *type-well-known-service*)
	 "Well Known Service")
	((= type *type-pointer*)
	 "Pointer")
	((= type *type-host-info*)
	 "Host info")
	((= type *type-mail-info*)
	 "Mail info")
	((= type *type-mail-exchange*)
	 "Mail exchange")
	((= type *type-text*)
	 "Text string")
	((= type *type-zone-transfer*)
	 "Zone transfer request")
	((= type *type-mailbox-request*)
	 "Mailbox request")
	((= type *type-mail-agent-request*)
	 "Mail agent request (obs)")
	((= type *type-wild-request*)
	 "All records request")
	(t (format nil "Undefined: ~d." type))))
(defun type-keyword (type)
  "This is a kludge!  Shd be an alist getter."
  (cond ((= type *type-address*)
	 :a)
	((= type *type-name-server*)
	 :ns)
	((= type *type-mail-destination*)
	 :md)
	((= type *type-mail-forwarder*)
	 :mf)
	((= type *type-canonical-name*)
	 :cname)
	((= type *type-start-of-authority*)
	 :soa)
	((= type *type-mailbox*)
	 :mb)
	((= type *type-mail-group*)
	 :mg)
	((= type *type-mail-rename*)
	 :mr)
	((= type *type-null*)
	 :null)
	((= type *type-well-known-service*)
	 :wks)
	((= type *type-pointer*)
	 :ptr)
	((= type *type-host-info*)
	 :hinfo)
	((= type *type-mail-info*)
	 :minfo)
	((= type *type-mail-exchange*)
	 :mx)
	((= type *type-text*)
	 :txt)
	((= type *type-zone-transfer*)
	 :axfr)
	((= type *type-mailbox-request*)
	 :mailb)
	((= type *type-mail-agent-request*)
	 :maila)
	((= type *type-wild-request*)
	 :wild)
	(t nil)))
(defun class-string (class)
  (cond ((= class *class-internet*)
	 "Internet")
	((= class *class-csnet*)
	 "CSNet")
	((= class *class-chaos*)
	 "CHAOSnet")
	((= class *class-hesiod*)
	 "Hesiod")
	((= class *class-wild*)
	 "any class")
	(t (format nil "Undefined: ~d." class))))