;;; -*- Mode:Common-Lisp; Package:TV; Base:10 -*-

(defun draw-color-bars (&optional (window selected-window) x y w h &optional notext)
  "Draws standard colorbars on the window within the specified rectangle."
  (unless x (setq x 0))
  (unless y (setq y 0))
  (unless w (setq w (sheet-inside-width window)))
  (unless h (setq h (sheet-inside-height window)))
  (let* ((bar-w (ceiling w 7))
	 (bar-h (round (* h 2/3)))
	 (margin (max 1 (round h 100)))
	 (rest (- h bar-h))
	 (lower-bar-h (round rest 4))
	 (colors (list WHITE YELLOW CYAN GREEN MAGENTA RED BLUE))
	 (grays (list WHITE 12%-GRAY-COLOR 25%-GRAY-COLOR 33%-GRAY-COLOR 50%-GRAY-COLOR 66%-GRAY-COLOR
		      75%-GRAY-COLOR 88%-GRAY-COLOR BLACK))
	 (gray-bar-w (ceiling w (length grays)))
	 (current-x x)
	 (current-y y))
    (tv:with-clipping-rectangle (x y (+ x w) (+ y h))
      (labels ((rect (rx ry rw rh color)
		 (when (> (* rx rw) (+ x w)) (setq rw (- (+ x w) rx)))
	         (if (typep window 'TV:GRAPHICS-MIXIN)
		     (send window :draw-rectangle rw rh rx ry alu-transp color)
		     (send window :draw-filled-rectangle rx ry rw rh color)))
	       (bars (w h colors forward &optional oddblack)
		  (let* ((i 0))
		    (dolist (color (if forward colors (reverse colors)))
		      (rect current-x current-y w h (if (and oddblack (oddp i)) W:BLACK color))
		      (incf current-x w)
		      (incf i)))
		  (incf current-y (+ h margin)) (setq current-x x)))
	(rect x y w h black)
	(bars bar-w bar-h colors t)
	(bars bar-w lower-bar-h colors nil t)
	(bars gray-bar-w lower-bar-h grays nil)
	(bars gray-bar-w lower-bar-h grays t)
	(unless notext
	  (let* ((font (cond ((> w 500) FONTS:CMR18)
			     ((> w 300) FONTS:CMR10)
			     (t FONTS:TR10B)))
		 (line-height (tv:font-char-height font))
		 (logo-font (if (boundp 'fonts:old-ti-logo) fonts:old-ti-logo fonts:ti-logo))
		 (logo-height (tv:font-char-height logo-font))
		 (total-text-h (+ logo-height (* 2 line-height)))
		 (offset (max 0 (round (- (- h rest) total-text-h) 2)))
		 (logo-offset (max 0 (round (- offset (round logo-height 2)) 2)))
		 )
	    (send window :string-out-centered-explicit "T"
		  x (+ y (- offset logo-offset)) (+ x w) (- (+ y h) (+ rest logo-height)) logo-font TV:ALU-TRANSP 0 nil)
	    (send window :string-out-centered-explicit "TECHNICAL DIFFICULTIES"
		  x (+ y offset logo-height) (+ x w) (+ y h) font TV:ALU-TRANSP 0 nil)
	    (send window :string-out-centered-explicit "PLEASE STAND BY"
		  x (+ y offset logo-height line-height) (+ x w) (+ y h) font TV:ALU-TRANSP 0 nil)
	    )))))
  nil)
