;;; -*- Mode:Common-Lisp; Fonts:(medfnt medfntb hl12bi hl12b CPTFONTB); Base:10 -*-
 
;1;;*
;1;; The software was developed at Texas Instruments and is provided*
;1;; "as-is".  Texas Instruments and the author disclaim all warranties*
;1;; on the software, including without limitation, all implied warranties*
;1;; of merchantabilitiy and fitness.*
;1;;*
;1;; This software does not contain any technical data or information*
;1;; that is proprietary in nature.  It may be copied, modified, and*
;1;; distributed on a non-profit basis and with the inclusion of this*
;1;; notice.*
;;;
;;; Copyright (C) 1987, Texas Instruments Incorporated.

;1;; Clint Hyde. Aug 87.*

;1;;if you've ever tried to look at a large-ish bit-array to study*
;1;; the patterns of ones and zeros, it's almost impossible in the*
;1;; Inspector, so I made this nice easy routine. It used arrow keys*
;1;; and control-arrow keys. (arrows move half display their direction,*
;1;; control-arrow keys move whole display--watch the index numbers)*
 
;1;; John Hogge, 10/87.*
;1;;  Rehacked to include Zmacs like commands and user-supplied read and*
;1;;  print functions to allow editing as well as viewing.  The print*
;1;;  function still only allows one character output.*
 
;1;; CRH 1-88. Fixed Hogge's errors, and patched it so it didn't refresh*
;1;;  after every single edit. Also used #'READ-CHAR instead of #'READ. All*
;1;;  these things were to minimize keystrokes. Used WRITE-CHAR instead of*
;1;;  PRIN1, which is disgustingly slow for this. Also took care of the*
;1;;  overwriting problem, which is present in this style of cursor-indexed*
;1;;  display, because the print functions don't clear the region they're*
;1;;  about to draw over. *

;1;; CRH 3-88. added work by LaMott Oren which allows simply typing a*
;1;;  new value over an old one, and does a better overwrite/clear job.*

;1;; CRH 5-88.*
;1;; Included ability to draw text into the bit-array, for labeling things.*

;1;; CRH 11-89.*
;1;; Created a special-purpose font, called FATBITS (how original), based on*
;1;;  CPTFONT, but having the first two chars changed for use in this window.*
;1;;  It now shows a 1:1 aspect-ratio of the editing area, so that drawing*
;1;;  circles is finally easy. A corresponding change to the window definition*
;1;;  was required to account for the new font. In particular, the window's*
;1;;  CHAR-WIDTH and CHAR-HEIGHT values had to match the size of the two special*
;1;;  characters (11x11). The blinker was specified as a BOX-BLINKER, because*
;1;;  the default (rectangular-blinker) behaves as though it looks like both*
;1;;  of the special characters. BOX-BLINKER is much more reasonable.*

(sys:load-if "2fonts;fatbits*")		   ;1only load it once.*

;(setf (GET 'edit-bit-array 'window) ())

(DEFUN 4edit-bit-array* (&quote array-name &eval &key (i 0) (j 0) (rows 40) (cols 50)
		       (print-offset-x 0)
		       (print-offset-y 2)
		       (header (FORMAT nil "3Zoom/Edit-Bit-Array ~S~2%*" array-name))
		       &aux x inp aray (*terminal-io* (PROGN
							(UNLESS (GET 'edit-bit-array 'window)
							  (PUTPROP 'edit-bit-array
								   (MAKE-INSTANCE
								     'w:window
								     :label "3   Edit a BIT array.*"
								     :font-map '(fonts:fatbits)
								     :save-bits t
								     :blinker-flavor 'w:box-blinker)
								   'window)
							  (SETF (w:sheet-char-width
								  (GET 'edit-bit-array 'window))
								11
								(w:sheet-line-height
								  (GET 'edit-bit-array 'window))
								11)
							  )
							(GET 'edit-bit-array 'window)
							))
		       (font 'fonts:cptfont)	   ;1for drawing text.*
		       (font-list (SORT (PACKAGE-EXTERNAL-SYMBOLS 'fonts) #'STRING-LESSP))
		       (text1 "")
		       dummy
		       (cursor-x 0) (cursor-y 0))
  
  "2Zoom-Display a bit-array as character-ones and -zeros on screen. Beats Inspecting.
I,J specifies the offset to start at.  I=which row (3first index)*, J= which column (3second index)*.
ROWS, COLS specify the dimensions in characters of the array portion to
  display.
PRINT-OFFSET-X, PRINT-OFFSET-Y specify where to place the output after HEADER is
  printed.
HEADER specifies a string to print above the printed array.  If you supply a string,
  specify appropriate PRINT-OFFSET-X and PRINT-OFFSET-Y values, otherwise the array
  will be printed on top of the header.

Arrows and Control-F,B,N,P move single spaces (3like Zmacs)*.
CONTROL-Arrows move half a `screen', META-Arrows move a whole screen.
SUPER-Arrows move to the edge of the region shown.
RETURN moves to the beginning of the next line. LINEFEED = DOWN-ARROW.
CENTER moves the cursor to the upper-left-corner. Meta-CENTER moves the cursor to the origin 0,0.
Control-U multiplies next keystroke by 4.
Clear-Screen does a refresh; END and ABORT quit.

Typing a 0 or 1 will change the value under the cursor.*"

  (DECLARE (SPECIAL text1 font))
  
  (SEND *terminal-io* :expose)
  (SEND *terminal-io* :select)
  
  (SETQ aray (EVAL array-name))

  (SETQ rows (MIN rows (ARRAY-DIMENSION aray 0))	   ;1safety tests, so we don't overshoot.*
	cols (MIN cols (ARRAY-DIMENSION aray 1)))

  ;1;We add to caller's offsets enough room for row and col indices.*
  (SETQ PRINT-OFFSET-X (+ PRINT-OFFSET-X 6)) 
  (SETQ PRINT-OFFSET-Y (+ PRINT-OFFSET-Y 2)) 
  (UNWIND-PROTECT
      (LOOP
	(FORMAT t "3~:|~A*" header)
	(DOTIMES (y (LENGTH (SETQ x (FORMAT nil "3~D*" j))))
	  (FORMAT t "3      ~A~%*" (AREF x y)))
	(SETQ i (ROUND i)
	      j (ROUND j))
	(DOTIMES (r rows)
	  (DECLARE (optimize speed (safety 0)))
	  (WHEN (>= (- r i) rows)	   ;1safety test, so we don't overshoot.*
	    (RETURN))
	  (FORMAT t"3~%~5D *" (+ r i))
	  (DOTIMES (c cols)
	    (DECLARE (optimize speed (safety 0)))
	    (WHEN (>= (- c j) cols)	   ;1safety test, so we don't overshoot.*
	      (RETURN))
	    (WRITE-CHAR (IF (ZEROP (AREF aray (+ r i) (+ c j)))
			    (INT-CHAR 0)   ;#\0
			    (INT-CHAR 1)   ;#\1
			    )
			*terminal-io*) 
	    ))
	;1;After each screen update, start cursor at 0,0*
	(LET ((argument 1)
	      ;1;Add room for lines taken up by printed Y offset index.*
	      (print-offset-y (+ print-offset-y (LENGTH (FORMAT nil "3~D*" j)) -1)))
	  (LABELS ((keep-in-bounds ()
				   (WHEN (>= cursor-x cols)
				     (SETQ cursor-x (1- cols)))
				   (WHEN (< cursor-x 0)
				     (SETQ cursor-x 0))
				   (WHEN (>= cursor-y rows)
				     (SETQ cursor-y (1- rows)))
				   (WHEN (< cursor-y 0)
				     (SETQ cursor-y 0)))
		   ;1;Machine dependent:*
		   (set-cursorpos (x y)
				  (SEND *terminal-io* :set-cursorpos x y :character))
		   )
	    (LOOP
	      ;1;draw the same section of the array at normal size, off the the right*
	      (BITBLT tv:alu-seta
		      cols rows
		      aray j i  
		      (SEND *terminal-io* :screen-array) 800 100)

	      ;1;position the cursor*
	      (set-cursorpos (+ cursor-x print-offset-x) (+ cursor-y print-offset-y))

	      ;1;get an input command*
	      (CASE (SETQ inp (READ-CHAR *terminal-io*))
		(#\end 			(RETURN-FROM edit-bit-array))
		(#\c-down-arrow 	(SETQ i (MAX 0 (MIN (+ i (/ rows 2))
							    (- (ARRAY-DIMENSION aray 0) rows))))
					(RETURN))
		(#\c-up-arrow 		(SETQ i (MAX 0 (- i (/ rows 2))))
					(RETURN))
		(#\c-right-arrow 	(SETQ j (MAX 0 (MIN (+ j (/ cols 2))
							    (- (ARRAY-DIMENSION aray 0) cols))))
					(RETURN))
		(#\c-left-arrow 	(SETQ j (MAX 0 (- j (/ cols 2))))
					(RETURN))
		(#\m-center		(SETQ i 0 j 0
					      cursor-x 0
					      cursor-y 0)
					(RETURN))
		(#\center		(SETQ cursor-x 0 cursor-y 0))
		
		(#\m-up-arrow	 	(SETQ i (MAX 0 (- i rows)))
					(RETURN))
		(#\m-down-arrow 	(SETQ i (MAX 0 (MIN (+ i rows) (- (ARRAY-DIMENSION aray 0) rows))))
					(RETURN))
		(#\m-right-arrow 	(SETQ j (MAX 0 (MIN (+ j cols) (- (ARRAY-DIMENSION aray 1) cols))))
					(RETURN))
		(#\m-left-arrow 	(SETQ j (MAX 0 (- j cols)))
					(RETURN))

		(#\return		(SETQ cursor-x 0)
					(INCF cursor-y)
					(keep-in-bounds))
		(#\s-right-arrow	(SETQ cursor-x cols)
					(keep-in-bounds))
		(#\s-left-arrow		(SETQ cursor-x 0)
					(keep-in-bounds))
		(#\s-down-arrow		(SETQ cursor-y rows)
					(keep-in-bounds))
		(#\s-up-arrow		(SETQ cursor-y 0)
					(keep-in-bounds))
		
		((#\right-arrow #\c-f) (INCF cursor-x argument)
				       (SETQ argument 1)
				       (keep-in-bounds))
		((#\left-arrow #\c-b) (DECF cursor-x argument)
				      (SETQ argument 1)
				      (keep-in-bounds))
		((#\down-arrow #\linefeed #\c-n) (INCF cursor-y argument)
						 (SETQ argument 1)
						 (keep-in-bounds))
		((#\up-arrow #\c-p) (DECF cursor-y argument)
				    (SETQ argument 1)
				    (keep-in-bounds))
		
		(#\c-u	        (SETQ argument (* 4 argument)))
		
		((#\0 #\1)		(DOTIMES (k argument)
					  (SETF (AREF aray (+ cursor-y i) (+ cursor-x j))
						(IF (= inp #\0)
						    0 1))
					  (SEND *terminal-io* :clear-char)
					  (WRITE-CHAR (IF (ZEROP (AREF aray (+ cursor-y i) (+ cursor-x j)))
							  (INT-CHAR 0)	       ;#\0
							  (INT-CHAR 1) ;#\1
							  ))
					  (INCF cursor-x)
					  (keep-in-bounds))
					(SETQ argument 1))
		
		(#\clear-screen	(RETURN))
		(#\help (FORMAT t "3~:|~2%~A*"  "2Arrows and Control-F,B,N,P move single spaces (3like Zmacs)*.

CONTROL-Arrows move half a `screen', META-Arrows move a whole screen.

SUPER-Arrows move to the edge of the region shown.

RETURN moves to the beginning of the next line. LINEFEED = DOWN-ARROW.

CENTER3-`arrow'* moves 3the cursor to the upper-left corner. META-CENTER moves it *to3 the origin:* 0,0.

Control-U multiplies next keystroke by 43, but doesn't perform off-screen actions.*

Clear-Screen does a refresh; END and ABORT quit.

Typing a 0 or 1 will change the value under the cursor.

3Shift-T allows text entry into the array at the current cursor-position.  You choose a font.

*****************************************************************

Hit any character to exit.**")
			(READ-CHAR t)
			(RETURN))
		(#\T	(w:choose-variable-values `("" (text1 "Text" :string)
						    (font "3Which font*" :menu ',font-list)
						    "")
						  :near-mode '(:point 500 300))
			(SETQ font (EVAL font))
			(SETQ dummy 0)
			(DOTIMES (aa (LENGTH text1))
			  (sys:%draw-char font (CHAR text1 aa)
					  (+ dummy
					     j cursor-x)
					  (+ i cursor-y) tv:alu-xor aray)
			  (SETQ dummy
				(+ dummy (IF (tv:font-char-width-table font)
					     (AREF (tv:font-char-width-table font)
						   (CHAR-INT (CHAR text1 aa)))
					     (tv:font-char-width font)))))
			(RETURN))
		(t		(BEEP)
				(SETQ argument 1))
		)
	))))
    (SEND *terminal-io* :bury)))
;1(edit-*bit1-array (SEND TV:INITIAL-LISP-LISTENER :SCREEN-array)* :Header (FORMAT nil "2some array3~2%**"))

;1;#\center-arrow is same as #\center*
system:
(SETF (AREF si:kbd-ti-table 0 si:scan-code-home)
      #\center-arrow)
