;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:SYSTEM; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI) -*-

;1;; File "3APROPOS-PROPERTY*".*
;1;; Defines an apropos-function for finding symbols with a given property (or with properties whose names match a pattern).*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   19 Nov 89*	1Jamie Zawinski*	1Created.*
;1;;*

(import 'SYS:APROPOS-PROPERTY "2TICL*")
(export 'SYS:APROPOS-PROPERTY "2TICL*")

(defun 4sys:apropos-property* (string &rest args &key ((:package pkg)) exact inheritors inherited dont-print
			        &allow-other-keys)
  "2 Prints all symbols available in PACKAGE which have properties whose print names contain STRING.
 STRING may be a symbol or a list of symbols or string. If a list, each element of the list must be found.  
 If a list element is a list, one of the elements must be found.  This sequence continues recursively.
 If EXACT is T, then STRING must be a symbol; only symbols which have exactly this property will be matched.
 If PACKAGE is NIL or not supplied, the plists of all symbols in all packages are searched.
 If INHERITORS is non-NIL, the plists of symbols in packages which use PACKAGE are also searched.
 If INHERITED is NIL, the plists of symbols in packages used by PACKAGE are not searched.
 If DONT-PRINT is non-NIL, nothing is printed, and The list of symbols is returned.
 otherwise returns T if some symbols were found.

 This function may also be called as if its arglist was (STRING &OPTIONAL PACKAGE EXACT).*"

  (declare (arglist string &key package exact inheritors inherited dont-print))
  
  (cond ((= (length args) 1) (setq pkg (car args)))
	((and (= (length args) 2) (not (keywordp (car args))))
	 (setq pkg (car args)
	       exact (cadr args))))
  
  (let* ((func (if (atom string)
		   #'sys:apropos-1
		   #'sys:apropos-2)))
    (flet ((match (symbol)
	     (let* ((plist (symbol-plist symbol)))
	       (when plist
		 (do* ((rest plist (cddr rest)))
		      ((null rest))
		   (let* ((sys:return-list nil)
			  (sys:apropos-predicate nil)
			  (sys:apropos-substring string)
			  (sys:apropos-dont-print t))
		     (declare (special sys:return-list sys:apropos-predicate sys:apropos-substring sys:apropos-dont-print))
		     (funcall func (car rest))
		     (when sys:return-list (return t)))))))
	   (exact (symbol)
	     (do* ((rest (symbol-plist symbol) (cddr rest)))
		  ((null rest))
	       (when (if (symbolp string)
			 (eq string (car rest))
			 (string-equal string (car rest)))
		 (return T)))))
      (let* ((predicate (if exact #'exact #'match)))
	(apropos "" :package pkg :inheritors inheritors :inherited inherited :dont-print dont-print :predicate predicate)
	))))
