;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:FILE-SYSTEM; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI) -*-

;1;; File "3ANONYMOUS-PASSWD-HACK*".*
;1;; When being prompted for a password, allow <Return> to mean UID="anonymous", PASS=<real UID>.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    9 Feb 90*	1Jamie Zawinski*	1Created.*
;1;;*

(export '(*anonymous-uid* *anonymous-passwd*))

(defvar 4*anonymous-uid* *"3anonymous*"
  "2The user-id that Anonymous FTP uses; this should usually be ``anonymous.''.*")

(defvar 4*anonymous-passwd* *nil
  "2The password that Anonymous FTP uses; this should be who you really are.  If it is NIL, then it defaults to
  <logged-in-userID>@<local-host-name>*")


(defun 4input-user-information* (default-uid host &optional directory-flag skip-user-pass fields)
  2"Prompt the user for user-id & password on HOST plus any additional FIELDS needed.
  A field can be just a name (used as the prompt string) or
   can be a list (name <hide?> <type>).
  If DIRECTORY-FLAG then ask for a directory name rather than a user name.
  If SKIP-USER-PASS, then dont ask for user-id and password, but just for additional fields."*
  
  1;; NOTE ON ENABLE-CAPABILITES:*
  1;;  When a * is seen at the beginning of a password, the star is eaten (not*
  1;;  included as part of the password) and an additional value is returned *
  1;;  which indicates that this occurred.*
  
  (let (uid 
	pass
	other-values
	result
	done
	flush
        first-extra-field
	enable-capabilities-flag
	(enable-capabilities-char #\*)
	(main-prompt
	  (if directory-flag
            3"~&Type the password for directory ~A on host ~A,
or a directory and password.  \"DIRECTORY\" here includes devices as well: "*
           1;; ELSE*
           3"~&Current login name is ~A ~<~%~:;for host ~A.~>
~:[Type either password~;Hit <return> to use ~:*uid \"~A\" password \"~A\",
or type password,~] or ~<~%~:;loginname<space>password: ~>"*))
	(anon-uid *anonymous-uid*)
	(anon-pass (and *anonymous-uid*
			(or *anonymous-passwd*
			    (string-append (string-downcase user-id) #\@
					   (or (send (net:parse-host (or (send fs:user-login-machine :host-translation)
									 fs:user-login-machine si:local-host))
						     :name)
					       (send si:local-host :name)))))))
    
    1;; Loop because we need to restart completely if the user backspaces *
    1;; past the beginning of the current field*
    (loop
      with repeat = t
      while repeat do
      (block work
	
	(setq uid default-uid)
	(setq pass nil)
	(setq other-values nil)

        (unless skip-user-pass 
          1;; Get the user-id or password*
	  (multiple-value-setq (result done flush enable-capabilities-flag)
			       (keyboard-query
				 :prompt main-prompt
				 :prompt-format-args (list default-uid host anon-uid anon-pass)
				 :hide t :special-character enable-capabilities-char))
	  (when flush
	    (return-from work))			1;START OVER *
	  (if done
	      1;; THEN they entered password <return> only*
	      ;1; BUT if they typed an empty password, use the anon-FTP info.*		1## jwz*
	      (if (and (string= result "") anon-uid)
		  (setq uid anon-uid pass anon-pass)
		  (setq pass result))
	      1;; ELSE they entered user-id <space>, now get the password*
	      (setq uid result)
	      (multiple-value-setq (pass done flush enable-capabilities-flag)
				   (keyboard-query :hide t :allow-spaces t
						   :special-character enable-capabilities-char))
	      (when flush (return-from work))))	1;START OVER*

        1;; Get the remaining fields (if any)*
        (setq first-extra-field t)
	(dolist (field fields)
	  (let* ((field-prompt (if (consp field) (first field) field))
                (prompt field-prompt)
		prompt-format-args
		(hide (when (consp field) (second field)))
		(type (when (consp field) (third field)))
		value
		converted-value
		re-prompt)

            (when (and skip-user-pass first-extra-field)
               (setq first-extra-field nil)
               (setq prompt-format-args (list default-uid host prompt))
	       (setq prompt 
                  3"~&The login name [~A] & password are known for host ~A,
but additional information is being requested:~%~A"*))

	    (setq converted-value 
		  (do-forever
		    (multiple-value-setq (value done flush)
					 (keyboard-query :prompt (or re-prompt prompt)
							 :prompt-format-args prompt-format-args
							 :allow-spaces t :hide hide))
		    (when flush (return-from work))	1;START OVER*
		    (cond
		      ((eq type 'integer)
		       (if (> (length value) 0)
			   (condition-case (cond)
			       (progn
				(setq value (read-from-string value))
				(when (typep value type) (return value)))
			     (error ))
			   1;; ELSE*
			   (return nil)))
		      (:otherwise (return value)))
		    (setq re-prompt 3"~A - MUST BE ~A! "*)
		    (setq prompt-format-args (list field-prompt type))))
	    
	    (push  converted-value other-values)))
	(setq repeat nil)))			1;END BLOCK WORK*
      
      (values (apply 'list uid pass (nreverse other-values))
	      enable-capabilities-flag)))
