;;; -*- Mode:Common-Lisp; Package:zwei; Base:10; Fonts:(CPTFONT HL12B HL12I MEDFNB) -*-


(defun 4EN-MAIL* (template)
  (let ((fcn (get-mail-template-function template)))
    ;1; Put the window that called this template on the :return-to-window-after-send 
     *;1; property, so that we go back to that window after the mail is sent out or aborted.*
    (putprop *en* *interval* :return-to-buffer-after-send)
    (when fcn
      (let ((zmacs-window (find-or-create-idle-zmacs-window '(com-article-f com-article-r))))
	(w:await-window-exposure)
	(send zmacs-window :force-kbd-input `(:execute  ,fcn))
	(send zmacs-window :select)))))


;1;;Kludged this up so I could handle yanking a news message into a mail buffer my way (it's late friday afternoon and I believe in kludges).*
(defminor 4COM-EN-MAIL-MODE* en-mail-mode "2EN-Mail*" 1
	  "Minor mode which can send buffer as a mail message."
	  ()
	  (set-comtab *mode-comtab* '(#\End  com-send-mail
				      #\Abort com-news-exit
				      #\Help com-mail-mode-documentation
				      #\C-M-Y com-yank-news-message
				      #\mouse-r-1 com-mail-mode-general-mouse-menu 
				      )
		      '(("Send Mail" . com-send-mail)
			("Quit" . com-mail-mode-exit)
			("Delivery Status" . com-delivery-status)
			("Yank Message" . com-yank-news-message)
			("Yank Current Message" . com-yank-news-message)
			))
	  (set-mode-line-list (append (mode-line-list) '("  (END to mail -- ABORT to exit)"))))


(defcom 4COM-YANK-NEWS-MESSAGE*
	""
	()
  (let ((stream (interval-stream-into-bp (interval-last-bp *interval*))))
    (en-group-command *mail-newsgroup-component*)
    (en-body-command *mail-newsgroup-component*)
    (format stream "In article ~a you write:" (get-header-field *mail-newsgroup-component* :message-id t))
    (loop
      (multiple-value-bind (line eof) (nntp:read-nntp-stream *nntp-stream*)
	(cond
	  (eof (return :eof))
	  (t (format stream "~%~a~a" zwei:*yank-message-prefix* line)))))
    (format stream "~2%")
    (move-to-bp (send stream :read-bp)))
  dis-text)


(define-mail-template 4DEFAULT-REPLY-NEWS-MAIL-TEMPLATE* "Reply" :reply
  "Reply to a news message."
  (let ((stream (interval-stream *interval*))
	(subject (get-header-field *mail-newsgroup-component* :subject t)))
    (format stream "From:        ~@[~a~]" (send (mail:default-from-address) :string-for-message))
    (format stream "~%To:          ~@[~a~]" (get-header-field *mail-newsgroup-component* :from t))
    (format stream "~%Subject:     ~@[~a~]" (if subject (format nil "RE: ~a" (strip-re-from-subject subject))))
    (format stream "~%Newsgroups:  ~@[~a~]" (or (get-header-field *mail-newsgroup-component* :followup-to t)
						(get-header-field *mail-newsgroup-component* :newsgroups t)
						(send *mail-newsgroup-component* :newsgroup-string)))
    (if subject
	(format stream "~%In-reply-to: ~@[~a~]" (get-header-field *mail-newsgroup-component* :message-id t)))
    (format stream "~2%")
    (turn-on-mode 'en-mail-mode)
    (move-to-bp (send stream :read-bp))))


(define-mail-template 4DEFAULT-FORWARD-NEWS-MAIL-TEMPLATE* "Forward" :forward
  "Forward a news message."
  (let ((stream (interval-stream *interval*)) saved-bp line eof)
    (format stream "From:        ~@[~a~]" (send (mail:default-from-address) :string-for-message))
    (format stream "~%To:          ")
    (setf saved-bp (copy-bp (send stream :read-bp)))
    (format stream "~%Subject:     [~@[~a~]:  ~@[~a~]]" (get-header-field *mail-newsgroup-component* :from t)
	    (get-header-field *mail-newsgroup-component* :subject t))
    (when (stringp *forwarded-message-begin*)
      (format stream "~3%~a~2%" *forwarded-message-begin*))
    ;1;;Write the selected header lines from the article.*
    (when (and (en-group-command *mail-newsgroup-component*)
	       (en-header-p *mail-newsgroup-component*))
      (dolist (item *reformat-newsheaders-forward-include-list* nil)
	(when (setf line (get-header-field *mail-newsgroup-component* item (if (equal item :newsgroups) t nil)))
	  (format stream "~%~a" (if (equal item :newsgroups) (format nil "To: ~a" line) line))))
      (format stream "~2%")
      (en-body-command *mail-newsgroup-component*)
      (loop
	(multiple-value-setq (line eof) (nntp:read-nntp-stream *nntp-stream*))
	(cond
	  (eof (return :eof))
	  (t (format stream "~%~a" line)))))
    (when (stringp *forwarded-message-end*)
      (format stream "~2%~a~%" *forwarded-message-end*))
    (format stream "~2%")
    (turn-on-mode 'en-mail-mode)
    (move-to-bp saved-bp)))



