/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: typeuid.c,v 1.18 1994/02/15 02:18:04 janssen Exp $
*/

#include <string.h>
#include <stdarg.h>
#include <time.h>
#include "iluptype.h"

#define TRUE  1
#define FALSE 0
typedef int Boolean;

#define AND  &&
#define OR   ||
#define NOT  !

#include <stdio.h>

struct buffer_s {
  unsigned char *data;
  unsigned long size;
  unsigned long used;
};

char *FigureTypeUID (Type t);

static char *full_type_name(Type t)
{
  string n;

  if ((n = name_lang_name (t->name, "parser:full")) == NULL)
    {
      char buf[1024];
      sprintf (buf, "%s%s%s.%s",
	       t->builtIn ? "ILU" : interface_name(t->interface),
	       t->builtIn ? "" : (t->interface->brand != NULL) ? "|" : "",
	       t->builtIn ? "" : (t->interface->brand != NULL) ? t->interface->brand : "",
	       type_name(t));
      name_set_lang_name (t->name, "parser:full", buf);
      n = name_lang_name(t->name, "parser:full");
    }
  return (n);
}

static void print0ToBuffer (struct buffer_s *buf, char *data)
{
  int n = strlen(data);

  if ((buf->size - buf->used) < n)
    buf->data = (unsigned char *) Realloc(buf->data, buf->size = buf->size + n + 1000);
  memmove (buf->data + buf->used, data, n);
  buf->used += n;
}

static void printmToBuffer(struct buffer_s *buf, char *format,...)
{
  va_list ap;	/* points to each unnamed arg. */
  char buf2[1024];

  va_start(ap,format);
  vsprintf (buf2, format, ap);
  print0ToBuffer (buf, buf2);
  va_end(ap);
}

static void ast_recurse(Type t, struct buffer_s *data);

static void recurseEnumFields (EnumField field, struct buffer_s *data)
{
  printmToBuffer (data, "%s ", field->name);
}

static void recurseArrayDimensions (unsigned long dim, struct buffer_s *data)
{
  printmToBuffer (data, "%u ", dim);
}

static void recurseRecordFields (Argument field, struct buffer_s *data)
{
  if (field->type != NULL)
    printmToBuffer (data, "%s ", FigureTypeUID(field->type));
}

static void recurseException (Exception e, struct buffer_s *data)
{
  printmToBuffer (data, " (%s.%s", interface_name(e->interface), exception_name(e));
  if (e->type != NULL && type_basic_type(e->type) != void_Type)
    printmToBuffer (data, " %s", FigureTypeUID(e->type));
  print0ToBuffer (data, ")");
}

static void recurseObjectMethods (Procedure proc, struct buffer_s *data)
{
  printmToBuffer (data, "(method %s %s%s(", name_base_name(proc->name),
		  proc->asynch ? "ASYNCHRONOUS " : "", proc->functional ? "FUNCTIONAL " : "");
  list_enumerate (proc->arguments, (void (*)(refany, refany)) recurseRecordFields, data);
  printmToBuffer (data, ") %s (",
		  (proc->returnType != NULL && type_basic_type(proc->returnType) != void_Type)
		  ? FigureTypeUID(proc->returnType) : "");
  list_enumerate (proc->exceptions, (void (*)(refany, refany)) recurseException, data);
  print0ToBuffer (data, "))");
}

static void ast_recurse (Type t, struct buffer_s *data)
{
  extern TypeDescription type_description(Type t);

  if (t == NULL)
    return;
  if (t->marked)
    {
      print0ToBuffer (data, "[self]");
      return;
    }

  t->marked = TRUE;
  if (t->description == NULL AND t->supertype != NULL)
    ast_recurse (t->supertype, data);
  else if (t->builtIn)
    {
      printmToBuffer (data, "[%s]", full_type_name(t));
    }
  else if (type_basic_type(t) == enumeration_Type)
    {
      printmToBuffer (data, "(enumeration ");
      list_enumerate (type_description(t)->structuredDes.record, (void (*)(refany, refany)) recurseEnumFields, data);
      print0ToBuffer (data, ")");
    }
  else if (type_basic_type(t) == record_Type)
    {
      print0ToBuffer (data, "(record ");
      list_enumerate (type_description(t)->structuredDes.record, (void (*)(refany, refany)) recurseRecordFields, data);
      print0ToBuffer (data, ")");
    }
  else if (type_basic_type(t) == union_Type)
    {
      print0ToBuffer (data, "(union ");
      list_enumerate (type_description(t)->structuredDes.uniond.types, (void (*)(refany, refany)) recurseRecordFields, data);
      print0ToBuffer (data, ")");
    }
  else if (type_basic_type(t) == object_Type)
    {
      Class c = type_description(t)->structuredDes.object;
      printmToBuffer (data, "(object %s %s %s %s (superclasses ",
		      full_type_name(t),
		      (c->brand != NULL) ? c->brand : "",
		      c->singleton ? "SINGLETON" : "",
		      c->collectible ? "COLLECTIBLE" : "");
      list_enumerate (type_description(t)->structuredDes.object->superclasses, (void (*)(refany, refany)) ast_recurse, data);
      print0ToBuffer (data, ") (methods ");
      list_enumerate (type_description(t)->structuredDes.object->methods, (void (*)(refany, refany)) recurseObjectMethods, data);
      print0ToBuffer (data, "))");
    }
  else if (type_basic_type(t) == sequence_Type)
    {
      printmToBuffer (data, "(sequence %u %s)",
		      type_description(t)->structuredDes.sequence.limit,
		      FigureTypeUID(type_description(t)->structuredDes.sequence.type));
    }
  else if (type_basic_type(t) == array_Type)
    {
      printmToBuffer (data, "(array (", type_description(t)->structuredDes.sequence.limit);
      list_enumerate (type_description(t)->structuredDes.array.dimensions, (void (*)(refany, refany)) recurseArrayDimensions, data);
      printmToBuffer (data, ") %s)", FigureTypeUID(type_description(t)->structuredDes.array.type));
    }
  else if (type_basic_type(t) == optional_Type)
    {
      printmToBuffer (data, "(optional %s)", FigureTypeUID(type_description(t)->structuredDes.optional));
    }
  else
    {
      fprintf (stderr, "Strange type, %s\n", full_type_name(t));
      exit(1);
    }
  t->marked = FALSE;
}

#include "SHS.h"
#include <assert.h>

/*
 * convert a byte-string of len bytes to base-64
 */
void convbase(unsigned char *bstring,unsigned long len,char *outbuf)
{
	static char *digits = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-=";
	char *result=outbuf;
	int i;
	unsigned nbits,nframe;
	unsigned long bbuf,topbits;	/* bit buffer */

	/* figure out the framing:  how many leading 0 bits do we place in the
	 * MSB positions to make byte-string a multiple of 6 bits?
	 */
	/* NB: outermoust % to prevent nframe of 6 */
	nframe=(6 - ((len * 8) % 6)) % 6;

	/* nbits keeps track of the number of bits currently in bbuf;  this
	 * tracks the difference between the rate at which we put bits in to
	 * bbuf and take bits out:  we shift in 8 bits at a time, and extract
	 * 6 bits at a time;  nbits follows this difference.
	 */
	for (i=0, nbits=nframe, bbuf=0; i < len; i++) {
		/* shift in another byte into bbuf */
		bbuf=(bbuf << 8) | bstring[i];
		nbits+=8;

		/* take out as many bits as we can in groups of 6 */
		while (nbits >= 6) {
			/* take the 6 most-significant bits first */
			topbits=(bbuf >> (nbits-6));
			*result++=digits[topbits];

			/* mask out the high-order bits we just extracted */
			nbits-=6;
			bbuf=bbuf & ((1 << nbits) - 1);
		}
	}
	/* we can assert nbits==0, because start framing ensures it */
	assert(nbits==0);
	*result='\0';
}

char *FigureTypeUID (Type t)
{
  struct buffer_s buffer;
  unsigned char hash[20];
  SHS_CTX ctx;

/*
  printf ("figuring uid for <%s>\n", full_type_name(t));
*/
  if (t->uid != NULL)
    return (t->uid);

  if (t->marked)
    return ("[self]");
  buffer.data = (unsigned char *) Malloc(buffer.size = 1024);
  buffer.used = 0;
  ast_recurse (t, &buffer);
  buffer.data[buffer.used] = '\0';

  /* printf ("  buffer is <%s>\n", buffer.data); */

  SHSInit(&ctx);
  SHSUpdate (&ctx, buffer.data, buffer.used);
  SHSFinal (hash, &ctx);

/*
  {
    int i;

    printf ("  hash is ");
    for (i = 0;  i < 20;  i += 1)
      printf ("%u ", hash[i]);
    printf ("\n");
  }
*/

  t->uid = (char *) Malloc(32);
  strncpy (t->uid, "ilu:", 4);
  /* convert to base 64 */
  convbase(hash,20,t->uid + 4);
  Free(buffer.data);
/*   printf ("  uid is %s\n", t->uid); */
  return (t->uid);

}
