/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
$Id: type-basics.c,v 1.15 1994/02/10 06:05:02 janssen Exp $
*/

#include "lisp.h"

extern void GenerateClassCode (Type, Context);
extern void GenerateClassDefinition (Type, Context);

void OutputTypeName (Type type, Context context)
{
  enum PrimitiveTypes t = type_basic_type(type);

  if (t == byte_Type) 
    fprintf (context->file, " (:primitive :byte)");
  else if (t == shortinteger_Type) 
    fprintf (context->file, " (:primitive :short-integer)");
  else if (t == longinteger_Type) 
    fprintf (context->file, " (:primitive :long-integer)");
  else if (t == shortcharacter_Type) 
    fprintf (context->file, " (:primitive :short-character)");
  else if (t == character_Type) 
    fprintf (context->file, " (:primitive :character)");
  else if (t == integer_Type) 
    fprintf (context->file, " (:primitive :integer)");
  else if (t == shortcardinal_Type) 
    fprintf (context->file, " (:primitive :short-cardinal)");
  else if (t == longcardinal_Type) 
    fprintf (context->file, " (:primitive :long-cardinal)");
  else if (t == cardinal_Type) 
    fprintf (context->file, " (:primitive :cardinal)");
  else if (t == boolean_Type) 
    fprintf (context->file, " (:primitive :boolean)");
  else if (t == real_Type) 
    fprintf (context->file, " (:primitive :real)");
  else if (t == shortreal_Type)
    fprintf (context->file, " (:primitive :short-real)");
  else if (t == longreal_Type)
    fprintf (context->file, " (:primitive :long-real)");
  else
    fprintf (context->file, " (%s %s)",
	     (t == object_Type) ? ":object" : ":constructed",
	     lisp_type_name(type));
}

static void OutputUnionTypeName (Argument type, Context context)
{
  OutputTypeName (type->type, context);
}

static void OutputEnumerationField (EnumField field, Context context)
{
  char buf[100];

  fprintf (context->file, " (%s %s)\n", lisp_string(field->name),
	   (field->id < 0) ? "-1" : (sprintf(buf, "%u", field->id), buf));
}

static void OutputFieldDescription (Argument field, Context context)
{
  fprintf (context->file, " (%s", lisp_argument_name(field));
  OutputTypeName (field->type, context);
  fprintf (context->file, ")\n");
}

static void OutputDimension (long int d, Context context)
{
  fprintf (context->file, " %u", d);
}

static void GenerateTypeStubs (Type type, Context context)
{
  enum PrimitiveTypes t = type_basic_type(type);
  TypeDescription d = type_description(type);

  if (type->builtIn || t == invalid_Type || t == void_Type || type->importInterfaceName != NULL)
    return;

  switch (t)
    {
    case byte_Type:
    case shortinteger_Type:
    case shortcharacter_Type:
    case longinteger_Type:
    case character_Type:
    case integer_Type:
    case shortcardinal_Type:
    case longcardinal_Type:
    case cardinal_Type:
    case boolean_Type:
    case real_Type:
    case shortreal_Type:
    case longreal_Type:
      /* no methods define on these types, no output needed here. */
      break;

    case union_Type:
      fprintf (context->file, "(ilu:define-union %s ", lisp_type_name(type));
      list_enumerate (d->structuredDes.uniond.types, (EnumProc) OutputUnionTypeName, context);
      fprintf (context->file, ")\n");
      break;

    case sequence_Type:
      fprintf (context->file, "(ilu:define-sequence %s", lisp_type_name(type));
      OutputTypeName (d->structuredDes.sequence.type, context);
      fprintf (context->file, " %u)\n", d->structuredDes.sequence.limit);
      break;

    case optional_Type:
      fprintf (context->file, "(ilu:define-optional %s ", lisp_type_name(type));
      OutputTypeName (d->structuredDes.optional, context);
      fprintf (context->file, ")\n");
      break;

    case record_Type:
      fprintf (context->file, "(ilu:define-record %s\n", lisp_type_name(type));
      list_enumerate (d->structuredDes.record, (EnumProc) OutputFieldDescription, context);
      fprintf (context->file, " )\n");
      break;

    case array_Type:
      fprintf (context->file, "(ilu:define-array %s", lisp_type_name(type));
      OutputTypeName (d->structuredDes.array.type, context);
      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) OutputDimension, context);
      fprintf (context->file, ")\n");
      break;

    case enumeration_Type:
      fprintf (context->file, "(ilu:define-enumeration %s\n", lisp_type_name(type));
      list_enumerate (d->structuredDes.enumeration, (EnumProc) OutputEnumerationField, context);
      fprintf (context->file, " )\n");
      break;      

    case object_Type:
      GenerateClassCode (type, context);
      break;

    default:
      break;
    };
  fprintf (context->file, "\n");
}

static void GenerateTypeDefinition (Type type, Context context)
{
  enum PrimitiveTypes t = type_basic_type(type);
  TypeDescription d = type_description(type);

  if (type->builtIn || t == invalid_Type || t == void_Type || type->importInterfaceName != NULL)
    return;

  switch (t)
    {
    case byte_Type:
    case shortinteger_Type:
    case shortcharacter_Type:
    case longinteger_Type:
    case character_Type:
    case integer_Type:
    case shortcardinal_Type:
    case longcardinal_Type:
    case cardinal_Type:
    case boolean_Type:
    case real_Type:
    case shortreal_Type:
    case longreal_Type:
      fprintf (context->file, "(ilu:define-primitive-type %s ", lisp_type_name(type));
      OutputTypeName (type, context);
      fprintf (context->file, ")\n");
      break;

    case union_Type:
      fprintf (context->file, "(ilu:define-union-type %s ", lisp_type_name(type));
      list_enumerate (d->structuredDes.uniond.types, (EnumProc) OutputUnionTypeName, context);
      fprintf (context->file, ")\n");
      break;

    case sequence_Type:
      fprintf (context->file, "(ilu:define-sequence-type %s", lisp_type_name(type));
      OutputTypeName (d->structuredDes.sequence.type, context);
      fprintf (context->file, " %u)\n", d->structuredDes.sequence.limit);
      break;

    case optional_Type:
      fprintf (context->file, "(ilu:define-optional-type %s ", lisp_type_name(type));
      OutputTypeName (d->structuredDes.optional, context);
      fprintf (context->file, ")\n");
      break;

    case record_Type:
      fprintf (context->file, "(ilu:define-record-type %s\n", lisp_type_name(type));
      list_enumerate (d->structuredDes.record, (EnumProc) OutputFieldDescription, context);
      fprintf (context->file, " )\n");
      break;

    case array_Type:
      fprintf (context->file, "(ilu:define-array-type %s", lisp_type_name(type));
      OutputTypeName (d->structuredDes.array.type, context);
      list_enumerate (d->structuredDes.array.dimensions, (EnumProc) OutputDimension, context);
      fprintf (context->file, ")\n");
      break;

    case enumeration_Type:
      fprintf (context->file, "(ilu:define-enumeration-type %s\n", lisp_type_name(type));
      list_enumerate (d->structuredDes.enumeration, (EnumProc) OutputEnumerationField, context);
      fprintf (context->file, " )\n");
      break;      

    case object_Type:
      GenerateClassDefinition (type, context);
      break;      

    default:
      break;
    };
  fprintf (context->file, "\n");
}

static void GenerateExceptionDef (Exception e, Context context)
{
  if (e->builtIn || e->importInterfaceName != NULL)
    return;

  fprintf (context->file, "(ilu:define-exception-type %s", lisp_exception_name(e));
  if (e->type == NULL)
    fprintf (context->file, " cl:nil");
  else
    OutputTypeName (e->type, context);
  fprintf (context->file, ")\n\n");
}

static void GenerateExceptionCode2 (Exception e, Context context)
{
  if (e->builtIn || e->importInterfaceName != NULL)
    return;

  fprintf (context->file, "(ilu:define-exception %s", lisp_exception_name(e));
  if (e->type == NULL)
    fprintf (context->file, " cl:nil");
  else
    OutputTypeName (e->type, context);
  fprintf (context->file, ")\n\n");
}

void GenerateTypeDefinitions (Interface interface, FILE *file)
{
  struct context_s context;

  context.file = file;
  context.interface = interface;

  list_enumerate (interface->types, (EnumProc) GenerateTypeDefinition, &context);
}

void GenerateTypeCode (Interface interface, FILE *file)
{
  struct context_s context;

  context.file = file;
  context.interface = interface;

  list_enumerate (interface->types, (EnumProc) GenerateTypeStubs, &context);
}

void GenerateExceptionDefinitions (Interface interface, FILE *file)
{
  struct context_s context;

  context.file = file;
  context.interface = interface;

  list_enumerate (interface->exceptions, (EnumProc) GenerateExceptionDef, &context);
}

void GenerateExceptionCode (Interface interface, FILE *file)
{
  struct context_s context;

  context.file = file;
  context.interface = interface;

  list_enumerate (interface->exceptions, (EnumProc) GenerateExceptionCode2, &context);
}
