/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: class-record.c,v 1.17 1994/04/30 03:58:11 janssen Exp $
*/

#include <string.h>

#include "lisp.h"

extern Class class_object(Type);

static boolean IncludeComma = FALSE;

static boolean hasMethods (Type t)
{
  return (list_size(class_object(t)->methods) > 0);
}

static void GenerateMethodLine (Procedure m, Context context)
{
  fprintf (context->file, "%s\n\t{ \"%s\", %u, %u, %u,  NULL, %u, NULL }",
	   IncludeComma ? "," : "", procedure_name(m), m->id, m->functional ? 1 : 0, m->asynch ? 1 : 0,
	   (m->exceptions == NULL) ? 0 : list_size(m->exceptions));
}

static void GenerateMethods (Type t, Context context)
{
  Class od;

  if (t == NULL OR type_basic_type(t) != object_Type OR (od = class_object(t)) == NULL)
    return;
  if (list_size(od->methods) > 0)
    {
      GenerateMethodLine (list_car(od->methods), context);
      IncludeComma = TRUE;
      if (list_size(od->methods) > 1)
	list_enumerate (list_cdr(od->methods), (EnumProc) GenerateMethodLine, context);
    }
}

static void UnmarkSupertypes (Type t)
{
  Type st;

  if (st == NULL OR type_basic_type(t) != object_Type)
    return;
  for (st = t;  st->supertype != NULL;  st = st->supertype)
    ;

  list_enumerate (class_object(st)->superclasses, (EnumProc) UnmarkSupertypes, NULL);
  st->marked = FALSE;
}

static void generate_methods_table (Type class, Context context)
{
  if (hasMethods(class))
    {
      fprintf (context->file, "static struct _ilu_Method_s MethodsOf%s[] = {\n", c_type_name(class));
      fprintf (context->file, "\t/* name, id, cacheable, asynchronous, evector, ecount, stubproc */\n");
      IncludeComma = FALSE;
      GenerateMethods (class, context);
      fprintf (context->file, "\n};\n\n");
    }
}

static boolean FirstInList = FALSE;

static void PrintTypeID (Type type, Context context)
{
  Type st;

  for (st = type;  st->supertype != NULL;  st = st->supertype)
    ;
  fprintf (context->file, "%s\t\"%s\"", (FirstInList ? "" : ",\n"), st->uid);
  FirstInList = FALSE;
}

static void generate_superclass_records (Type type, Context context)
{
  fprintf (context->file, "static ilu_Class Superclasses_for_%s[%u];\n",
	   c_type_name(type), list_size(class_object(type)->superclasses));

  fprintf (context->file, "static ilu_string Superclass_IDs_for_%s[%u] = {\n", c_type_name(type),
	   list_size(class_object(type)->superclasses));
  FirstInList = TRUE;
  list_enumerate (class_object(type)->superclasses, (EnumProc) PrintTypeID, context);
  fprintf (context->file, "\n\t};\n\n");

}

void GenerateCRecord (Type class, FILE *file)
{
  char *tn = (char *) c_type_name(class);
  Class o = class_object(class);
  struct context_s context;

  context.file = file;
  context.interface = class->interface;

  UnmarkSupertypes (class);

  if (hasMethods(class))
    generate_methods_table (class, &context);

  UnmarkSupertypes (class);

  if (list_size(o->superclasses) > 0)
    generate_superclass_records (class, &context);

  fprintf (context.file, "static struct _ilu_Class_s ILUClassRecordFor_%s = {\n", tn);
  fprintf (context.file, "\t\"%s.%s\",\t/* ILU name */\n\t\"%s\",\t/* Brand */\n",
	   name_base_name(context.interface->name), name_base_name(class->name), o->brand == NULL ? "" : o->brand);
  fprintf (context.file, "\t\"%s\",\t/* id */\n\t%u,\t/* singleton? */\n\t%u,\t/* collectible? */\n",
	   class->uid, o->singleton ? 1 : 0, o->collectible ? 1 : 0);
  fprintf (context.file, "\t%s%s%s,\t/* authentication */\n",
	   o->authentication == NULL ? "" : "\"",
	   o->authentication == NULL ? "NULL" : o->authentication,
	   o->authentication == NULL ? "" : "\"");
  if (hasMethods(class))
    {
      fprintf (context.file, "\tMethodsOf%s,\t/* methods table */\n", tn);
      fprintf (context.file, "\tsizeof(MethodsOf%s)/sizeof(struct _ilu_Method_s),\t/* number of methods */\n", tn);
    }
  else
    fprintf (context.file, "\tNULL,\t/* no methods */\n\t0,\t/* zero methods */\n");

  if (o->superclasses == NULL OR list_size(o->superclasses) == 0)
    fprintf (context.file, "\t0,\t/* number of superclasses */\n\tNULL,\t/* superclass link */\n\tNULL\t/* superclass unique_id */\n};\n\n");
  else
    {
      fprintf (context.file, "\t%u,\t/* number of superclasses */\n", list_size(o->superclasses));
      fprintf (context.file, "\tSuperclass_IDs_for_%s,\t/* IDs of superclasses */\n", tn);
      fprintf (context.file, "\tSuperclasses_for_%s,\t/* superclasses */\n", tn);
      fprintf (context.file, "\t0 };\n\n");
    }

  fprintf (file, "void _%s_SetClassOfILUObject (obj)\n\tilu_Object obj;\n{\n\tobj->ob_class = &ILUClassRecordFor_%s;\n}\n\n", tn, tn);
  fprintf (file, "ilu_Class _%s_GetILUClassRecord ()\n{\n\treturn (&ILUClassRecordFor_%s);\n}\n\n",
	   tn, tn);
  fprintf (file, "char * _%s_GetILUClassName ()\n{\n\treturn (ILUClassRecordFor_%s.cl_name);\n}\n\n",
	   tn, tn);
}
