/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: class-basics.c,v 1.10 1994/04/09 05:56:49 janssen Exp $
*/

#include "lisp.h"

static void OutputValueName (Argument v, Context context)
{
  fprintf (context->file, " (%s", lisp_argument_name(v));
  OutputTypeName (v->type, context);
  if (v->direction == InOut)
    fprintf (context->file, " :inout");
  else if (v->direction == Out)
    fprintf (context->file, " :out");
  else if (v->direction == In)
    fprintf (context->file, " :in");
  fprintf (context->file, ")");
}

static void OutputExceptionName (Exception e, Context context)
{
  fprintf (context->file, " %s", lisp_exception_name(e));
}

static void OutputMethodSig (Procedure m, Context context)
{
  fprintf (context->file, "  (%s %u %s %s ", lisp_procedure_name(m),
	   m->id,
	   m->functional ? "cl:t" : "cl:nil",
	   m->asynch ? "cl:t" : "cl:nil");
  if (m->returnType == NULL)
    fprintf (context->file, " cl:nil");
  else
    OutputTypeName (m->returnType, context);
  fprintf (context->file, " (");
  list_enumerate (m->arguments, (EnumProc) OutputValueName, context);
  fprintf (context->file, ") (");
  list_enumerate (m->exceptions, (EnumProc) OutputExceptionName, context);
  fprintf (context->file, "))\n");
}

static void GenerateMethod (Procedure m, Context context)
{
  Class c = type_description(m->object)->structuredDes.object;

  fprintf (context->file, "(ilu:define-method %s\n %u\t; id\n %s\t; singleton-p\n %s\t; functional\n %s\t; asynch\n",
	   lisp_procedure_name(m), m->id, c->singleton ? "cl:t" : "cl:nil",
	   m->functional ? "cl:t" : "cl:nil", m->asynch ? "cl:t" : "cl:nil");
  fprintf (context->file, " (\t; arguments\n  (self");
  OutputTypeName (m->object, context);
  fprintf (context->file, ")");
  list_enumerate (m->arguments, (EnumProc) OutputValueName, context);
  fprintf (context->file, ")\n (");
  list_enumerate (m->exceptions, (EnumProc) OutputExceptionName, context);
  fprintf (context->file, ")\t; exceptions\n");
  if (m->returnType == NULL)
    fprintf (context->file, " cl:nil");
  else
    OutputTypeName (m->returnType, context);
  fprintf (context->file, "\t; return type\n)\n\n");
}

static void PrintClassName (Type type, Context context)
{
  Type st = type;

  while (st->supertype != NULL)
    st = st->supertype;

  fprintf (context->file, " %s", lisp_type_name(st));
}

void GenerateClassDefinition (Type class, Context context)
{
  Class c;

  c = type_description(class)->structuredDes.object;

  fprintf (context->file, "(ilu:define-class-type %s (", lisp_type_name(class));
  list_enumerate(c->superclasses, (EnumProc) PrintClassName, context);
  fprintf (context->file, ")\t; superclasses\n %s\t; singleton?\n %s\t; authentication\n (\t; methods\n",
	   c->singleton ? "cl:t" : "cl:nil",
	   (c->authentication == NULL) ? "cl:nil" : lisp_string (c->authentication));
  list_enumerate (c->methods, (EnumProc) OutputMethodSig, context);
  fprintf (context->file, " ))\n\n");
}

void GenerateClassCode (Type class, Context context)
{
  Class c;

  c = type_description(class)->structuredDes.object;

  fprintf (context->file, "(ilu:define-class %s\n", lisp_type_name(class));
  fprintf (context->file, " \"_%s_SetClassOfILUObject\"\t; set-class-fn\n \"_%s_GetILUClassRecord\"\t; get-class-fn\n \"_%s_GetILUClassName\"\t; get-class-name-fn\n %s)\t; authentication\n\n",
	   c_type_name(class), c_type_name(class), c_type_name(class),
	   (c->authentication == NULL) ? "cl:nil" : lisp_string (c->authentication));

  list_enumerate (c->methods, (EnumProc) GenerateMethod, context);
}

