/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#ifndef _AST_UNION_AST_UNION_HH
#define _AST_UNION_AST_UNION_HH

#pragma ident "%@(#)AST_Union.h	1.37% %92/06/10% Sun Microsystems"

// Representation of union declaration:
//
// NOTE: add(AST_ConcreteType *) is defined here because a union
// can contain locally defined types in addition to fields.
//
// NOTE: add(AST_EnumValue *) is defined here because enums can
// be defined manifest locally; the constants defined in these
// enums are inserted in the enclosing scope. It is unlikely that
// a BE writer will need to overload this function in AST_Union.

/*
** DEPENDENCIES: ast_concrete_type.hh, utl_scope.hh, ast_union_branch.hh,
**		 ast_union_label.hh, utl_scoped_name.hh, utl_strlist.hh
**
** USE: Included from ast.hh
*/

class	AST_Union : public virtual AST_ConcreteType, public virtual UTL_Scope
{
public:
  // Operations

  // Constructor(s)
  AST_Union();
  AST_Union(AST_ConcreteType *disc_type, UTL_ScopedName *n, UTL_StrList *p);

  // Scope Management Protocol
  virtual AST_Union		*add_union(AST_Union			*u);
  virtual AST_UnionBranch	*add_union_branch(AST_UnionBranch	*b);
  virtual AST_Structure		*add_structure(AST_Structure		*s);
  virtual AST_Enum		*add_enum(AST_Enum			*e);
  virtual AST_EnumVal		*add_enum_val(AST_EnumVal		*v);

  // Data Accessors
  AST_ConcreteType *disc_type();
  AST_Expression::ExprType udisc_type();

  // Narrowing
  DEF_NARROW_METHODS2(AST_Union, AST_ConcreteType, UTL_Scope);
  DEF_NARROW_FROM_DECL(AST_Union);
  DEF_NARROW_FROM_SCOPE(AST_Union);

  // AST Dumping
  virtual void			dump(ostream &);

private:
  // Data
  AST_ConcreteType		*pd_disc_type;	// Discriminator type
  AST_Expression::ExprType	pd_udisc_type;	// Its expression type
  /* Convention: udisc_type == EV_any denotes an enum value */

  // Operations

  // Look up a branch by node pointer
  AST_UnionBranch		*lookup_branch(AST_UnionBranch *branch);

  // Look up the branch with the "default" label
  AST_UnionBranch		*lookup_default();

  // Look up a branch given a branch with a label. This is used to
  // check for duplicate labels
  AST_UnionBranch		*lookup_label(AST_UnionBranch *b);

  // Look up a union branch given an enumerator. This is used to
  // check for duplicate enum labels
  AST_UnionBranch		*lookup_enum(AST_UnionBranch *b);
};

#endif           // _AST_UNION_AST_UNION_HH
