/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#ifndef _AST_MODULE_AST_MODULE_HH
#define _AST_MODULE_AST_MODULE_HH

#pragma ident "%@(#)AST_Module.h	1.37% %92/06/10% Sun Microsystems"

// Representation of module
//
// NOTE: add(AST_EnumValue *) is defined here because enums can
// be defined manifest locally; the constants defined in these
// enums are inserted in the enclosing scope.

/*
** DEPENDENCIES: ast_decl.hh, utl_scope.hh, utl_scoped_name.hh, utl_strlist.hh
**
** USE: Included from ast.hh
*/

class	AST_Module : public virtual AST_Decl, public virtual UTL_Scope
{
public:
  // Operations

  // Constructor(s)
  AST_Module();
  AST_Module(UTL_ScopedName *n, UTL_StrList *p);

  // Scope Management Protocol

  virtual AST_PredefinedType	*add_predefined_type(AST_PredefinedType *t);
  virtual AST_Module		*add_module(AST_Module			*m);
  virtual AST_Interface		*add_interface(AST_Interface		*i);
  virtual AST_InterfaceFwd	*add_interface_fwd(AST_InterfaceFwd	*i);
  virtual AST_Constant		*add_constant(AST_Constant		*c);
  virtual AST_Exception		*add_exception(AST_Exception		*e);
  virtual AST_Union		*add_union(AST_Union			*u);
  virtual AST_Structure		*add_structure(AST_Structure		*s);
  virtual AST_Enum		*add_enum(AST_Enum			*e);
  virtual AST_EnumVal		*add_enum_val(AST_EnumVal		*v);
  virtual AST_Typedef		*add_typedef(AST_Typedef		*t);

  // Narrowing
  DEF_NARROW_METHODS2(AST_Module, AST_Decl, UTL_Scope);
  DEF_NARROW_FROM_DECL(AST_Module);
  DEF_NARROW_FROM_SCOPE(AST_Module);

  // AST Dumping
  virtual void			dump(ostream &o);
};

#endif           // _AST_MODULE_AST_MODULE_HH
