/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

/*
 * ast_typedef.cc - Implementation of class AST_Typedef
 *
 * AST_Typedef nodes represent an IDL typedef statement.
 * AST_Typedef is a subclass of AST_Decl (it is not a type,
 * but instead is a type renaming).
 * AST_Typedef nodes have a base type (a subclass of AST_Type)
 * and a name (an UTL_ScopedName).
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructor(s) and destructor
 */
AST_Typedef::AST_Typedef()
	   : pd_base_type(NULL)
{
}

AST_Typedef::AST_Typedef(AST_Type *bt, UTL_ScopedName *n, UTL_StrList *p)
	   : AST_Decl(AST_Decl::NT_typedef, n, p),
	     pd_base_type(bt)
{
}

/*
 * Private operations
 */

/*
 * Public operations
 */


/*
 * Redefinition of inherited virtual operations
 */

/*
 * Dump this AST_Typedef node to the ostream o
 */
void
AST_Typedef::dump(ostream &o)
{
  o << "typedef ";
  pd_base_type->dump(o);
  o << " " << local_name()->get_string();
}

/*
 * Data accessors
 */

AST_Type *
AST_Typedef::base_type()
{
  return pd_base_type;
}

// Narrowing
IMPL_NARROW_METHODS1(AST_Typedef, AST_Type)
IMPL_NARROW_FROM_DECL(AST_Typedef)
