/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_operation.cc	1.46% %92/06/11% Sun Microsystems"

/*
 * ast_operation.cc - Implementation of class AST_Operation
 *
 * AST_Operation nodes denote IDL operation declarations
 * AST_Operations are a subclass of AST_Decl (they are not a type!)
 * and of UTL_Scope (the arguments are managed in a scope).
 * AST_Operations have a return type (a subclass of AST_Type),
 * a bitfield for denoting various properties of the operation (the
 * values are ORed together from constants defined in the enum
 * AST_Operation::FLags), a name (a UTL_ScopedName), a context
 * (implemented as a list of Strings, a UTL_StrList), and a raises
 * clause (implemented as an array of AST_Exceptions).
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructor(s) and destructor
 */
AST_Operation::AST_Operation()
	     : pd_flags(OP_noflags),
	       pd_return_type(NULL),
	       pd_context(NULL),
	       pd_exceptions(NULL)
{
}

AST_Operation::AST_Operation(AST_Type *rt, Flags fl, UTL_ScopedName *n,
			   UTL_StrList *p)
	     : pd_return_type(rt),
	       pd_flags(fl),
	       pd_context(NULL),
	       pd_exceptions(NULL),
	       AST_Decl(AST_Decl::NT_op, n, p),
	       UTL_Scope(AST_Decl::NT_op)
{
  AST_PredefinedType *pdt;

  /*
   * Check that if the operation is oneway, the return type must be void
   */
  if (rt != NULL && pd_flags == OP_oneway) {
    if (rt->node_type() != AST_Decl::NT_pre_defined)
      idl_global->err()->error1(UTL_Error::EIDL_NONVOID_ONEWAY, this);
    else {
      pdt = AST_PredefinedType::narrow_from_decl(rt);
      if (pdt == NULL || pdt->pt() != AST_PredefinedType::PT_void)
        idl_global->err()->error1(UTL_Error::EIDL_NONVOID_ONEWAY, this);
    }
  }
}

/*
 * Private operations
 */

/*
 * Public operations
 */

/*
 * Redefinition of inherited virtual operations
 */

/*
 * Add this context (a UTL_StrList) to this scope
 */
UTL_StrList *
AST_Operation::add_context(UTL_StrList *t)
{
  pd_context = t;

  return t;
}

/*
 * Add these exceptions (identified by name) to this scope.
 * This looks up each name to resolve it to the name of a known
 * exception, and then adds the referenced exception to the list
 * of exceptions that this operation can raise.
 *
 * NOTE: No attempt is made to ensure that exceptions are mentioned
 *       only once..
 */
UTL_NameList *
AST_Operation::add_exceptions(UTL_NameList *t)
{
  UTL_NamelistActiveIterator *nl_i;
  UTL_ScopedName	     *nl_n;
  UTL_Scope		     *fs = idl_global->scopes()->top();
  AST_Exception		     *fe;
  AST_Decl		     *d;

  pd_exceptions = NULL;
  nl_i = new UTL_NamelistActiveIterator(t);
  while (!(nl_i->is_done())) {
    nl_n = nl_i->item();
    d = lookup_by_name(nl_n, TRUE);
    if (d == NULL || d->node_type() != AST_Decl::NT_except) {
      idl_global->err()->lookup_error(nl_n);
      delete nl_i;
      return NULL;
    }
    fe = AST_Exception::narrow_from_decl(d);
    pd_exceptions = new UTL_ExceptList(fe, pd_exceptions);
    nl_i->next();
  }
  delete nl_i;

  return t;
}

/*
 * Add this AST_Argument node (an operation argument declaration)
 * to this scope
 */
AST_Argument *AST_Operation::add_argument(AST_Argument *t)
{
  AST_Decl *d;

  /*
   * Already defined and cannot be redefined? Or already used?
   */
  if ((d = lookup_for_add(t, FALSE)) != NULL) {
    if (!can_be_redefined(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_REDEF, t, this, d);
      return NULL;
    }
    if (referenced(d)) {
      idl_global->err()->error3(UTL_Error::EIDL_DEF_USE, t, this, d);
      return NULL;
    }
    if (t->has_ancestor(d)) {
      idl_global->err()->redefinition_in_scope(t, d);
      return NULL;
    }
  }
  /*
   * Cannot add OUT or INOUT argument to oneway operation
   */
  if ((t->direction() == AST_Argument::dir_OUT ||
       t->direction() == AST_Argument::dir_INOUT) &&
      pd_flags == OP_oneway) {
    idl_global->err()->error2(UTL_Error::EIDL_ONEWAY_CONFLICT, t, this);
    return NULL;
  }
  /*
   * Add it to scope
   */
  add_to_scope(t);
  /*
   * Add it to set of locally referenced symbols
   */
  add_to_referenced(t, FALSE);

  return t;
}

/*
 * Dump this AST_Operation node (an operation) to the ostream o
 */
void
AST_Operation::dump(ostream &o)
{
  UTL_ScopeActiveIterator   *i;
  UTL_StrlistActiveIterator *si;
  UTL_ExceptlistActiveIterator *ei;
  AST_Decl		    *d;
  AST_Exception		    *e;
  String		    *s;

  if (pd_flags == OP_oneway)
    o << "oneway ";
  else if (pd_flags == OP_idempotent)
    o << "idempotent ";

  i = new UTL_ScopeActiveIterator(this, IK_decls);
  o << pd_return_type->local_name()->get_string() << " "
    << local_name()->get_string() << "(";
  while (!(i->is_done())) {
    d = i->item();
    d->dump(o);
    i->next();
    if (!(i->is_done()))
      o << ", ";
  }
  delete i;
  o << ")";

  if (pd_exceptions != NULL) {
    o << " raises(";
    ei = new UTL_ExceptlistActiveIterator(pd_exceptions);
    while (!(ei->is_done())) {
      e = ei->item();
      ei->next();
      o << e->local_name()->get_string();
      if (!(ei->is_done()))
	o << ", ";
    }
    delete ei;
    o << ")";
  }
  if (pd_context != NULL) {
    o << " context(";
    si = new UTL_StrlistActiveIterator(pd_context);
    while (!(si->is_done())) {
      s = si->item();
      si->next();
      o << s->get_string();
      if (!(si->is_done()))
	o << ", ";
    }
    delete si;
    o << ")";
  }    
}

/*
 * Data accessors
 */

AST_Type *
AST_Operation::return_type()
{
  return pd_return_type;
}

AST_Operation::Flags
AST_Operation::flags()
{
  return pd_flags;
}

UTL_StrList *
AST_Operation::context()
{
  return pd_context;
}

UTL_ExceptList *
AST_Operation::exceptions()
{
  return pd_exceptions;
}

// Narrowing
IMPL_NARROW_METHODS2(AST_Operation, AST_Decl, UTL_Scope)
IMPL_NARROW_FROM_DECL(AST_Operation)
IMPL_NARROW_FROM_SCOPE(AST_Operation)
