/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cplusplus.h,v 1.6 1994/04/06 01:35:34 severson Exp $
*/

#include <stdio.h>

#define TRUE  1
#define FALSE 0
typedef int Boolean;

#define AND  &&
#define OR   ||
#define NOT  !

#include <string.h>
#include <iluptype.h>

static char rcs_id[] = "$Header: /ilu/src/RCS/cplusplus.h,v 1.6 1994/04/06 01:35:34 severson Exp $";
static char xerox_copyright[] = "\
\
 Copyright 1989 Xerox Corporation\
 All Rights Reserved";

#define SEGFAULT	*((char *)1)='a'

typedef struct context_s {
  Interface interface;
  FILE *file;
  Type class;
} * Context;

Class class_object();
TypeDescription type_description();
enum PrimitiveTypes type_basic_type(Type);
string type_name(Type);
string cplusplus_return_type(Type type);
string cplusplus_type_name(Type t);
string cplusplus_simple_name(Name name);
string cplusplus_parameter_type(Type type);
list new_list();
boolean IsSequenceObject(Type type, Interface i);
boolean IsPipeObject(Type type, Interface i);
boolean TypeIsStruct();
boolean TypeIsArray(Type type);
boolean TypeIsString(Type type);
boolean TypeIsNonObjectStruct(Type type);
void SizeType (Type type, string name, boolean optional, Context context);
void EncodeValue (Type type, string name, boolean optional, Context context);
void UnpackValue (Context context, Type type, LineNumber line, string buffer, boolean ref, boolean optional, boolean allocate);
boolean BlockingCall (Procedure proc);

/* more prototypes which are needed */
void generate_headers (Interface interface, FILE *file);
void generate_code (Interface interface, FILE *file);
void generate_server_code (Interface parse, FILE *file);
string cplusplus_constant_name (Constant e);
string cplusplus_interface_name (Interface i);
string cplusplus_string (string s);
boolean PassedByRef (Type type);
string cplusplus_exception_name (Exception e);
void GenerateNecessaryIncludes (Context context);
string cplusplus_argument_name(Argument a);
string class_procedure_name (Procedure p);
boolean IsCacheableMethod (Procedure m);
refany list_find (list l, boolean_procedure proc, refany rock);
void list_insert (list l, refany element);
boolean list_remove (list l, refany element);
string procedure_name (Procedure p);
void list_clear (list l, boolean freeElements);
extern char *ilu_strdup(char *);
