#|
Copyright (c) 1991, 1992, 1993, 1994 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: ilu-def-package.lisp,v 1.11 1994/05/06 01:43:28 janssen Exp $
|#

(cl:in-package :user)

(cl:defpackage :ilu
  (:use :common-lisp)
  (:shadow cl:byte-size)
  (:export

   :initialize-ilu

   ;; type constructors

   :define-primitive-type
   :define-record-type
   :define-enumeration-type
   :define-sequence-type
   :define-array-type
   :define-union-type
   :define-class-type
   :define-method-type
   :define-optional-type

   :define-primitive
   :define-record
   :define-enumeration
   :define-sequence
   :define-array
   :define-union
   :define-class
   :define-method
   :define-optional

   :define-method-server-stub

   :define-exception-type
   :define-exception

   :setup-rpc-stubs

   :ilu-class-name
   :ilu-class-record
   :ilu-class-id
   :get-class-name
   :find-ilu-class-name

   :language-specific-object	;; (ilu-object) => lisp-object (setf-able)
   :object-of-sbh		;; (string-binding-handle) => ilu-object
   :ilu-object->instance	;; (class ilu-object) => obj
   :sbh->instance		;; (class sbh) => obj
   :destroy-instance		;; (obj) =>
   :string-binding-handle	;; (obj) => string-binding-handle

   ;; base class for objects

   :ilu-object
   :ilu-singleton-object
   :ilu-true-object

   ;; methods on ilu-object

   :rpc-method			;; (method-id) => C method descriptor
   :rpc-handle
   :instance-id
   :string-binding-handle
   :object-write
   :object-size
   :publish
   :withdraw
   :lookup

   ;; base class for exceptions

   :rpc-exception
   :exception-value
   :signal-exception
   :set-debug-level

   :*debug-uncaught-conditions*

   ;; some pre-defined exceptions and values

   :protocol-error
   :+protocol-exception-success+
   :+protocol-exception-no-such-class+
   :+protocol-exception-version-mismatch+
   :+protocol-exception-no-such-method+
   :+protocol-exception-bad-arguments+
   :+protocol-exception-unknown+
   :+protocol-exception-no-connection+
   :+protocol-exception-request-rejected+
   :+protocol-exception-request-timeout+
   
   :cstring
   
   ))

