/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: transprt.h,v 1.10 1994/02/15 20:33:29 janssen Exp $ */

#ifndef _TRANSPORT_H_
#define _TRANSPORT_H_ 1

/* some field accessors */

#define transport_file_descriptor(bs)	((bs)->tr_fd)
#define transport_data(bs)		((bs)->tr_data)
#define transport_class(bs)		((bs)->tr_class)
#define transport_type(bs)		((bs)->tr_class->type)

/* some macros for method dereferencing */

#define transport_connect(bs)			((*((bs)->tr_class->tc_connect))(bs))
#define transport_close(bs)			((*((bs)->tr_class->tc_close))(bs))
#define transport_interpret_info(bs,info)	((*((bs)->tr_class->tc_interpret_info))(info))
#define transport_form_handle(bs)		((*((bs)->tr_class->tc_form_info))((bs)->tr_data))
#define transport_n_data_present(bs)		((*((bs)->tr_class->tc_n_data_present))(bs))
#define transport_wait_for_input(bs,sure,limit)		((*((bs)->tr_class->tc_wait_for_input))(bs,sure,limit))
#define transport_read_message(bs,packet,size)	((*((bs)->tr_class->tc_read_message))((bs),(packet),(size)))
#define transport_send_message(bs,packet,size)	((*((bs)->tr_class->tc_send_message))((bs),(packet),(size)))
#define transport_flush_output(bs)		((*((bs)->tr_class->tc_flush_output))(bs))
#define transport_create_mooring(bs)		((*((bs)->tr_class->tc_create_mooring))(bs))

#endif
