/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: transprt.c,v 1.18 1994/04/27 03:33:54 janssen Exp $ */

#define _POSIX_SOURCE

#include "ilu.h"

#include "iluntrnl.h"
#include "transprt.h"
#include <string.h>

struct transports_s {
  /*For access: L1, L2, Main unconstrained.
    For calling: L1_sup < trmu; L2, Main unconstrained.*/

  ilu_string name;
  ilu_TransportType type;
  ilu_TransportClass (*instantiator)(void);
};

/*L1, L2, Main unconstrained*/

static struct transports_s transports[] = {
#ifdef UDPSOCKET_TRANSPORT
  { "udp", ilu_TransportType_UDP, _ilu_udp_TransportClass },
#endif /* UDPSOCKET_TRANSPORT */
#ifdef TCPIP_TRANSPORT
  { "tcp", ilu_TransportType_TCP, _ilu_tcp_TransportClass },
  { "btcp", ilu_TransportType_BufferedTCP, _ilu_tcp_TransportClass },
#endif /* TCPIP_TRANSPORT */
#ifdef XNSSPP_TRANSPORT
  { "xnsspp", ilu_TransportType_XNSSPP, _ilu_xnsspp_TransportClass },
  { "bxnsspp", ilu_TransportType_BufferedXNSSPP, _ilu_xnsspp_TransportClass },
#endif /* XNSSPP_TRANSPORT */
#ifdef INMEMORY_TRANSPORT
  { "memory", ilu_TransportType_Memory, _ilu_mem_TransportClass },
#endif /* INMEMORY_TRANSPORT */
  { NULL, 0, NULL } };

static struct transports_s *FindTransport (ilu_string pinfo)
{
  char buf[1000];
  ilu_integer i;

  if (pinfo != NULL)
    {
      ilu_string p;

      p = strchr(pinfo, '_');
      if (p == NULL)
	strcpy (buf, pinfo);
      else
	{
	  strncpy (buf, pinfo, p - pinfo);
	  buf[p - pinfo] = '\0';
	}
      for (i = 0;  transports[i].name != NULL;  i += 1)
	if (_ilu_casefree_cmp(buf, transports[i].name) == 0)
	  return(&transports[i]);
    }
  return (NULL);
}

static ilu_Transport _ilu_TransportCreate(ilu_TransportClass class,
					  ilu_integer fd, ilu_refany data)
{
  ilu_Transport new = (ilu_Transport)
		      malloc(sizeof(struct _ilu_Transport_s));
  static double to1 =  0.7;
  static double toN =  5.0;
  static double tto = 20.0;
  new->tr_class = class;
  new->tr_fd = fd;
  new->tr_to1 = ilu_FineTime_FromDouble(to1);
  new->tr_toN = ilu_FineTime_FromDouble(toN);
  new->tr_tto = ilu_FineTime_FromDouble(tto);
  new->tr_data = data;
  return (new);
}

static void _ilu_TransportFree (ilu_Transport t)
{
  free(t);
}

ilu_TransportType ilu_FindTransportTypeFromInfo (ilu_string pinfo)
{
  struct transports_s *p;

  if ((p = FindTransport(pinfo)) == NULL)
    return (ilu_TransportType_None);
  else
    return (p->type);
}

/*L1_sup < trmu*/
ilu_TransportClass _ilu_GetTransportClassByName (ilu_string name)
{
  struct transports_s *p;

  if ((p = FindTransport(name)) == NULL)
    return (NULL);
  else
    return ((*(p->instantiator))());
}

/*Main Invariant holds*/
ilu_Transport _ilu_GetTransportFromClass(ilu_TransportClass tc,
					 ilu_string pinfo)
{
  ilu_Transport t;
  t = _ilu_TransportCreate (tc, 0, NULL);
  t->tr_data = transport_interpret_info(t, pinfo);
  if (transport_connect(t))
      return (t);
  else
    {
      _ilu_TransportFree(t);
      return (NULL);
    }
}

