/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* Last tweaked by Mike Spreitzer September 9, 1993 3:06 pm PDT */

#define __ILU_IMPLEMENTATION_ 1

extern "C" {
#include "ilu-c++.h"
#include "iluxport.h"
};

#include "ilu.H"
#include <stdio.h>


ilu_Exception ilu::Success = NULL;
ilu_Exception ilu::ProtocolError = "ilu.ProtocolError";


void		ilu::RegisterClass		(ilu_Class c)
{
  ilu_RegisterClass ((ilu_Class) c);
}

ilu_Call	ilu::BeginCall			(ilu_KernelObject obj)
{
  return((ilu_Call)ilu_BeginCall(ilu_ServerOfObject(obj)));
}


ilu_Boolean 	ilu::BeginException		(ilu_Call call, ilu_Cardinal eIndex, ilu_Cardinal argSize)
{
  return((ilu_Boolean) ilu_BeginException(call, eIndex, argSize));
}


ilu_Boolean	ilu::BeginRequest	(ilu_Call call, ilu_Class pclass, ilu_Method method, ilu_Cardinal argSize)
{
  return((ilu_Boolean) ilu_BeginRequest(call, pclass, method, argSize));
}

ilu_Boolean	ilu::BeginReply	(ilu_Call call, ilu_Boolean exceptions, ilu_Cardinal argSize)
{
  return((ilu_Boolean) ilu_BeginReply(call, (ilu_boolean) exceptions, argSize));
}


void		ilu::EndSequence	(ilu_Call call)
{
  ilu_EndSequence(call);
}


void		ilu::EndUnion	(ilu_Call call)
{
  ilu_EndUnion(call);
}


void		ilu::EndRecord	(ilu_Call call)
{
  ilu_EndRecord(call);
}


void		ilu::EndArray	(ilu_Call call)
{
  ilu_EndArray(call);
}


ilu_Exception	ilu::ExceptionOfMethod	(ilu_Method method, ilu_Cardinal index)
{
  return(ilu_ExceptionOfMethod((ilu_Method)method, index));
}


ilu_Class	ilu::GetObjectClass		(ilu_KernelObject obj)
{
  return(ilu_ClassOfObject (obj));
}


ilu_Server	ilu::GetObjectServer		(ilu_KernelObject obj)
{
  return(ilu_ServerOfObject (obj));
}

ilu_Boolean	ilu::FinishCall	(ilu_Call call)
{
  ilu_FinishCall(call);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::FinishException (ilu_Call call)
{
  ilu_FinishException(call);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::FinishRequest	(ilu_Call call)
{
  ilu_FinishRequest(call);
  return((ilu_Boolean) 1);
}

ilu_Boolean	ilu::FinishReply	(ilu_Call call)
{
  ilu_FinishReply(call);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::FinishParameters	(ilu_Call call, void *obj)
{
  ilu_RequestRead(call);
  if (obj == NULL)
  {
    ilu_BeginException(call, 0, (ilu_cardinal) ilu_ProtocolException_GarbageArguments);
    ilu_FinishException(call);
    return ilu_FALSE;
  }
  return ilu_TRUE;
}


unsigned char	ilu::InputByte	(ilu_Call call, ilu_Byte *b)
{
  unsigned char b2;

  ilu_InputByte(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_Boolean	ilu::InputBoolean	(ilu_Call call, ilu_Boolean *b)
{
  ilu_boolean b2;

  ilu_InputBoolean(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_Boolean	ilu::InputOptional	(ilu_Call call, ilu_Boolean *b)
{
  ilu_boolean b2;

  ilu_InputOptional(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_Cardinal	ilu::InputCardinal	(ilu_Call call, ilu_Cardinal *b)
{
  ilu_cardinal b2;

  ilu_InputCardinal(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_Character	ilu::InputCharacter	(ilu_Call call, ilu_Character *b)
{
  ilu_character b2;

  ilu_InputCharacter(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_ShortCardinal	ilu::InputEnum		(ilu_Call call, ilu_ShortCardinal *b)
{
  unsigned short int b2;

  ilu_InputEnum(call, &b2);
  if (b != NULL)
    *b = b2;
  return((ilu_ShortCardinal) b2);
}


ilu_Integer	ilu::InputInteger	(ilu_Call call, ilu_Integer *b)
{
  ilu_integer b2;

  ilu_InputInteger(call, &b2);
  if (b != NULL)
    *b = b2;
  return((ilu_Integer) b2);
}


ilu_Real	ilu::InputReal	(ilu_Call call, ilu_Real *b)
{
  double b2;

  ilu_InputReal(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_ShortCardinal	ilu::InputShortCardinal	(ilu_Call call, ilu_ShortCardinal *b)
{
  ilu_shortcardinal b2;

  ilu_InputShortCardinal(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_ShortInteger	ilu::InputShortInteger	(ilu_Call call, ilu_ShortInteger *b)
{
  ilu_shortinteger b2;

  ilu_InputShortInteger(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_ShortReal	ilu::InputShortReal	(ilu_Call call, ilu_ShortReal *b)
{
  ilu_shortreal b2;

  ilu_InputShortReal(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


ilu_LongCardinal	ilu::InputLongCardinal	(ilu_Call call, ilu_LongCardinal *b)
{
  unsigned long int b2[2];
  ilu_LongCardinal v3;

  ilu_InputLongCardinal(call, (ilu_longcardinal *) &b2);
  v3.high = b2[0];
  v3.low = b2[1];
  if (b != NULL)
    {
      b->high = b2[0];
      b->low = b2[1];
    }
  return(v3);
}


ilu_LongInteger	ilu::InputLongInteger	(ilu_Call call, ilu_LongInteger *b)
{
  long int b2[2];
  ilu_LongInteger v3;

  ilu_InputLongInteger(call, (ilu_longinteger *) &b2);
  v3.high = b2[0];
  v3.low = (unsigned long int) b2[1];
  if (b != NULL)
    {
      b->high = b2[0];
      b->low = b2[1];
    }
  return(v3);
}


ilu_LongReal	ilu::InputLongReal	(ilu_Call call, ilu_LongReal *b)
{
  ilu_LongReal b2;

  ilu_InputLongReal(call, &b2);
  if (b != NULL)
    *b = b2;
  return(b2);
}


unsigned char *	ilu::InputBytes	(ilu_Call call, unsigned char * buf, ilu_Cardinal *len, ilu_Cardinal limit)
{
  unsigned char *b2 = buf;
  ilu_Cardinal len2;

  ilu_InputBytes(call, &b2, (len == NULL) ? &len2 : len, limit, ilu_FALSE);
  return(b2);
}


unsigned char *	ilu::InputOpaque	(ilu_Call call, unsigned char * buf, ilu_Cardinal len)
{
  unsigned char *buf2 = buf;

  ilu_InputOpaque(call, &buf2, len, ilu_FALSE);
  return(buf2);
}


ilu_CString	ilu::InputString	(ilu_Call call, ilu_CString buf, ilu_Cardinal *len, ilu_Cardinal limit)
{
  ilu_Cardinal extra, *p;
  ilu_CString buf2 = buf;

  if (len == NULL)
    p = &extra;
  else
    p = len;
  ilu_InputString(call, &buf2, p, limit, ilu_FALSE);
  return(buf2);
}


ilu_CString	ilu::InputStringVec	(ilu_Call call, ilu_CString buf, ilu_Cardinal len)
{
  ilu_CString buf2 = buf;

  ilu_InputStringVec(call, &buf2, len, ilu_FALSE);
  return(buf2);
}


ilu_WString	ilu::InputWString	(ilu_Call call, ilu_WString buf, ilu_Cardinal *len, ilu_Cardinal limit)
{
  ilu_Cardinal len2;
  ilu_WString buf2 = buf;

  ilu_InputWString(call, &buf2, (len == NULL) ? &len2 : len, limit, ilu_FALSE);
  return(buf2);
}


ilu_WString	ilu::InputWStringVec	(ilu_Call call, ilu_WString buf, ilu_Cardinal len)
{
  ilu_WString buf2 = buf;

  ilu_InputWStringVec(call, &buf2, len, ilu_FALSE);
  return(buf2);
}


ilu_KernelObject	ilu::InputObjectID	(ilu_Call call, ilu_Boolean discriminator_p, ilu_Class putative_class)
{
  ilu_KernelObject obj = NULL;

  ilu_InputObjectID(call, &obj, (ilu_boolean) discriminator_p, putative_class);
  /* now obj != NULL => Inside(obj->server, obj->class) */
  return obj;
}


ilu_Cardinal	ilu::InputSequence	(ilu_Call call, ilu_Cardinal *count, ilu_Cardinal limit)
{
  ilu_boolean provided;
  ilu_Cardinal c2;

  ilu_InputSequence(call, (count == NULL) ? &c2 : count, limit, ilu_FALSE, &provided);
  return((count == NULL) ? c2 : *count);
}


ilu_ShortCardinal	ilu::InputUnion	(ilu_Call call, ilu_ShortCardinal *discriminator)
{
  ilu_boolean provided;
  ilu_shortcardinal d2;

  ilu_InputUnion(call, (discriminator == NULL) ? &d2 : discriminator, ilu_FALSE, &provided);
  return((discriminator == NULL) ? d2 : *discriminator);
}


ilu_Boolean	ilu::InputRecord	(ilu_Call call)
{
  ilu_boolean provided;

  ilu_InputRecord(call, ilu_FALSE, &provided);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::InputArray	(ilu_Call call)
{
  ilu_boolean provided;
  ilu_InputArray(call, ilu_FALSE, &provided);
  return((ilu_Boolean) 1);
}


/*after: Inside(ks, c) */
void	ilu::EnterServer	(ilu_Server ks, ilu_Class c)
{
  ilu_EnterServer(ks, c);
}

/*before: Inside(obj->server, obj->class) */
void	ilu::ExitServer		(ilu_Server ks, ilu_Class c)
{
  ilu_ExitServer(ks, c);
}


void *		ilu::SBHToObject	(ilu_CString sbh, ilu_CString type_id, ilu_Class c)
{
  ilu_KernelObject obj;
  iluObject *o;
  void *result;

  obj = ilu_ObjectOfSBH(sbh, type_id ? type_id : c->cl_unique_id, c);
  if (obj == NULL)
    return NULL;

  /* now Inside(obj->server, obj->class) */
  if ((o = (class iluObject *) ilu_GetLanguageSpecificObject(obj)) == NULL)
    result = iluObject::CreateFromRegistry(ilu_ClassOfObject(obj), obj);
  else
    result = o->ILUMostSpecificObject();
  ilu_ExitServer(ilu_ServerOfObject(obj), c);
  return result;
}

ilu_CString	ilu::SBHOfObject	(ilu_KernelObject obj)
{
  ilu_Server	s	= ilu_ServerOfObject(obj);
  ilu_Class	c	= ilu_ClassOfObject(obj);
  ilu_CString	result;

  ilu_EnterServer(s, c);
  result = ilu_SBHOfObject(obj);
  ilu_ExitServer(s, c);
  return result;
}

ilu_Boolean	ilu::OutputByte	(ilu_Call call, unsigned char byte)
{
  ilu_OutputByte(call, byte);
  return((ilu_Boolean) 1);
}

ilu_Boolean	ilu::OutputBoolean (ilu_Call call, ilu_Boolean b)
{
  ilu_OutputBoolean(call, (ilu_boolean) b);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputOptional	(ilu_Call call, ilu_Boolean opt)
{
  ilu_OutputOptional(call, (ilu_boolean) opt);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputCardinal	(ilu_Call call, unsigned long val)
{
  ilu_OutputCardinal(call, val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputCharacter	(ilu_Call call, ilu_Character val)
{
  ilu_OutputCharacter(call, val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputEnum		(ilu_Call call, ilu_ShortCardinal val)
{
  ilu_OutputEnum(call, val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputInteger	(ilu_Call call, long val)
{
  ilu_OutputInteger(call, val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputReal	(ilu_Call call, double val)
{
  ilu_OutputReal(call, val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputShortCardinal	(ilu_Call call, unsigned short val)
{
  ilu_OutputShortCardinal(call, val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputShortInteger	(ilu_Call call, short val)
{
  ilu_OutputShortInteger(call, val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputShortReal	(ilu_Call call, float val)
{
  ilu_OutputShortReal(call, val);
  return((ilu_Boolean) 1);
}

ilu_Boolean	ilu::OutputLongCardinal	(ilu_Call call, ilu_LongCardinal val)
{
  ilu_OutputLongCardinal(call, (long unsigned int *) &val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputLongInteger	(ilu_Call call, ilu_LongInteger val)
{
  ilu_OutputLongInteger(call, (long int *) &val);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputLongReal	(ilu_Call call, ilu_LongReal val)
{
  ilu_OutputLongReal(call, val);
  return((ilu_Boolean) 1);
}

ilu_Boolean	ilu::OutputBytes	(ilu_Call call, unsigned char * bytes, ilu_Cardinal len, ilu_Cardinal limit)
{
  ilu_OutputBytes(call, bytes, len, limit, ilu_FALSE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputOpaque	(ilu_Call call, unsigned char * buf, ilu_Cardinal len)
{
  ilu_OutputOpaque(call, buf, len, ilu_FALSE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputString	(ilu_Call call, ilu_CString buf, ilu_Cardinal len, ilu_Cardinal limit)
{
  ilu_OutputString(call, buf, len, limit, ilu_FALSE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputStringVec	(ilu_Call call, ilu_CString buf, ilu_Cardinal len)
{
  ilu_OutputStringVec(call, buf, len, ilu_FALSE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputWString	(ilu_Call call, ilu_WString buf, ilu_Cardinal len, ilu_Cardinal limit, ilu_CString *buf2, ilu_Cardinal *buf2len)
{
  ilu_OutputWString(call, buf, len, limit, buf2, buf2len, ilu_FALSE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputWStringVec(ilu_Call call, ilu_WString buf, ilu_Cardinal len, ilu_CString *buf2, ilu_Cardinal *buf2len)
{
  ilu_OutputWStringVec(call, buf, len, buf2, buf2len, ilu_FALSE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputObjectID	(ilu_Call call, ilu_KernelObject obj, ilu_Boolean discriminator_p, ilu_Class putative_class)
{
  ilu_EnterServer(ilu_ServerOfObject(obj), ilu_ClassOfObject(obj));
  ilu_OutputObjectID(call, obj, (ilu_boolean) discriminator_p, putative_class);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputSequence	(ilu_Call call, ilu_Cardinal length, ilu_Cardinal limit)
{
  ilu_OutputSequence(call, length, limit, ilu_FALSE, ilu_TRUE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputUnion	(ilu_Call call, unsigned short discriminator)
{
  ilu_OutputUnion(call, discriminator, ilu_FALSE, ilu_TRUE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputArray	(ilu_Call call)
{
	/***** this 0 needs to change to the actual number of elements to output */

  ilu_OutputArray(call, 0, ilu_FALSE, ilu_TRUE);
  return((ilu_Boolean) 1);
}


ilu_Boolean	ilu::OutputRecord	(ilu_Call call)
{
  ilu_OutputRecord(call, ilu_FALSE, ilu_TRUE);
  return((ilu_Boolean) 1);
}


ilu_Cardinal	ilu::SizeOfByte	(ilu_Call call, unsigned char byte)
{
  return(ilu_SizeOfByte(call, byte));
}


ilu_Cardinal	ilu::SizeOfBoolean	(ilu_Call call, ilu_Boolean b)
{
  return(ilu_SizeOfBoolean(call, (ilu_boolean) b));
}


ilu_Cardinal	ilu::SizeOfOptional	(ilu_Call call, ilu_Boolean opt)
{
  return(ilu_SizeOfOptional(call, (ilu_boolean) opt));
}


ilu_Cardinal	ilu::SizeOfCardinal	(ilu_Call call, unsigned long val)
{
  return(ilu_SizeOfCardinal(call, val));
}


ilu_Cardinal	ilu::SizeOfCharacter	(ilu_Call call, ilu_Character val)
{
  return(ilu_SizeOfCharacter(call, val));
}


ilu_Cardinal	ilu::SizeOfEnum		(ilu_Call call, ilu_ShortCardinal val)
{
  return(ilu_SizeOfEnum(call, val));
}


ilu_Cardinal	ilu::SizeOfInteger	(ilu_Call call, long val)
{
  return(ilu_SizeOfInteger(call, val));
}


ilu_Cardinal	ilu::SizeOfReal	(ilu_Call call, double val)
{
  return(ilu_SizeOfReal(call, val));
}


ilu_Cardinal	ilu::SizeOfShortCardinal	(ilu_Call call, ilu_ShortCardinal val)
{
  return(ilu_SizeOfShortCardinal(call, val));
}


ilu_Cardinal	ilu::SizeOfShortInteger	(ilu_Call call, short val)
{
  return(ilu_SizeOfShortInteger(call, val));
}


ilu_Cardinal	ilu::SizeOfShortReal	(ilu_Call call, float val)
{
  return(ilu_SizeOfShortReal(call, val));
}


ilu_Cardinal	ilu::SizeOfLongCardinal	(ilu_Call call, ilu_LongCardinal val)
{
  return(ilu_SizeOfLongCardinal(call, (unsigned long int *) &val));
}


ilu_Cardinal	ilu::SizeOfLongInteger	(ilu_Call call, ilu_LongInteger val)
{
  return(ilu_SizeOfLongInteger(call, (long int *) &val));
}


ilu_Cardinal	ilu::SizeOfLongReal	(ilu_Call call, ilu_LongReal val)
{
  return(ilu_SizeOfLongReal(call, val));
}


ilu_Cardinal	ilu::SizeOfBytes	(ilu_Call call, unsigned char * buf, ilu_Cardinal len, ilu_Cardinal limit)
{
  return(ilu_SizeOfBytes(call, buf, len, limit, ilu_FALSE));
}


ilu_Cardinal	ilu::SizeOfOpaque	(ilu_Call call, unsigned char * buf, ilu_Cardinal len)
{
  return(ilu_SizeOfOpaque(call, buf, len, ilu_FALSE));
}


ilu_Cardinal	ilu::SizeOfString	(ilu_Call call, ilu_CString buf, ilu_Cardinal len, ilu_Cardinal limit)
{
  return(ilu_SizeOfString(call, buf, len, limit, ilu_FALSE));
}


ilu_Cardinal	ilu::SizeOfStringVec	(ilu_Call call, ilu_CString buf, ilu_Cardinal len)
{
  return(ilu_SizeOfStringVec(call, buf, len, ilu_FALSE));
}


ilu_Cardinal	ilu::SizeOfWString	(ilu_Call call, ilu_WString buf, ilu_Cardinal len, ilu_Cardinal limit, ilu_CString *buf2, ilu_Cardinal *buf2len)
{
  return(ilu_SizeOfWString(call, buf, len, limit, buf2, buf2len, ilu_FALSE));
}


ilu_Cardinal	ilu::SizeOfWStringVec	(ilu_Call call, ilu_WString buf, ilu_Cardinal len, ilu_CString *buf2, ilu_Cardinal *buf2len)
{
  return(ilu_SizeOfWStringVec(call, buf, len, buf2, buf2len, ilu_FALSE));
}


ilu_Cardinal	ilu::SizeOfObjectID	(ilu_Call call, ilu_KernelObject obj, ilu_Boolean discriminator_p, ilu_Class putative_class)
{
  ilu_Server		s	= ilu_ServerOfObject(obj);
  ilu_Class		c	= ilu_ClassOfObject(obj);
  ilu_Cardinal		size;

  ilu_EnterServer(s, c);
  size = ilu_SizeOfObjectID(call, obj, (ilu_boolean) discriminator_p, putative_class);
  ilu_ExitServer(s, c);
  return size;
}


ilu_Cardinal	ilu::SizeOfSequence	(ilu_Call call, ilu_Cardinal len, ilu_Cardinal limit)
{
  return(ilu_SizeOfSequence(call, len, limit, ilu_FALSE, ilu_TRUE));
}


ilu_Cardinal	ilu::SizeOfUnion	(ilu_Call call, ilu_ShortCardinal discriminator)
{
  return(ilu_SizeOfUnion(call, discriminator, ilu_FALSE, ilu_TRUE));
}

ilu_Cardinal	ilu::SizeOfArray	(ilu_Call call)
{
	/****** this 0 needs to change to the actual number of elements to output */

  return(ilu_SizeOfArray(call, 0, ilu_FALSE, ilu_TRUE));
}

ilu_Cardinal	ilu::SizeOfRecord	(ilu_Call call)
{
  return(ilu_SizeOfRecord(call, ilu_FALSE, ilu_TRUE));
}

ilu_ProtocolException ilu::WaitForReply (ilu_Call call,
					 ilu_Cardinal *successCode)
{
  return ilu_GetReply(call, successCode);
}

static class iluServer *DefaultServer = NULL;

void ilu::SetDefaultServer(class iluServer *s)
{
  DefaultServer = s;
}

class iluServer *ilu::GetDefaultServer()
{
  return DefaultServer;
}

ilu_Port ilu::CreatePort (ilu_Server server, char *protocolType, char *transportType)
{
  char *p, *t;

  if ((p = protocolType) == NULL)
    p = "sunrpc_";
  if ((t = transportType) == NULL)
    t = "tcp_localhost_0";
  return(ilu_CreatePort (server, p, t));
}

void ilu::SetServerDefaultPort(ilu_Server s, ilu_Port p)
{
  ilu_SetServerDefaultPort(s, p);
  return;
}

ilu_Boolean ilu::ParseSBH (ilu_CString sbh, ilu_CString *oid, ilu_CString *contactInfo)
{
  return(ilu_ParseStringBindingHandle (sbh, oid, contactInfo));
}

ilu_Boolean ilu::ParseOID (ilu_CString oid, ilu_CString *iid, ilu_CString *sid)
{
  return(ilu_ParseOID (oid, iid, sid));
}

ilu_ReceiveRequestStatus ilu::ReceiveRequest (ilu_Connection conn, ilu_Call *pcall, ilu_Class *pclass, ilu_Method *method, ilu_cardinal *serial_number)
{
  return (ilu_ReceiveRequest(conn, pcall, pclass, method, serial_number));
}

ilu_Connection	ilu::HandleNewConnection	(ilu_Port port)
{
  ilu_Connection c;
  ilu_boolean closed;

  c = ilu_HandleNewConnection(port, &closed);
  if (closed)
    return (NULL);
  else
    return (c);
}

int		ilu::FileDescriptorOfConnection	(ilu_Connection conn)
{
  return (ilu_FileDescriptorOfConnection(conn));
}

void		ilu::CloseConnection		(ilu_Connection conn)
{
  ilu_CloseConnection(conn);
}

int		ilu::FileDescriptorOfMooringOfPort	(ilu_Port p)
{
  int fd;
  ilu_boolean closed;

  fd = ilu_FileDescriptorOfMooringOfPort(p, &closed);
  if (closed)
    return (-1);
  else
    return (fd);
}

ilu_KernelObject	ilu::CreateTrueKernelObject	(char *oid, ilu_Server server, ilu_Class c, void * lspo)
{
  ilu_KernelObject result;

  ilu_EnterServer(server, c);
  result = ilu_FindOrCreateTrueObject (oid, server, c, lspo);
  ilu_ExitServer(server, c);
  return result;
}

ilu_Class	ilu::FindClassFromID	(char *id)
{
  return ((ilu_Class) ilu_FindClassFromID(id));
}

/* Inside(obj->server, obj->class) */
class iluObject *	ilu::GetLanguageSpecificObject	(ilu_KernelObject obj)
{
  return (class iluObject *) ilu_GetLanguageSpecificObject(obj);
}

/* Inside(obj->server, obj->class) */
void		ilu::SetLanguageSpecificObject	(ilu_KernelObject obj, class iluObject * lspo)
{
  ilu_RegisterLanguageSpecificObject(obj, lspo);
}

void ilu::RunMainLoop (int *stop)
{
  ilu_RunMainLoop(stop);
  return;
}

void ilu::ExitMainLoop (int *stop)
{
  ilu_ExitMainLoop (stop);
}

ilu_Boolean ilu::RegisterInputHandler (int fd,
					     void (*handlerProc)
						  (int fd, void *rock),
					     void *rock)
{
  return (ilu_RegisterInputSource (fd, handlerProc, rock));
}

ilu_Boolean ilu::UnregisterInputHandler (int fd)
{
  return (ilu_UnregisterInputSource (fd));
}

ilu_Boolean ilu::RegisterOutputHandler (int fd,
					     void (*handlerProc)
						  (int fd, void *rock),
					     void *rock)
{
  return (ilu_RegisterOutputSource (fd, handlerProc, rock));
}

ilu_Boolean ilu::UnregisterOutputHandler (int fd)
{
  return (ilu_UnregisterOutputSource (fd));
}

