/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: rwho2ServerNMS.cc,v 1.3 1993/09/23 22:27:48 janssen Exp $
*/

#include "rwho2.H"	/* needed for def of rwho2 classes and types */
#include "rwho2a.H"
#include <iluServer.H>
#include <stdio.h>	/* I/O defs (including popen and pclose) */
#include <string.h>	/* strdup() */
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <sys/errno.h>

extern "C" {
  extern void gethostname(char *, int);
  extern int select();
};

class superImpl : public rwho2_T_super {

 public:

  superImpl();			// constructor
  virtual ~superImpl();		// destructor

 // methods

  static class superImpl *Create (char *name);
  virtual ilu_CString ID (rwho2Status *_status);

 // data slots

 private:
   char *id;
};

superImpl::superImpl()
{
  this->id = NULL;
}

superImpl::~superImpl()
{
  if (this->id != NULL)
    free(this->id);
}

class superImpl *superImpl::Create (char *name)
{
  class superImpl *n = new superImpl;
  n->id = strdup(name);
  return (n);
}

ilu_CString superImpl::ID (rwho2Status *_status)
{
  _status->returnCode = rwho2Reply_Success;
  return (strdup(this->id));
}

class superuserImpl : public rwho2a_T_superuser {

 public:

  superuserImpl();			// constructor
  virtual ~superuserImpl();		// destructor

 // methods

  static class superuserImpl *Create (char *name, char *id);
  virtual rwho2_T_username Name (rwho2Status *_status);
  virtual ilu_CString ID (rwho2Status *_status);

 // data slots

 private:
   char *name;
   char *id;
};

superuserImpl::superuserImpl()
{
  this->name = NULL;
  this->id = NULL;
}

superuserImpl::~superuserImpl()
{
  if (this->name != NULL)
    free(this->name);
  if (this->id != NULL)
    free(this->id);
}

class superuserImpl *superuserImpl::Create (char *name, char *id)
{
  class superuserImpl *n = new superuserImpl;
  n->name = strdup(name);
  n->id = strdup(id);
  return (n);
}

rwho2_T_username superuserImpl::Name (rwho2Status *_status)
{
  _status->returnCode = rwho2Reply_Success;
  return (strdup(this->name));
}

ilu_CString superuserImpl::ID (rwho2Status *_status)
{
  _status->returnCode = rwho2Reply_Success;
  return (strdup(this->id));
}

class userImpl : public rwho2_T_user {

 public:

  userImpl();			// constructor
  virtual ~userImpl();		// destructor

 // methods

  static class userImpl *Create (char *name);
  virtual rwho2_T_username Name (rwho2Status *_status);

 // data slots

 private:
   char *name;
};

userImpl::userImpl()
{
  this->name = NULL;
}

userImpl::~userImpl()
{
  if (this->name != NULL)
    free(this->name);
}

class userImpl *userImpl::Create (char *name)
{
  class userImpl *n = new userImpl;
  n->name = strdup(name);
  return (n);
}

rwho2_T_username userImpl::Name (rwho2Status *_status)
{
  _status->returnCode = rwho2Reply_Success;
  return (strdup(this->name));
}


class user2Impl : public rwho2a_T_user2 {

 public:

  user2Impl();			// constructor
  virtual ~user2Impl();		// destructor

 // methods

  static class user2Impl *Create (char *name);
  virtual rwho2_T_username Name (rwho2Status *_status);

 // data slots

 private:
   char *name;
};

user2Impl::user2Impl()
{
  this->name = NULL;
}

user2Impl::~user2Impl()
{
  if (this->name != NULL)
    free(this->name);
}

class user2Impl *user2Impl::Create (char *name)
{
  class user2Impl *n = new user2Impl;
  n->name = strdup(name);
  return (n);
}

rwho2_T_username user2Impl::Name (rwho2Status *_status)
{
  _status->returnCode = rwho2Reply_Success;
  return (strdup(this->name));
}


/* First, subclass the public version of rwho2_T_machine, and
   provide real implementations of each of the methods. */

class rwho2Impl : public rwho2_T_machine {

 public:

  rwho2Impl();			// constructor
  virtual ~rwho2Impl();		// destructor

 // methods

  virtual ilu_CString Status (rwho2Status *_status);
  virtual ilu_Boolean IsUserPresent (rwho2Status *_status, rwho2_T_username username);
  virtual ilu_CString StartTime (rwho2Status *_status);
  virtual ilu_CString Name (rwho2Status *_status);
  virtual rwho2_T_userRec * ListUsers (rwho2Status *_status);
  virtual ilu_CString EchoString (rwho2Status *_status, ilu_CString s);
  virtual ilu_Cardinal EchoInt (rwho2Status *_status, ilu_Cardinal s);

 // data slots

 private:

   char *startTime;
};


static char *GetTimeAsString()
{
  long clock;
  char *buf;

  clock = time(NULL);
  buf = strdup(ctime(&clock));
  buf[strlen(buf) - 1] = '\0';
  return (buf);
}

rwho2Impl::rwho2Impl()
{
  this->startTime = GetTimeAsString();
}

rwho2Impl::~rwho2Impl()
{
  if (this->startTime != NULL)
    free(this->startTime);
}

ilu_CString rwho2Impl::Status (rwho2Status *_status)
{
  char buf[1000];
  FILE *f;

  f = popen ("uptime", "r");
  fgets(buf, sizeof(buf), f);
  pclose(f);
  buf[strlen(buf) - 1] = '\0';
  _status->returnCode = rwho2Reply_Success;
  return ((ilu_CString) strdup(buf));
}

rwho2_T_userRec * rwho2Impl::ListUsers (rwho2Status *_status)
{
  FILE *f;
  char buf[1000];
  int i;
  rwho2_T_userRec *users = (rwho2_T_userRec *) malloc (sizeof(rwho2_T_userRec));

  users->users = _rwho2_T_userSeq_sequence::Create(10, NULL);
  users->time = GetTimeAsString();
  f = popen ("who", "r");
  while (fgets (buf, sizeof(buf), f) != NULL && strlen(buf) > 1)
    {
      char *p;

      buf[strlen(buf) - 1] = '\0';
	printf ("********** buf is <%s>\n", buf);
      if ((p = strchr(buf, ' ')) != NULL 
	  && (*--p == 'u') && ((*--p) == 's'))
	users->users->Append ((class rwho2_T_user *) user2Impl::Create(buf));
      else
	users->users->Append((class rwho2_T_user *) userImpl::Create(buf));
    }
  pclose(f);
  _status->returnCode = rwho2Reply_Success;
  return (users);  
}

ilu_Boolean rwho2Impl::IsUserPresent (rwho2Status *_status, rwho2_T_username username)
{
  FILE *f;
  char buf[1000];
  int i;
  ilu_Boolean s;

  f = popen ("who", "r");
  i = strlen(username);
  s = ilu_FALSE;
  while (fgets (buf, sizeof(buf), f) != NULL && strlen(buf) > 1)
    if (strncmp(username, buf, i) == 0)
      s = ilu_TRUE;
  pclose(f);
  _status->returnCode = rwho2Reply_Success;
  return (s);
}

ilu_CString rwho2Impl::StartTime (rwho2Status *_status)
{
  _status->returnCode = rwho2Reply_Success;
  return (strdup(this->startTime));
}

ilu_CString rwho2Impl::Name (rwho2Status *_status)
{
  static char *Hostname = NULL;

  if (Hostname == NULL)
    {
      char buf[1000];
      gethostname(buf, sizeof(buf));
      Hostname = strdup(buf);
    }

  _status->returnCode = rwho2Reply_Success;
  return ((ilu_CString) strdup(Hostname));
}

ilu_CString rwho2Impl::EchoString (rwho2Status *_status, ilu_CString s)
{
  ilu_CString s2;

  _status->returnCode = rwho2Reply_Success;
  s2 = (ilu_CString) malloc(strlen(s) + 1);
  strcpy (s2, s);
  return (s2);
}

ilu_Cardinal rwho2Impl::EchoInt (rwho2Status *_status, ilu_Cardinal s)
{
  _status->returnCode = rwho2Reply_Success;
  return (s);
}


/***********************************************************************/
/***********************************************************************/
/***********************************************************************/
/***********************************************************************/

/*		And here's the main line			       */

/***********************************************************************/
/***********************************************************************/
/***********************************************************************/

#include <nms.H>
#include <ilunms.H>
#include "rwho2.H"	/* needed for def of rwho2 classes and types */
#include <iluServer.H>
#include <stdio.h>	/* I/O defs (including popen and pclose) */
#include <string.h>	/* strdup() */
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <sys/errno.h>

main (int ac, char **av)
{
  class iluServer *s;
  class rwho2Impl *i;
  char hostname[1000];
  nms_T_attrSeq attributes;

  /* first, make a server object */

  s = new iluServer((ac > 1) ? av[1] : NULL, NULL, ilu_FALSE);

  /* next, make it the default */

  ilu::SetDefaultServer(s);

  /* now, add a port */

  s->AddPort((ac > 2) ? av[2] : NULL, (ac > 3) ? av[3] : NULL, ilu_TRUE);

  /* create an instance of the rwho2Impl object */

  i = new rwho2Impl;

  /* better print out the SBH to pass as arg to rwho2Client... */

  /* register instance with the Name and Service Server */
  attributes = ilunms::MakeAttributeList();
  gethostname(hostname, sizeof(hostname));
  ilunms::AddTextAttribute (attributes, "Host", hostname);
  ilunms::RegisterWithAttributes (i, attributes);
  ilunms::FreeAttributeList (attributes);

  printf ("%s\n", i->ILUStringBindingHandle());

  /* and let things run... */

  iluServer::Run();

  /* should never return, but just in case: */

  return(1);
}

