(* BazM3Server.m3 *)
(* Last tweaked by Mike Spreitzer April 21, 1994 4:54 pm PDT *)

(* A server program that implements a couple of Baz.O objects. *)

MODULE BazM3Server EXPORTS Main;
IMPORT Foo, Bar, Baz, Fmt, Ilu, IluBasics, Stdio, Thread, Time, Wr;

<*FATAL Thread.Alerted, Wr.Failure*>

TYPE
  TrueO = Baz.O OBJECT
            id      : INTEGER;
            follower: TrueP;
          OVERRIDES
            ILU_Get_Server := ILU_Get_Server;
            U_CSS_to_U     := U_CSS_to_U;
            M1             := M1;
            ILU_Qua_Type   := Qua_From_O;
          END;

  TrueP = Bar.P OBJECT
            leader: TrueO;
            id    : INTEGER
          OVERRIDES
            ILU_Get_Server := ILU_Get_Server;
            P1             := P1;
            ILU_Qua_Type   := Qua_From_P;
          END;

VAR
  ts     :  Ilu.TrueServer;
  foType := Foo.ILU_Get_Type_O(NIL);
  foId   := Ilu.IdOfObjectType(foType);
  bpType := Bar.ILU_Get_Type_P(NIL);
  bpId   := Ilu.IdOfObjectType(bpType);
  boType := Baz.ILU_Get_Type_O(NIL);
  boId   := Ilu.IdOfObjectType(boType);

PROCEDURE Qua_From_O (self: TrueO; ot: Ilu.ObjectType): Ilu.Object =
  BEGIN
    IF ot = foType OR ot = boType THEN
      RETURN self
    ELSIF ot = bpType THEN
      RETURN self.follower
    ELSE
      RETURN NIL
    END;
  END Qua_From_O;

PROCEDURE Qua_From_P (self: TrueP; ot: Ilu.ObjectType): Ilu.Object =
  BEGIN
    RETURN self.leader.ILU_Qua_Type(ot)
  END Qua_From_P;

PROCEDURE ILU_Get_Server (<*UNUSED*> self: Ilu.Object): Ilu.Server =
  BEGIN
    RETURN ts;
  END ILU_Get_Server;

PROCEDURE U_CSS_to_U (self: TrueO; u: Foo.U; css: Foo.CSS): Foo.U
  RAISES {Foo.E1, Foo.E2} =
  VAR
    newP: TrueP;
    newO: TrueO;
  BEGIN
    CASE NUMBER(css^) OF
    | 0 => RETURN u;
    | 1 => RAISE Foo.E1(u);
    | 2 => RAISE Foo.E2(self.id);
    | 3 => RETURN NEW(Foo.U_CSS, v := css);
    | 4 => RETURN NEW(Foo.U_O, v := self);
    ELSE
      newO := NEW(TrueO, id := NUMBER(css^));
      newP := NEW(TrueP, id := newO.id, leader := newO);
      newO.follower := newP;
      RETURN NEW(Foo.U_OO, v := newO);
    END (*case*);
  END U_CSS_to_U;

PROCEDURE P1 (self: TrueP; i: INTEGER): INTEGER RAISES {} =
  BEGIN
    RETURN i + self.id;
  END P1;

PROCEDURE M1 (self: TrueO; i: INTEGER): Foo.U RAISES {Baz.E1, Foo.E1} =
  VAR css := NEW(Foo.CSS, 3);
  BEGIN
    css[0] := "from a Baz.O";
    css[1] := Fmt.Int(i);
    css[2] := Fmt.Int(i * self.id);
    RETURN NEW(Foo.U_CSS, v := css);
  END M1;

VAR os1 := NEW(TrueO, id := 10);
VAR os2 := NEW(TrueO, id := 20);
VAR ps1 := NEW(TrueP, id := 10, leader := os1);
VAR ps2 := NEW(TrueP, id := 20, leader := os2);
VAR sbh1, sbh2: TEXT;

BEGIN
  os1.follower := ps1;
  os2.follower := ps2;
  TRY
    ts := Ilu.InitTrueServer(NEW(Ilu.TrueServer));
    Ilu.Export_Server(ts, NEW(Ilu.SunRpc2), NEW(Ilu.TCP));

    Wr.PutText(Stdio.stdout, "Foo.O tid is " & foId & "\n");
    Wr.PutText(Stdio.stdout, "Bar.P tid is " & bpId & "\n");

    sbh2 := Ilu.SbhFromObject(os2);
    Wr.PutText(
      Stdio.stdout, "SBH2&mstid is '" & sbh2 & "' '" & boId & "'\n");
    Wr.Flush(Stdio.stdout);

    sbh1 := Ilu.SbhFromObject(os1);
    Wr.PutText(
      Stdio.stdout, "SBH1&mstid is '" & sbh1 & "' '" & boId & "'\n");
    Wr.Flush(Stdio.stdout);

    LOOP
      (* Linebreak, if you PLEASE! *)
      Time.LongPause(10);
    END (*loop*);
  EXCEPT
    IluBasics.Failed (e) =>
      Wr.PutText(
        Stdio.stderr,
        Fmt.F("IluBasics.Failed(%s)\n", IluBasics.FullInfo(e)));
      Wr.PutText(
        Stdio.stderr,
        "(This might be caused by not registering Foo, Bar, or Baz.isl.)\n");
  END (*try*);
END BazM3Server.
