/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
$Id: courier-register-interface.c,v 1.6 1993/09/21 03:01:31 janssen Exp $
*/

#include <stdio.h>

#include <sys/types.h>

#include <iluparsertypes.h>

extern char *interface_name(Interface);

extern Interface GetInterface(string, string);

#define AND  &&
#define OR   ||
#define NOT  !

#include "pnum.h"

boolean verbose;

void formRegistryName (char *buf)
{
  char *registryhome = (char *) getenv("ILUREGISTRY");
  char *iluhome = (char *) getenv ("ILUHOME");

  if (registryhome != NULL)
    sprintf (buf, "%s/%s", registryhome, PROGRAM_NUMBER_REGISTRY_NAME);
  else if (iluhome != NULL)
    sprintf (buf, "%s/lib/%s", iluhome, PROGRAM_NUMBER_REGISTRY_NAME);
  else
    sprintf (buf, "/project/rpc/misclib/%s", PROGRAM_NUMBER_REGISTRY_NAME);
}

FILE *OpenTempFile(void)
{
  FILE *f;
  char name[1000];

  strcpy (name, "/tmp/ILURXXXXXX");
  mktemp (name);
  if ((f = fopen (name, "w+")) != NULL)
    {
      unlink (name);	/* won't disappear till we close f */
      return (f);
    }
  else
    return (NULL);  
}

typedef struct context_s {
  Interface interface;
  FILE *database;
  cardinal lastused;
  boolean verbose;
  char *pname;
} * Context;

static void RegisterClass (Type class, Context context)
{
  if (type_basic_type(class) != object_Type OR class->marked)
    return;
  fprintf (context->database, "%s.%s:%s %x %u\n", 
	   interface_name(class->interface), type_name(class), class->uid,
	   context->lastused++, 1);
}

static boolean matchTypeName (Type class, char *name)
{
  char classid[1000];

  sprintf (classid, "%s.%s:%s",
	   interface_name(class->interface), type_name(class), class->uid);
  return (strcmp(classid, name) == 0);
}

static void clearMark (Type class)
{
  class->marked = FALSE;
}

static void mkInterface(Interface interface, char *pname)
{
    FILE 	*temp;
    FILE 	*d;
    Type 	c;
    unsigned long lastnum;
    boolean 	found;
    boolean 	lfound;
    boolean 	versionNotSpecified = FALSE;
    boolean 	programNumberNotSpecified = FALSE;
    long 	number;
    long 	version;
    long 	interfacenamelen;
    char 	rname[ 1000 ];
    char 	buf[ 1000 ];
    char 	name[ 1000 ];
    char  	*interfacename;
    struct context_s context;

    formRegistryName (rname);

    if ((d = fopen (rname, "r+")) == NULL)
    {
        fprintf (stderr, "%s:  Can't access program number registry file %s.\n",
	       pname, rname);
        exit(1);
    }

    context.interface = interface;
    context.lastused = 0;
    context.database = d;
    context.verbose = verbose;
    context.pname = pname;

    list_enumerate (interface->classes, clearMark, NULL);
    interfacename = interface_name(interface);
    interfacenamelen = strlen(interfacename);

    temp = OpenTempFile();

    fseek (d, 0L, 0);		/* go to beginning of file */

    while (fgets(buf, sizeof(buf), d) != NULL)
    {
        if (sscanf (buf, ".LastAssignedProgramNumber %x", &number) == 1)
  	    context.lastused = number;
        else if (sscanf (buf, "%s %x %u", name, &number, &version) == 3)
	{
	    if (strncmp(interfacename, name, interfacenamelen) == 0 && name[interfacenamelen] == '.')
	    {
	        if ((c = (Type) list_find(interface->classes, matchTypeName, name)) != NULL)
		{
	  	    c->marked = TRUE;		/* remember that we saw it */
		    fputs (buf, temp);
		}
	        else
		;	/* remove non-existent clases */
	    }
	    else
	        fputs (buf, temp);
	}
        else
	    fprintf (stderr, "Bad line in registry:  %s", buf);
    }
    fseek (temp, 0, 0);

    /*
    ** we're going to nuke the file then
    ** recreate it. this is a critical
    ** section. if someone else is trying
    ** to do the same thing at the same 
    ** time, this file could wind up in
    ** a giant mess - maybe we could try
    ** a more exotic technique like
    ** exclusive open
    */

    fclose( d );
    unlink( rname );
    if (( d = fopen( rname, "w" )) == NULL ) {
        fprintf(
  	    stderr, 
	    "%s:  Can't access program number registry file %s.\n",
            pname, 
	    rname);
        exit( 1 );
    }
    context.database = d;
    while( fgets( buf, sizeof( buf ), temp ) != NULL )
        fputs( buf, d );
    fclose( temp );
    list_enumerate( interface->classes, RegisterClass, &context );
    fprintf( d, ".LastAssignedProgramNumber %x\n", context.lastused );
    fclose( d );
    chmod( rname, ( unsigned short ) 0666 );
}

main(int ac, char **av)
{
    struct context_s context;
    FILE 	*d;
    FILE 	*temp;
    Type 	c;
    char 	*pname;
    list	s;

    pname = av[0];
    av++;
    ac--;
    verbose = FALSE;
    if ( ac > 0 && strcmp( av[ 0 ], "-verbose" ) == 0 ) {
	av++;  
	ac--;
	verbose = TRUE;
    }
    if ( ac < 1 ) {
        fprintf (stderr, "Usage:  %s INTERFACE-FILE-NAME\n", pname);
        exit( 1 );
    }
    if (( s = ParseFile( av[ 0 ])) == NULL ) {
        fprintf(
	    stderr, 
	    "%s:  Can't find interface or ISL file called \"%s\".\n", 
	    pname, 
	    av[ 0 ]);
        exit( 1 );
    }
    list_enumerate( s, mkInterface, av[ 0 ]);
    return 0;
}
