;;; ****************************************************************
;;; defenumeration and switch **************************************
;;; ****************************************************************

;;; This file is based on code posted by Joshua M. Yelon
;;; <jy10033@ehsn11.cen.uiuc.edu> based on a discussion of vectorizing
;;; case statements by Scott McKay <SWM@stony-brook.scrc.symbolics.com>
;;; and Bill York <york@oakland-hills.lucid.com>.  The basic idea is
;;; simple -- in C, enums allow a compiler to optimize a switch statement
;;; by using the enums as array indices. One can achieve the same effect
;;; in Lisp case statements, if the keys are consecutive numbers. To avoid
;;; losing readability, one must use constants with #. to evaluate them at
;;; execution time.


(defmacro defenumeration (&rest items)
  `(eval-when (compile load eval)
     ,@(loop for item in items
	     for count from 0
	     collect
	     `(defconstant ,item ,count))))

(defmacro switch (candidate &rest clauses)
  `(case ,candidate
     ,@(loop for clause in clauses
	     for enumerate = (car clause)
	     do
	  (unless (boundp enumerate)
	    (warn "No value for enumeration item ~S" enumerate))
	     collect
	     `(,(symbol-value (first clause)) . ,(rest clause)))))

#|
;;; User code
(defenumeration apple orange grape)

(defun fruit-color (fruit)
  (switch fruit
    (apple 'red)
    (grape 'purple)
    (orange 'orange)))
|#

;;; *EOF*
