;;; -*- Mode:LISP; Package:Language-Tools; Syntax:Common-Lisp -*-
;;;>>SHARED-MESSAGE
;;;>
;;;>******************************************************************************************
;;;>    This may only be used as permitted under the license agreement under
;;;>    which it has been distributed, and in no other way.
;;;>******************************************************************************************
;;;>
;;;>
;;; Written May 1982 by David A. Moon for use by the Common Lisp community
;;; Revised April 1983

;;; Tools for source code analysis: special form templates

;;;--- Missing Common-Lisp things:
;;; FLET, LABELS, MACROLET  (require local-macro environment in MAPFORMS!)
;;; LOCALLY (requires new declare stuff)
;;; THE has a template but isn't done right

;;; The things with ZL: package prefixes might be generated by macros
;;; or something, so keep them in for now.

;;; Temporary until the templates are in the source code of the special forms
;;; Also the templates needed by Maclisp will go here

(DEFUN STORE-TEMPLATE (FUNCTION TEMPLATE)
  (PUSH (CONS FUNCTION TEMPLATE) *ARG-TEMPLATE-ALIST*))

(STORE-TEMPLATE 'AND '(COND (REPEAT TEST) RETURN))	;sort of
(STORE-TEMPLATE 'BLOCK '(BLOCK . BODY))
(STORE-TEMPLATE 'BREAK '(QUOTE TEST))

;ARBITRARY here is to prevent moving complex code in or out of the scope of the catch
(STORE-TEMPLATE 'CATCH '(EVAL ARBITRARY . BODY))
(STORE-TEMPLATE 'ZL:*CATCH '(EVAL ARBITRARY . BODY))
(STORE-TEMPLATE 'ZL:COMMENT 'QUOTE)
(STORE-TEMPLATE 'COND '(COND (REPEAT (TEST . BODY))))

;These templates are not actually used, except by the :SPECIAL-FORM option
(STORE-TEMPLATE 'DO '(LOOP))
(STORE-TEMPLATE 'DO* '(LOOP))
(STORE-TEMPLATE 'ZL:DO-NAMED '(LOOP))
(STORE-TEMPLATE 'ZL:DO*-NAMED '(LOOP))

(STORE-TEMPLATE 'FUNCTION '(CALL))
(STORE-TEMPLATE 'GO '(GO))
(STORE-TEMPLATE 'IF '(COND TEST RETURN . BODY))
(STORE-TEMPLATE 'LET '(PARALLEL-LET DECLARE . BODY))
(STORE-TEMPLATE 'LET* '(((REPEAT LET)) DECLARE . BODY))
(STORE-TEMPLATE 'LET-IF '(TEST PARALLEL-LET DECLARE . BODY))  ;yes, not COND!
(STORE-TEMPLATE 'LET-VALUE '((ORDER (2 LET) (1 RETURN) (3 EFFECT))))
(STORE-TEMPLATE 'ZL:MULTIPLE-VALUE '(((REPEAT (IF NULL QUOTE SET))) EVAL))
(STORE-TEMPLATE 'MULTIPLE-VALUE-BIND '(((REPEAT (IF NULL QUOTE LET))) EVAL
				       DECLARE . BODY))

;ARBITRARY here is to try to prevent interchange of 1-value variables and n-value forms
(STORE-TEMPLATE 'MULTIPLE-VALUE-CALL '(ARBITRARY (REPEAT EVAL)))
(STORE-TEMPLATE 'SYS:%MULTIPLE-VALUE-CALL-N '(CALL (REPEAT EVAL QUOTE)))
(STORE-TEMPLATE 'MULTIPLE-VALUE-LIST '(EVAL))
(STORE-TEMPLATE 'MULTIPLE-VALUE-PROG1 '(RETURN (REPEAT EFFECT)))
(STORE-TEMPLATE 'OR '(COND (REPEAT RETURN)))  ;sort of
(STORE-TEMPLATE 'PROG '(LOOP . (IF (OR (NULL (CAR EXPR)) (LISTP (CAR EXPR)))
				   (ANONYMOUS-BLOCK PARALLEL-LET DECLARE . PROG)
				   (BLOCK PARALLEL-LET DECLARE . PROG))))
(STORE-TEMPLATE 'PROG* '(LOOP . (IF (OR (NULL (CAR EXPR)) (LISTP (CAR EXPR)))
				    (ANONYMOUS-BLOCK ((REPEAT LET)) DECLARE . PROG)
				    (BLOCK ((REPEAT LET)) DECLARE . PROG))))
(STORE-TEMPLATE 'PROG1 '(RETURN (REPEAT EFFECT)))
(STORE-TEMPLATE 'PROG2 '(EFFECT RETURN (REPEAT EFFECT)))
(STORE-TEMPLATE 'PROGN 'BODY)

;ARBITRARY in next two is to allow for the special-variable bindings that occur
(STORE-TEMPLATE 'PROGV '(EVAL EVAL ARBITRARY . BODY))
(STORE-TEMPLATE 'PROGW '(EVAL ARBITRARY . BODY))
(STORE-TEMPLATE 'QUOTE '(QUOTE))

;These aren't actually used, it's really done procedurally, but they need
;to be here so we know these are special forms, not functions.
;Note that the ZL RETURN takes n arguments, even though the CL RETURN takes only 2
(STORE-TEMPLATE 'RETURN 'BODY)
(STORE-TEMPLATE 'RETURN-FROM '(RETURN-FROM . BODY))
(STORE-TEMPLATE 'COMPILER:RETURN-FROM-T 'BODY)

;This isn't actually used, because it was too hard to make ORDER inside REPEAT work!
;---last is returned.  But also eval....
(STORE-TEMPLATE 'SETQ '((REPEAT (ORDER (2 SET) (1 EVAL)))))

;Maclisp brain damage...
(STORE-TEMPLATE 'ZL:SIGNP '(QUOTE EVAL))
(STORE-TEMPLATE 'ZL:SSTATUS '(ARBITRARY . QUOTE))	;No evaled subforms in Lisp machine!
(STORE-TEMPLATE 'ZL:STATUS 'QUOTE)			;No evaled subforms in Lisp machine!
#-3600
(STORE-TEMPLATE 'ZL:STORE '((ORDER (2 EVAL) (1 EVAL) (3 ARBITRARY))))
(STORE-TEMPLATE 'TAGBODY '(LOOP . PROG))
(STORE-TEMPLATE 'THE '(QUOTE RETURN))		;just ignore the type dcl
(STORE-TEMPLATE 'THROW '(EVAL (REPEAT EFFECT) EVAL ARBITRARY))
(STORE-TEMPLATE 'UNWIND-PROTECT '(RETURN (REPEAT EFFECT)))
(STORE-TEMPLATE 'VALUES '((REPEAT RETURN)))
(STORE-TEMPLATE 'VARIABLE-BOUNDP '(SYMEVAL))

;This would count as a SET because the variable could potentially be set indirectly
;through the locative produced, however we already assume that arbitrary side-effects
;always affect local variables.  So count it as a SYMEVAL: that we don't assume
;a side-effect just from computing the location; the side-effect is deferred
;until somebody actually does something unpredictable with that location.  This matters!
(STORE-TEMPLATE 'VARIABLE-LOCATION '(SYMEVAL))
(STORE-TEMPLATE 'DBG:VARIABLE-LOCATION-MAYBE '(SYMEVAL)) ;commented as a kludge
(STORE-TEMPLATE 'VARIABLE-MAKUNBOUND '(SET))
(STORE-TEMPLATE 'WITH-STACK-LIST '(((ORDER (2 LET) (1 (REPEAT EVAL)))) . BODY))
(STORE-TEMPLATE 'WITH-STACK-LIST* '(((ORDER (2 LET) (1 (REPEAT EVAL)))) . BODY))

;Special forms that can appear at top level
;Put templates on these in case we want to grovel through whole files
(STORE-TEMPLATE 'COMPILER:ADD-OPTIMIZER 'QUOTE)
(STORE-TEMPLATE 'DECLARE 'QUOTE)
(STORE-TEMPLATE 'SI:DEFCONST-1 '(SET EVAL QUOTE))
(STORE-TEMPLATE 'SI:DEFVAR-1 '(SET EVAL QUOTE))
(STORE-TEMPLATE 'DEF '(QUOTE (REPEAT EFFECT) EVAL))
(STORE-TEMPLATE 'DEFF '(QUOTE EVAL))
(STORE-TEMPLATE 'DEFPROP '(QUOTE QUOTE QUOTE))
;DEFUN is procedural
(STORE-TEMPLATE 'EVAL-WHEN '(QUOTE (REPEAT RETURN)))
(STORE-TEMPLATE 'ZL:EVAL-WHEN '(QUOTE (REPEAT RETURN)))
;MACRO is procedural
(STORE-TEMPLATE 'SI:SETQ-IF-UNBOUND '(SET EVAL))
(STORE-TEMPLATE 'SPECIAL 'QUOTE)
(STORE-TEMPLATE 'UNSPECIAL 'QUOTE)

;---- Zetalisp...
;;Not needed I guess: (each line for a different reason)
;*EXPR *FEXPR *LEXPR CC:ARRAY* CC:CLOSED CC:EXPR-HASH CC:GENPREFIX CC:NOTYPE CC:QUOTED-ARGS
;FIXNUM INCLUDE
;COMPILER:DEFMIC GRINDEF LOGIN-SETQ PACKAGE-DECLARE TRACE UNTRACE
; SET-COMTAB-RETURN-UNDO
;ARRAY FUNCTIONAL-ALIST LEXICAL-CLOSURE MULTIPLE-VALUE-RETURN
;--- won't need for these once templates are really on the debug-info!
;SI:ADVISE-LET SI:ADVISE-MULTIPLE-VALUE-LIST SI:ADVISE-PROG SI:ADVISE-PROGN SI:ADVISE-SETQ
; SI:ENCAPSULATION-LET
; SI:PKG-ADVERTISE-SYMBOLS SI:PKG-BORROW-SYMBOLS SI:PKG-EXTERN-SYMBOLS
; SI:PKG-FORWARD-ALIAS SI:PKG-FORWARD-SYMBOLS SI:PKG-INDIRECT-ALIAS SI:PKG-INDIRECT-SYMBOLS
; SI:PKG-INTERN-SYMBOLS SI:PKG-KEYWORD-SYMBOLS SI:PKG-MYREFNAME-DECL SI:PKG-REF-DECL
; SI:PKG-SHADOW-SYMBOLS SI:PKG-USE-PACKAGE
;SYS:FIXUP-METHOD-FROM-FASD
