/*
 * Parameter definition for a typical robot
 */

#define ATV_MAX 2000.0   	/* Max translational velocity, mm/sec */
#define ARV_MAX 1.0		/* Max rotational velocity, rads/sec */
#define ATA_MAX 500.0		/* Max trans accel, mm/sec/sec */
#define ARA_MAX 3.0		/* Max rot accel, rads/sec/sec (is this too high?) */

#define ERRATIC_RAD 290.0	/* Radius of robot, in mm */

/* Cycle times */

#define MIN_CYCLE_TIME 100	/* in ms, real time per cycle */
#define SIM_CYCLE_TIME 100	/* in ms, simulation time per cycle */

extern float inc_time;		/* time constant for simulation, in seconds */
extern int last_move;		/* time accumulation since last move command issued */

extern float dist_conv_factor;	/* convert robot units to mm */
extern float angle_conv_factor;	/* convert robot angular units to rad */
extern float vel_conv_factor;	/* convert robot vel units to mm/sec */
