/*
 * Global defs for most display and interpretation routines
 *
 */

#include <stdio.h>
#include <math.h>

extern int w_width, w_height, w_offset_x, w_offset_y;
extern int c_width, c_height;
extern int wxoff, wyoff;
extern double w_scale;

#define scalex(x) (w_offset_x + (w_scale * (x))) 
#define scaley(y) (w_offset_y + (w_scale * (y))) 
#define dscale(x) (w_scale * (x)) 
#define xscale(x,y) scalex(- y)
#define yscale(x,y) scaley(- x)
#define dxscale(x,y) dscale(- y)
#define dyscale(x,y) dscale(- x)

static double rad_to_deg = (180.0 / M_PI); /* convert radians to degrees */
static double deg_to_rad = (M_PI / 180.0); /* convert degrees to radians */

#define min(x,y) (((x) < (y)) ? (x) : (y))
#define max(x,y) (((x) > (y)) ? (x) : (y))
#define sround(x) (nint(x))	/* single-precision? arg round to int */

/* Translation to screen coords.  Real +x on flakey translates to "up" on the
 *   screen, and real +y is to Flakey's left, i.e, "left" on the screen.  
 *   So we have: +x -> scaled -y,  +y -> scaled -x.
 */


struct rotm			/* this is a 2x3 rotation/translation matrix */
{				/* specialized, usually a21 = -a12, a22 = a11 */
  double a11;
  double a12;
  double a13;
  double a21;
  double a22;
  double a23;
  double a31;
  double a32;
  double a33;
};

extern struct rotm screen_matrix; /* scales to screen coords from rw */


#define flakey_width 580	/* in mm */

#define BUF_NULL 256
#define SLBUF_NULL 255		/* structured light null entry */
#define RW_NULL -10000.0	/* RW coord null */

#define N_BRK -1		/* not much info about surround */
#define A_BRK -2		/* most significant: depth disparity, long segments */
#define B_BRK -3		/* short break, no depth disparity */
#define C_BRK -4		/* short segments, depth disparity */
#define CBUF_NULL -10		/* no entry */




