/*
 *  Window setup functions for Motif version
 *
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <stdarg.h>

#include "X11/Xlib.h"
#include "X11/Xutil.h"
#include "X11/Xos.h"
#include "X11/Intrinsic.h"
#include "X11/IntrinsicP.h"
#include "X11/CoreP.h"
#include "X11/Shell.h"
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/BulletinB.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>

#include "structures.h"
#include "constants.h"
#include "parameters.h"


/* Create the main application window */

XtAppContext app_context;
Widget toplevel;		/* toplevel shell widget */
Widget main_window;		/* main window widget */
Widget menu_bar;
Widget frame;			/* main drawing window */
Widget file_box, param_box;	/* file selection widgets */
Widget disconnect_button;	/* disconnection button */
Widget message1, message2, message3;	/* message label widgets */
extern Display *display;

void WorldCB();
void ExitCB();
void DisconnectCB();
void ColorCB();
void WakeCB();
void GrowCB();
void ParamsCB();
void process_events();
void expose_proc();
void mouse_proc();
void file_proc();
void param_proc();
void cancel_proc();

void window_refresh();
void jump_robot();
void scroll_to_screen_position();

float plus = 0.9, minus = 1.1;

extern Window info_win;

Window
create_app(width,height,argc,argv)
     int width, height;
     int argc;
     char **argv;
{ 
  Arg args[10];
  int n;
  Widget button, menu_pane, cascade, message_box;
  
  /* create toplevel app */
  toplevel =			
    XtAppInitialize(&app_context,"Erratic", NULL, 0, &argc, argv, NULL, NULL, 0);

  display = XtDisplay(toplevel);

  /* Main window  */
  n = 0;
/*  XtSetArg(args[n], XmNmainWindowMarginWidth, 0); n++;
  XtSetArg(args[n], XmNmainWindowMarginHeight, 0); n++; */
  main_window = XmCreateMainWindow(toplevel,"Erratic",args,n); 
  XtManageChild(main_window);

  /* Create message/info window */
  n = 0;
  message_box = XmCreateForm(main_window, "form", args, n);
  XtManageChild(message_box);

  n = 0;
  XtSetArg(args[n], XmNlabelString, 
	   XmStringCreateLtoR(" x:\n y:\nth: ",XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 4); n++;
  message1 = XmCreateLabelGadget(message_box,"label",args,n);
  XtManageChild(message1);

  n = 0;
  XtSetArg(args[n], XmNlabelString, 
	   XmStringCreateLtoR(" ",XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 140); n++;
  message1 = XmCreateLabelGadget(message_box,"label",args,n);
  XtManageChild(message1);

  n = 0;
  XtSetArg(args[n], XmNlabelString, 
	   XmStringCreateLtoR("World: NONE",XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget,message1); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 140); n++;
  message2 = XmCreateLabelGadget(message_box,"label",args,n);
  XtManageChild(message2);

  n = 0;
  XtSetArg(args[n], XmNlabelString, 
	   XmStringCreateLtoR(" ",XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget,message2); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 140); n++;
  message3 = XmCreateLabelGadget(message_box,"label",args,n);
  XtManageChild(message3);


  /* Create menu bar in main window */
  n = 0;
  menu_bar = XmCreateMenuBar(main_window, "menu_bar", args, n);
  XtManageChild(menu_bar);

  /* Create WORLD push button in main window */
  n = 0;
  button = XmCreateCascadeButton(menu_bar, "World", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, WorldCB, NULL);

  n = 0;
  XtSetArg(args[n], XmNmenuHelpWidget, button); n++;
  XtSetValues(menu_bar, args, n);

  /* This is the file selection widget */
  n = 0;
  file_box = XmCreateFileSelectionDialog(button, "World", args, n);
  XtAddCallback(file_box, XmNcancelCallback, cancel_proc, NULL);
  XtAddCallback(file_box, XmNokCallback, file_proc, NULL);


  /* Create QUIT menu in main window */
  n = 0;
  menu_pane = XmCreatePulldownMenu(menu_bar, "menu_pane", args, n);

  n = 0;
  button = XmCreatePushButtonGadget(menu_pane, "Exit", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, ExitCB, NULL);

  n = 0;
  button = XmCreatePushButtonGadget(menu_pane, "Disconnect", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, DisconnectCB, NULL);
  XtSetSensitive(button, False);
  disconnect_button = button;

  n = 0;
  XtSetArg(args[n], XmNsubMenuId, menu_pane); n++;
  cascade = XmCreateCascadeButtonGadget(menu_bar, "Quit", args, n);
  XtManageChild(cascade);


  /* Create PARAMS push button in main window */
  n = 0;
  button = XmCreateCascadeButton(menu_bar, "Params", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, ParamsCB, NULL);

  /* This is the file selection widget */
  n = 0;
  param_box = XmCreateFileSelectionDialog(button, "Params", args, n);
  XtAddCallback(param_box, XmNcancelCallback, cancel_proc, NULL);
  XtAddCallback(param_box, XmNokCallback, param_proc, NULL);


  /* Create ENLARGE push button in main window */
  n = 0;
  button = XmCreateCascadeButtonGadget(menu_bar, "Grow", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, GrowCB, &plus);

  /* Create SHRINK push button in main window */
  n = 0;
  button = XmCreateCascadeButtonGadget(menu_bar, "Shrink", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, GrowCB, &minus);


  /* Create Change Color push button in main window */
  n = 0;
  button = XmCreateCascadeButtonGadget(menu_bar, "Color", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, ColorCB, NULL);

  /* Create Wake push button in main window */
  n = 0;
  button = XmCreateCascadeButtonGadget(menu_bar, "Wake", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, WakeCB, NULL);

  /* Create frame for graphics display */
  n = 0;
  frame = XmCreateDrawingArea(main_window, "drawing", args, n);
  XtManageChild(frame);

  XtAddCallback(frame, XmNexposeCallback, expose_proc, NULL);
  XtAddCallback(frame, XmNinputCallback,  mouse_proc,  NULL);


  /* Set main window areas and size */
  XmMainWindowSetAreas(main_window, menu_bar, NULL, NULL, NULL, frame);

  n = 0;
  XtSetArg(args[n], XmNmessageWindow, message_box); n++;
  XtSetArg(args[n], XmNshowSeparator, True); n++;
  XtSetValues(main_window, args, n);

  n = 0;
  XtSetArg(args[n], XmNheight, height); n++;
  XtSetArg(args[n], XmNwidth, width); n++;
  XtSetValues(toplevel, args, n);


  XtRealizeWidget(toplevel);

  process_events();

  info_win = XtWindow(message_box);
  return(XtWindow(frame));
}


/*
 * create action area for custom dialogs
 */
typedef struct {
  char *label;
  void (*callback)();
  caddr_t data;
} ActionAreaItem;

#define TIGHTNESS 20
Widget
CreateActionArea(parent, actions, num_actions)
     Widget parent;
     ActionAreaItem *actions;
     int num_actions;
{
  Widget action_area, widget;
  int i;
  
  action_area = XtVaCreateManagedWidget("action_area", xmFormWidgetClass, parent,
		   XmNfractionBase, TIGHTNESS*num_actions-1, 
                   NULL);

  for(i=0; i<num_actions; i++) {
    widget = XtVaCreateManagedWidget(actions[i].label,
       xmPushButtonWidgetClass, action_area,
       XmNtopAttachment,    XmATTACH_FORM,
       XmNbottomAttachment, XmATTACH_FORM,
       XmNleftPosition,         TIGHTNESS*i,
       XmNleftAttachment,       i? XmATTACH_POSITION : XmATTACH_FORM,
       XmNrightAttachment,
          i != num_actions - 1? XmATTACH_POSITION : XmATTACH_FORM,
       XmNrightPosition,        TIGHTNESS*i + (TIGHTNESS-1),
       XmNshowAsDefault,        0,
       XmNhighlightThickness,   0,
       XmNdefaultButtonShadowThickness, 0,
       NULL);
    if (actions[i].callback)
      XtAddCallback(widget, XmNactivateCallback,
		    actions[i].callback, actions[i].data);
    if (i == 0) {
      Dimension height, h;
      XtVaGetValues(action_area, XmNmarginHeight, &h, NULL);
      XtVaGetValues(widget, XmNheight, &height, NULL);
      height += 2*h;
      XtVaSetValues(action_area,
	   XmNpaneMaximum,   height,
	   XmNpaneMinimum,   height,
	   NULL);
    }
  }
  XtManageChild(action_area);
  return action_area;
}


/* 
 * Process pending Xt events
 * 
 */

void
process_events()
{
  XEvent event;
  while (XtAppPending(app_context)) /* any events? */
    {
      XtAppNextEvent(app_context,&event);
      XtDispatchEvent(&event);
    }
}


extern int win_w, win_h;

void
expose_proc(w, cd, s)		/* exposure happened */
     Widget w;
     caddr_t cd;
     XmDrawingAreaCallbackStruct *s;
{
  Window win;
  XWindowAttributes wattr;
  int width, height, bw, depth, x, y;
  win = s->window;
  XGetWindowAttributes(display, win, &wattr);
  win_h = wattr.height;
  win_w = wattr.width;
  window_refresh();
}


/*
 * Mouse buttons: left is position robot, middle is force recenter, 
 *   right is add/delete object
 */
void
mouse_proc(w, cd, s)		/* exposure happened */
     Widget w;
     caddr_t cd;
     XmDrawingAreaCallbackStruct *s;
{
  XEvent *event;
  int x, y, b;
  event = s->event;
  if (event->type == ButtonPress) /* pressed that button... */
    {
      x = event->xbutton.x;
      y = event->xbutton.y;
      b = event->xbutton.button;
      switch(b)
	{
	case 1:			/* left button, move robot */
	  jump_robot(RWX(x),RWY(y),erratic.th);
	  window_refresh();
	  break;
	case 2:			/* middle button, scroll */
	  scroll_to_screen_position(x,y);
	  break;
	}
    }
}


/*
 * WorldCB -- callback for WORLD button
 *
 */
void WorldCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XtManageChild (file_box);
}


void
cancel_proc(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XtUnmanageChild(w);
}

void
file_proc(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XmString file;
  XmStringContext context;
  XmStringCharSet charset;
  XmStringDirection direction;
  Boolean separator;
  Arg args[1];
  char *text;
  XtSetArg(args[0], XmNtextString, &file);
  XtGetValues(w, args, 1);
  XmStringGetLtoR(file, XmSTRING_DEFAULT_CHARSET, &text);
  load_file(text);
  XtFree(text);
  XtUnmanageChild(w);
/*  XtDestroyWidget(w); */
}

/*
 * ParamsCB -- callback for PARAMS button
 *
 */
void ParamsCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XtManageChild (param_box);
}

/*
 * Load a parameter file
 */
void
param_proc(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XmString file;
  XmStringContext context;
  XmStringCharSet charset;
  XmStringDirection direction;
  Boolean separator;
  Arg args[1];
  char *text;
  XtSetArg(args[0], XmNtextString, &file);
  XtGetValues(w, args, 1);
  XmStringGetLtoR(file, XmSTRING_DEFAULT_CHARSET, &text);
  load_param_file(text);
  XtFree(text);
  XtUnmanageChild(w);
/*  XtDestroyWidget(w); */
}


void shutdown_erratic_server();
/*
 * ExitCB -- callback for EXIT button
 *
 */
void ExitCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  printf("\n Exiting.");
  shutdown_erratic_server();
  exit(0);
}


extern int nohalt;
/*
 * DisconnectCB  -- callback for client disconnect
 *
 */
void DisconnectCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  nohalt = 0;
}

void
disconnect_state(which)		/* sets it sensitive/insensitive */
{
  XtSetSensitive(disconnect_button, which);
}


/*
 * Callback for Change Color button
 *
 */
void ColorCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  change_window_color();
  window_refresh();
}

extern float pix_to_mm;
/*
 * Callback for Grow/Shrink buttons
 *
 */
void GrowCB(w, dir, call_data)
     Widget w;
     float *dir;
     caddr_t call_data;
{
  pix_to_mm = pix_to_mm * *dir;
  window_scale(pix_to_mm);
  window_refresh();
}

extern int draw_wake;
/*
 * Callback for Wake button
 *
 */
void WakeCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data;
     caddr_t call_data;
{
  draw_wake = 1 - draw_wake;
}


void
world_message(char *str)	/* world file name */
{
  ChangeWidgetLabel(message2,str);
}


void
connect_message(char *str)	/* info about connection */
{
  ChangeWidgetLabel(message1,str);
}

void
message(char *str)		/* info in general */
{
  ChangeWidgetLabel(message3,str);
}

char buf[50];
void
smessage(char *str, ...)
{
  va_list ptr;
  va_start(ptr,str);
  vsprintf(buf,str,ptr);
  message(buf);
  va_end(ptr);
}

int
ChangeWidgetLabel(w, label)
Widget	w;
char	*label;
{
  XmString	xmstr;

	/*
	 * Convert the char * to a XmString
	 */
	xmstr = XmStringCreateLtoR(label, XmSTRING_DEFAULT_CHARSET);

	/*
	 * Exit if couldn't make into a XmString
	 */
	if ( xmstr == NULL )
		return -1;

	/*
	 * We need to unmanage the widget so it resizes correctly
	 */
        XtUnmanageChild(w);

	/*
	 * Now change the label 
	 */
        XtVaSetValues(w, XmNlabelString, xmstr, NULL);

	/*
	 * Re-manage the widget
	 */
        XtManageChild(w);

	/*
	 * Free up the XmString
	 */
	XmStringFree(xmstr);

	return 0;
}
