/* pardata

   pcc 6jan93

   loading and saving of annotated klatt data.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h> 
#include <memory.h>
#include <ctype.h>
#include "pardata.h"
#include "darray.h"

int nframes;
Frame frames[MAXFRAMES];


/* darrays to hold the (char *) references. */

darray_t elements;
darray_t phonemes;
darray_t words;




/* load data from an open file */

#define BUFFER_SZ 256
char buffer[BUFFER_SZ];
		/* to use for reading in extra info placed in .par files */

char *basefile;		/* reference to allow recovery of stem */
char stem[80];


void load_file(infile)
char *infile;
{
   Frame *parbase;
   long value;
   int par_count, result;
   FILE *fp;

   fp = fopen(infile, "r");
   if (fp == NULL)
    {
     printf("\nCan't open input file:%s:\n", infile);
     perror("??");
     exit(1);
    }

   darray_init(&elements, sizeof (char *), 128);
   darray_init(&phonemes, sizeof (char *), 128);
   darray_init(&words, sizeof (char *), 128);
   basefile = infile;

   nframes = 0;
   while (!feof(fp)) {
      for (par_count = 0; par_count < NPAR && !feof(fp); ++par_count) {
         result = fscanf(fp, "%ld", &value);
         frames[nframes].params[par_count] = value;

         if (value < param_info[par_count].lowerBound) {
            param_info[par_count].lowerBound = value;
         }
         if (value > param_info[par_count].upperBound) {
            param_info[par_count].upperBound = value;
         }		/* stretch the upper and lower bdries for param if
                     	   the defaults are extended. */ 
      }

      fgets(buffer, BUFFER_SZ, fp);
					/* get remainder of line */
      if (buffer[0] != '\0') {
         if (buffer[1] == '|' && buffer[2] == '>') {
					/* it is elem, phon, word information */
            char *b, *e, *n, **l;
            e = b = buffer + 4;	/* : |>: */

            while (!isspace(*e)) ++e;
            n = (char *)malloc(e-b+1);
            if (n != NULL) {
               strncpy(n, b, e-b);
               n[e-b] = '\0';
            } else {
               n = "??";
            }
            if (elements.items > 0) {
               l = darray_find(&elements, elements.items-1);
               if (e == b) {
                  free(n);
                  n = NULL;
               } else if (strncmp(*l, b, e-b) == 0) {
                  frames[nframes].element = *l; free(n);
               } else {
                  l = darray_find(&elements, elements.items);
                  *l = frames[nframes].element = n;
               }
            } else {
               l = darray_find(&elements, 0);
               *l = frames[nframes].element = n;
            }
            b = e = e + 3;		/* got element, e|: | */

            while (!isspace(*e)) ++e;
            n = (char *)malloc(e-b+1);
            if (n != NULL) {
               strncpy(n, b, e-b);
               n[e-b] = '\0';
            } else {
               n = "??";
            }
            if (phonemes.items > 0) {
               l = darray_find(&phonemes, phonemes.items-1);
               if (e == b) {
                  free(n);
                  n = NULL;
               } else if (strncmp(*l, b, e-b) == 0) {
                  frames[nframes].phoneme = *l; free(n);
               } else {
                  l = darray_find(&phonemes, phonemes.items);
                  *l = frames[nframes].phoneme = n;
               }
            } else {
               l = darray_find(&phonemes, 0);
               *l = frames[nframes].phoneme = n;
            }
            b = e = e + 3;		/* got phoneme, e|: | */

            while (!isspace(*e)) ++e;
            n = (char *)malloc(e-b+1);
            if (n != NULL) {
               strncpy(n, b, e-b);
               n[e-b] = '\0';
            } else {
               n = "??";
            }
            if (words.items > 0) {
               l = darray_find(&words, words.items-1);
               if (e == b) {
                  free(n);
                  n = NULL;
               } else if (strncmp(*l, b, e-b) == 0) {
                  frames[nframes].word = *l; free(n);
               } else {
                  l = darray_find(&words, words.items);
                  *l = frames[nframes].word = n;
               }
            } else {
               l = darray_find(&words, 0);
               *l = frames[nframes].word = n;
            }
					/* got word */
         } else if (buffer[1] == '#') {
			/* some other information */
            /* do nothing */
         } else {
			/* no idea what this is */
            /* do nothing */
         }
      }	/* end if read to eol */
#if PDEBUG
      printf("\nFrame :%d: is (%s,%s,%s)", nframes, frames[nframes].element, frames[nframes].phoneme,  frames[nframes].word);
#endif
      if (result && !feof(fp)) ++nframes;
   }		/* end while */

   fclose(fp);
}

/* 'smooth'ing the data: use of a simple "time series" style averaging. 
   signature hints at more - but this 'func' param is currently ignored */

void smooth_data(parno, func)
int parno;
int func;
{
   int i;
   long temp[MAXFRAMES];

   if (parno == -1 || nframes < 2) {
      return;
   }

   temp[0] = (frames[0].params[parno] + frames[1].params[parno]) / 2;
   for (i = 1; i < nframes -1; ++i) {
      temp[i] = (frames[i-1].params[parno] + frames[i].params[parno] + frames[i+1].params[parno]) / 3;
   }
   temp[i] = (frames[i-1].params[parno] + frames[i].params[parno]) / 2;

   for (i = 0; i < nframes; ++i) {
      frames[i].params[parno] = temp[i];
   }
}


/* save the data under a new file. A comment would be nice? */
#include <sys/stat.h>

void save_file(commenting)
int commenting;
{
   char number[6];
   char command[120];
   FILE *fo;
   int f,g;
   struct stat statbuf;
   static int lastnumber = 0;

   do {
      strncpy(stem, basefile, strlen(basefile) - 4);	
      stem[strlen(basefile) - 4] = '\0';	/* explicitly end the string */
		/* assume end = .par, done each time to save wiping suffix */
      if (isdigit(stem[strlen(stem)-1])) {
          strcat(stem, "_");
      }
      sprintf(number, "%d", lastnumber);
      strcat(stem, number);
      strcat(stem, ".par");
      ++lastnumber;
   } while (!stat(stem, &statbuf));

   fo = fopen(stem, "w");
   if (fo == NULL) {
      fprintf(stderr, "Couldn't open save_params file %s", stem);
      exit(1);
   }

   for (f = 0; f < nframes; ++f) {
      for (g = 0; g < NPAR; ++g) {
          fprintf(fo, " %6ld", frames[f].params[g]);
      }
      fprintf(fo, " |> %s", frames[f].element);
      fprintf(fo, " : %s", frames[f].phoneme == NULL ? " " : frames[f].phoneme);
      fprintf(fo, " : %s\n", frames[f].word == NULL ? " " : frames[f].word);
   }

   fclose(fo);

   if (commenting) {
      strcpy(command, "vi ");
      strcat(command, stem);
      system(command);			 /* allow commenting. */
   }
}



/* playing the parameters in memory */

/* PCC 13june94
	add: voice switch (& able to alter voicing waveform in editor? 

*/
	
void play_wave(int parallel, int nfcascade)
{
   FILE *outf;
   int f,g;
   char command[128];
   char *kd, *kv;

   outf = fopen("kplot.par", "w");
   if (outf == NULL) {
      fprintf(stderr, "\nFailed to open temp .par file.\n");
      exit(1);
   }

   for (f = 0; f < nframes; ++f) {
      for (g = 0; g < NPAR; ++g) {
         fprintf(outf, "%ld ", frames[f].params[g]);
      }
      fprintf(outf, "\n ");
   }
   fclose(outf);				 /* write data to tmp file */

   strcpy(command, "playklatt ");

   if (!parallel) {
      strcat(command, " -c -n ");
      switch (nfcascade) {
         case 4:
            strcat(command, "4");
            break;
         case 5:
            strcat(command, "5");
            break;
         case 6:
            strcat(command, "6");
            break;
      }
   }
   strcat(command, " kplot.par");

   printf("\n%s\n", command);
   system(command);
}


void InsertFrames (int insertAt, int extent)
{
   int span = 2 * extent;
   int f;

   if (nframes + span <= MAXFRAMES) {
      for (f = nframes-1; f >= insertAt; --f) {
         memcpy((char *)&frames[f+span], (char *)&frames[f], sizeof(Frame));
      }
      for (f = insertAt+1; f < insertAt+span; ++f) {
         memcpy((char *)&frames[f], (char *)&frames[insertAt], sizeof(Frame));
      }
      nframes += span;
   }
}

void DeleteFrames (int lowest, int highest)
{
   int span = highest - lowest + 1;		/* inclusive delete */

   if (nframes >= 10) {
      memcpy((char *)&frames[lowest], (char *)&frames[highest+1], (nframes-highest)*sizeof(Frame));
      nframes -= span;
   }
}


