;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(defmethod dragon-innards ((drag dragon))
  (let
      ((drag-list nil)
       (action-list nil)
       (alt-action-list nil)
       act-name
       (def-list nil))
    (setf drag-list
          `('unique-name
            ',(slot-value drag 'unique-name)
            'display-name
            ,(write-string-slot drag 'display-name)
            'associated-concepts
            ,(if (slot-empty-p drag 'associated-concepts)
                 nil
	       `(progn (add-dragon-to-concepts 
			',(slot-value drag 'unique-name)
			',(slot-value drag 'associated-concepts))
		       ',(slot-value drag 'associated-concepts)))
            'control-additions
            ,(if (slot-empty-p drag 'control-additions)
                 nil
                 `(progn 
		    (setf *verb-list* 
			  (append 
			   (mapcar #'car 
				   ',(slot-value drag 'control-additions))
			   *verb-list*))
		    ',(slot-value drag 'control-additions)))
            'tracing-control-additions
            ',(if (slot-empty-p drag 'tracing-control-additions)
                  nil
		(slot-value drag 'tracing-control-additions))
            'parsed-controller
            ',(if (slot-empty-p drag 'parsed-controller)
                  nil
		(slot-value drag 'parsed-controller))
            'parsed-tracing-controller
            ',(if (slot-empty-p drag 'parsed-tracing-controller)
                  nil
		(slot-value drag 'parsed-tracing-controller))
            'arguments
            ',(slot-value drag 'arguments)
            'components
            ',(slot-value drag 'components)
            'component-of
            ',(slot-value drag 'component-of)
            'memory-current-size
            ,(slot-value drag 'memory-current-size)
            'memory-retention-limit
            ,(slot-value drag 'memory-retention-limit)
            'memory-retention-warning-limit
            ,(slot-value drag 'memory-retention-warning-limit)
            'tool-user-slots
            ',(if (slot-empty-p drag 'tool-user-slots)
                  nil
		  (slot-value drag 'tool-user-slots))
            'afterwards
            ',(slot-value drag 'afterwards)
            'specific-function
            ,(write-string-slot drag 'specific-function)
            'rationale
            ,(write-string-slot drag 'rationale)
            'disclaimer
            ,(write-string-slot drag 'disclaimer)
            'expert
            ,(write-string-slot drag 'expert)
            'citations
            ,(write-string-slot drag 'citations)
            'author
            ,(write-string-slot drag 'author)
            'creation-date
            ,(write-string-slot drag 'creation-date)
            'last-modification-date
            ,(write-string-slot drag 'last-modification-date)
            'trace-flag
            ',(slot-value drag 'trace-flag)
            'todo-flag
            ',(slot-value drag 'todo-flag)))
    (dolist (act (slot-value drag 'parsed-controller))
	    (setf act-name (make-drag-def-name (slot-value drag 'unique-name)
					       'actions
					       (car act)))
	    (setf def-list 
		  (cons 
		   (list 'defparameter act-name `(compile nil ',(cdr act)))
		   def-list))
	    (setf action-list `(acons ',(car act) ,act-name ,action-list)))
    (setf drag-list (cons ''actions (cons `,action-list drag-list)))
    (if (not (slot-empty-p drag 'alt-actions))
        (progn (dolist (act (slot-value drag 'parsed-tracing-controller))
                      (setf act-name 
				  (make-drag-def-name 
				   (slot-value drag 'unique-name)
				   'alt-actions
				   (car act)))
                      (setf def-list (cons (list 'defparameter act-name
                                                 `(compile nil ',(cdr act)))
                                           def-list))
                      (setf alt-action-list 
			    `(acons ',(car act) ,act-name ,alt-action-list)))
               (setf drag-list 
		     (cons ''alt-actions 
			   (cons `,alt-action-list drag-list)))))
    (setf drag-list (cons drag-list def-list))
    (return-from dragon-innards drag-list)))


(defmethod ra-innards ((drag recognition-agent))
  (let ((ra-list nil)
	(drag-list (dragon-innards drag)))
    (setf ra-list 
	  `('transforms 
	    ,(make-slot-array drag 
			      'transforms 
			      (slot-value drag 'number-of-features))
	    'display-transforms
	    ,(make-slot-array drag 'display-transforms 
			      (slot-value drag 'number-of-features))
	    'output-confidence-vocabulary
	    (return-generic-instance
	     ',(class-name 
		(class-of 
		 (slot-value drag 'output-confidence-vocabulary))))
	    'confidence-value
	    ',(slot-value drag 'confidence-value)
	    'features
	    ,(make-slot-array drag 'features 
			      (slot-value drag 'number-of-features))
	    'number-of-features
	    ,(slot-value drag 'number-of-features)
	    'display-features
	    ,(make-slot-array drag 'display-features 
			      (slot-value drag 'number-of-features))
	    'feature-fetch-types
	    ,(make-slot-array drag 'feature-fetch-types 
			      (slot-value drag 'number-of-features))
	    'feature-value-types
	    ,(make-slot-array drag 'feature-value-types 
			      (slot-value drag 'number-of-features))
	    'feature-cache
	    (make-array 
	     ,(slot-value drag 'number-of-features) :initial-element
	     'unfetched)
	    'output-destination
	    ,(make-slot-array drag 'output-destination)
	    'display-output-destination
	    ,(make-slot-array drag 'display-output-destination)))
    (setf ra-list (cons (append ra-list (car drag-list))
			(cdr drag-list)))
    (return-from ra-innards ra-list)))


(defmethod dragon-type-innards ((drag match-1-recognition-agent))
  (let ((drag-type 'match-1-recognition-agent)
	(drag-type-list nil)
	(ra-list (ra-innards drag)))
    (setf drag-type-list 
	  `('test-block
	    ,(make-slot-array drag 'test-block
			      `',(list (slot-value drag 'number-of-patterns)
				       (slot-value drag 'number-of-features)))
	    'display-block
	    ,(make-slot-array drag 'display-block
			      `',(list (slot-value drag 'number-of-patterns)
				       (slot-value drag 'number-of-features)))
	    'success-thresholds
	    ,(make-slot-array drag 'success-thresholds 
			      (slot-value drag 'number-of-patterns))
	    'no-match-confidence
	    ',(slot-value drag 'no-match-confidence)
	    'display-no-match-confidence
	    ',(slot-value drag 'display-no-match-confidence)
	    'no-match-action
	    ',(slot-value drag 'no-match-action)
	    'display-no-match-action
	    ',(if (slot-empty-p drag 'display-no-match-action)
		  nil
		(slot-value drag 'display-no-match-action))
	    'match-actions
	    ,(make-slot-array drag 'match-actions 
			      (slot-value drag 'number-of-patterns))
	    'display-match-actions
	    ,(make-slot-array drag 'display-match-actions 
			      (slot-value drag 'number-of-patterns))
	    'associated-confidences
	    ,(make-slot-array drag 'associated-confidences 
			      (slot-value drag 'number-of-patterns))
	    'display-confidences
	    ,(make-slot-array drag 'display-confidences 
			      (slot-value drag 'number-of-patterns))
	    'patterns
	    ',(slot-value drag 'patterns)
	    'number-of-patterns
	    ,(slot-value drag 'number-of-patterns)))
    (setf drag-type-list (cons drag-type drag-type-list))
    (setf drag-type-list (cons (append drag-type-list (car ra-list))
			       (cdr ra-list)))
    (return-from dragon-type-innards drag-type-list)))


(defmethod dragon-type-innards ((drag discrete-pattern-recognition-agent))
  (let ((drag-type 'discrete-pattern-recognition-agent)
	(drag-type-list nil)
	(ra-list (ra-innards drag)))
        (setf drag-type-list 
	      `('match-confidence 
		',(slot-value drag 'match-confidence) 
		'display-match-confidence 
		',(slot-value drag 'display-match-confidence)
		'no-match-confidence
		',(slot-value drag 'no-match-confidence)
		'display-no-match-confidence
		',(slot-value drag 'display-no-match-confidence)
		'match-action
		',(slot-value drag 'match-action)
		'display-match-action
		',(if (slot-empty-p drag 'display-match-action)
		      nil
		    (slot-value drag 'display-match-action))
		'no-match-action
		',(slot-value drag 'no-match-action)
		'display-no-match-action
		',(if (slot-empty-p drag 'display-no-match-action)
		      nil
		    (slot-value drag 'display-no-match-action))
		'tests
		,(make-slot-array drag 'tests (slot-value drag '
							  number-of-features))
		'display-tests
		,(make-slot-array drag 'display-tests (slot-value drag
							 'number-of-features))
		'success-threshold
		,(slot-value drag 'success-threshold)))
        (setf drag-type-list (cons drag-type drag-type-list))
        (setf drag-type-list (cons (append drag-type-list (car ra-list))
                                   (cdr ra-list)))
        (return-from dragon-type-innards drag-type-list)))


(defmethod dragon-type-innards ((drag free-form-recognition-agent))
  (let ((drag-type 'free-form-recognition-agent)
         (drag-type-list nil)
         (ra-list (ra-innards drag)))
    (setf drag-type-list 
	  `('test-block
	    ,(make-slot-array drag 'test-block
			      `',(list (slot-value drag 'number-of-patterns)
				       (slot-value drag 'number-of-features)))
	    'display-block
	    ,(make-slot-array drag 'display-block
			      `',(list (slot-value drag 'number-of-patterns)
				       (slot-value drag 'number-of-features)))
	    'no-match-confidence
	    ',(if (slot-empty-p drag 'no-match-confidence)
		  nil (slot-value drag 'no-match-confidence))
	    'display-no-match-confidence
	    ',(if (slot-empty-p drag 'display-no-match-confidence)
		 nil (slot-value drag 'display-no-match-confidence))
	    'no-match-action
	    ',(slot-value drag 'no-match-action)
	    'display-no-match-action
	    ',(if (slot-empty-p drag 'display-no-match-action)
		  nil
		(slot-value drag 'display-no-match-action))
	    'match-confidence
	    ',(if (slot-empty-p drag 'match-confidence)
		  nil (slot-value drag 'match-confidence))
	    'display-match-confidence
	    ',(if (slot-empty-p drag 'match-confidence)
		  nil (slot-value drag 'display-match-confidence))
	    'match-action
	    ',(slot-value drag 'match-action)
	    'display-match-action
	    ',(if (slot-empty-p drag 'display-match-action)
		  nil
		(slot-value drag 'display-match-action))
	    'match-actions
	    ,(make-slot-array drag 'match-actions 
			      (slot-value drag 'number-of-patterns))
	    'display-match-actions
	    ,(make-slot-array drag 'display-match-actions 
			      (slot-value drag
					  'number-of-patterns))
	    'associated-confidences
	    ,(make-slot-array drag 'associated-confidences 
			      (slot-value drag
					  'number-of-patterns))
	    'display-confidences
	    ,(make-slot-array drag 'display-confidences 
			      (slot-value drag
					  'number-of-patterns))
	    'patterns
	    ',(if (slot-empty-p drag 'patterns)
		  nil (slot-value drag 'patterns))
	    'number-of-patterns
	    ,(slot-value drag 'number-of-patterns)
	    'tests
	    ,(make-slot-array drag 'tests 
			      (slot-value drag 'number-of-features))
	    'display-tests
	    ,(make-slot-array drag 'display-tests 
			      (slot-value drag 'number-of-features))
	    'success-threshold
	    ,(slot-value drag 'success-threshold)
	    'success-thresholds
	    ,(make-slot-array drag 'success-thresholds 
			      (slot-value drag 'number-of-patterns))
	    'hierarchy
	    ',(if (slot-empty-p drag 'hierarchy)
		  nil
		(write-hierarchy (slot-value drag 'hierarchy)))
	    'top-node
	    ',(if (slot-empty-p drag 'top-node)
		  nil (slot-value drag 'top-node))
	    'combining-function
	    ',(if (slot-empty-p drag 'combining-function)
		  nil (slot-value drag 'combining-function))))
    (setf drag-type-list (cons drag-type drag-type-list))
    (setf drag-type-list (cons (append drag-type-list (car ra-list))
			       (cdr ra-list)))
    (return-from dragon-type-innards drag-type-list)))


(defmethod dragon-type-innards ((drag classification-specialist))
  (let ((drag-type 'classification-specialist)
	(drag-type-list nil)
	(drag-list (dragon-innards drag)))
    (setf drag-type-list 
	  `('classifier ',(slot-value drag 'classifier) 'establish-reject
			',(slot-value drag 'establish-reject)
			'display-establish-reject
			',(slot-value drag 'display-establish-reject)
			'translator
			',(if (slot-empty-p drag 'translator)
			      nil
			    (slot-value drag 'translator))
			'display-translator
			',(if (slot-empty-p drag 'display-translator)
			      nil
			    (slot-value drag 'display-translator))
			'establish-threshold
			',(if (slot-empty-p drag 'establish-threshold)
			      nil
			    (slot-value drag 'establish-threshold))
			'display-establish-threshold
			',(if (slot-empty-p drag 'display-establish-threshold)
			      nil
			    (slot-value drag 'display-establish-threshold))
			'suspend-threshold
			',(if (slot-empty-p drag 'suspend-threshold)
			      nil
			    (slot-value drag 'suspend-threshold))
			'display-suspend-threshold
			',(if (slot-empty-p drag 'display-suspend-threshold)
			      nil
			    (slot-value drag 'display-suspend-threshold))
			'display-established-action
			',(if (slot-empty-p drag 
					    'display-established-action)
			      nil
			    (slot-value drag 'display-established-action))
			'established-action
			',(slot-value drag 'established-action)
			'display-not-established-action
			',(if (slot-empty-p drag 
					    'display-not-established-action)
			      nil
			    (slot-value drag 
					'display-not-established-action))
			'not-established-action
			',(slot-value drag 'not-established-action)
			'parent-join
			',(slot-value drag 'parent-join)
			'child-join
			',(slot-value drag 'child-join)
			'status 
			',(if (slot-empty-p drag 'status)
			      (slot-value drag 'status))
			'case 
			',(if (slot-empty-p drag 'case)
			      nil (slot-value drag 'case))
			'last-result 
			',(if (slot-empty-p drag 'last-result)
			      nil (slot-value drag 'last-result))
			'refine-result 
			',(if (slot-empty-p drag 'refine-result)
			      nil (slot-value drag 'refine-result))
			'last-establish-threshold 
			',(if (slot-empty-p drag 'last-establish-threshold)
			      nil (slot-value drag 'last-establish-threshold))
			'last-suspend-threshold 
			',(if (slot-empty-p drag 'last-suspend-threshold)
			      nil (slot-value drag 'last-suspend-threshold))
			'refine-form
			',(slot-value drag 'refine-form)
			'display-refine-form
			',(if (slot-empty-p drag 'display-refine-form)
			      nil (slot-value drag 'display-refine-form))
			'superspecialists
			',(slot-value drag 'superspecialists)
			'subspecialists
			',(slot-value drag 'subspecialists)
			'use-cache ,(slot-value drag 'use-cache)
			'establish-confidence-vocabulary
			(return-generic-instance
			 ',(class-name 
			    (class-of 
			     (slot-value drag 
					 'establish-confidence-vocabulary))))))
	  (setf drag-type-list (cons drag-type drag-type-list))
	  (setf drag-type-list (cons (append drag-type-list (car drag-list))
				     (cdr drag-list)))
	  (return-from dragon-type-innards drag-type-list)))


(defmethod dragon-type-innards ((drag classifier))
  (let ((drag-type 'classifier)
	(drag-type-list nil)
	(drag-list (dragon-innards drag)))
    (setf drag-type-list
	  `('unresolved ',(slot-value drag 'unresolved)
			'hierarchy 
			,(write-hierarchy (slot-value drag 'hierarchy))))
    (setf drag-type-list (cons drag-type drag-type-list))
    (setf drag-type-list (cons (append drag-type-list (car drag-list))
			       (cdr drag-list)))
    (return-from dragon-type-innards drag-type-list)))

(defun write-hierarchy (hier)
  (return-from write-hierarchy
	       `(pcl::*make-instance 'hierarchy 'node-type 
			  ',(slot-value hier 'node-type)
			  'sub-list
			  ',(slot-value hier 'sub-list)
			  'super-list
			  ',(slot-value hier 'super-list))))




(defmethod dragon-type-innards ((drag stub-idb))
  (let ((drag-type 'stub-idb)
	(drag-type-list nil)
	(drag-list (dragon-innards drag)))
    (setf drag-type-list 
	  `('answer-cache ',(slot-value drag 'answer-cache) 
			  'answer-cache-limit
			  ,(slot-value drag 'answer-cache-limit)
			  'saved-case-cache
			  ',(slot-value drag 'saved-case-cache)
			  'saved-case-limit
			  ,(slot-value drag 'saved-case-limit)))
    (setf drag-type-list (cons drag-type drag-type-list))
    (setf drag-type-list (cons (append drag-type-list (car drag-list))
			       (cdr drag-list)))
    (return-from dragon-type-innards drag-type-list)))


(defun make-drag-def-name (drag-name slot-name verb) 
  (return-from make-drag-def-name
	       (intern (concatenate 'string (string
					     drag-name)
				    "-"
				    (string slot-name)
				    "-"
				    (string verb))
		       (find-package "TOOLSET"))))


(defun save-dragon (dragons &optional (fpath nil fpathp)
			    &key
			    (append nil)) 
  (let* ((drag-list (cond
		     ((symbolp dragons)
		      (list dragons))
		     ((typep dragons 'dragon)
		      (list (slot-value dragons 'unique-name)))
		     ((listp dragons)
		      dragons)
		     (t 
		      (error "ERROR: DRAGONS argument to SAVE-DRAGON must be either a dragon, a dragon-name, or a list of dragon names."))))
	 (filepath (if fpathp 
		       (if (stringp fpath)
			   fpath
			   (string-downcase
			    (string fpath)))
		       (string-downcase (string (car drag-list))))))
    (if append
	(with-open-file 
	 (*standard-output* 
	  (make-pathname
	   :type "gt" 
	   :version 
	   :newest 
	   :defaults 
	   filepath)
	  :direction :output 
	  :if-exists :append 
	  :if-does-not-exist :create)
	 (format t 
		 ";;; Dragon fasload file for Generic Task Toolset~%")
	 (format t 
		 "#| This file contains the following dragons:
					~A~%|#~%~%" drag-list)
	 (write-dragon drag-list))
      (with-open-file 
       (*standard-output* 
	(make-pathname
	 :type "GT" 
	 :version 
	 :newest 
	 :defaults 
	 filepath)
	:direction :output 
	:if-exists :new-version 
	:if-does-not-exist :create)
       (format t 
	       ";;; Dragon fasload file for Generic Task Toolset~%")
       (format t 
	       "#| This file contains the following dragons:
					~A~%|#~%~%" drag-list)
       (pprint '(in-package 'toolset))
       (write-dragon drag-list)))))


(defun write-dragon (drag-list) 
  (do ((drag (pop drag-list)
	     (pop drag-list))
       (drag-form nil))
      ((null drag))
      (format t "~%~%")
      (setf drag-form (dragon-type-innards (eval drag)))
      (format t ";;; Dragon: ~A~%~%" drag)
      
      ;; Print form to destroy this dragon if it already exists

      (pprint `(if (and (boundp ',drag)
			(typep ,drag 'dragon))
		   (progn (format *trace-output* 
				  "Destroying old version of ~A.~%"
				  ',drag)
			  (toolbed::destroy ,drag)
			  (terpri))))
          
      ;; PPRINT THE DEFUNS FOR THE ACTIONS LAMBDAS

      (format t "~%;;;    Defuns for ACTIONS lambdas:~%")
      (pprint `(format *trace-output* 
		       "Loading defuns for ACTIONS lambdas ~
			  of dragon ~A.~%" ',drag))
      (dolist (def (cdr drag-form))
	      (format t "~%~%")
	      (pprint def))
      (format t "~%~%;;;    Dragon body:~%~%")
      (pprint `(format *trace-output* "~%Loading body of dragon ~A~%"
		       ',drag))
      (pprint `(defparameter ,drag (pcl::*make-instance
				    ',(caar drag-form)
				    ,@(cdar drag-form))))
      (pprint `(format *trace-output* "Finished loading dragon ~A.~%~%"
		       ',drag))
      (format t "~%")))





