;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(defmethod convert-form ((src symbol) (dest symbol))
  (convert-form (return-generic-instance src) (return-generic-instance dest)))

(defmethod convert-form ((src confidence-set) (dest symbol))
  (convert-form src (return-generic-instance dest)))

(defmethod convert-form ((src symbol) (dest confidence-set))
  (convert-form (return-generic-instance src) dest))

(defmethod convert-form ((src confidence-set) (dest confidence-set))

  (if (slot-value src 'values-list)

      (if (slot-value dest 'values-list)

	  ;; discrete -> discrete
	  `(lambda (val)
	     (setf val (unalias val ',(conf-set-name src)))
	     (if (not (member-confidence val ',(conf-set-name src)))
		 (error "~S is not a member of confidence set ~S."
			val ',(conf-set-name src)))
	     (nth
	      (round
	       (* 
		,(- (length (slot-value dest 'values-list)) 1)
		(/ (position val 
			     ',(slot-value src 'values-list))
		   ,(- (length (slot-value src 'values-list)) 1))))
	      ',(slot-value dest 'values-list)))


	  ;; discrete -> continuous
	  `(lambda (val)
	     (setf val (unalias val ',(conf-set-name src)))
	     (if (not (member-confidence val ',(conf-set-name src)))
		 (error "~S is not a member of confidence set ~S."
			val ',(conf-set-name src)))
	     (+ 
	      ,(slot-value dest 'min)
	      (*
	       ,(- (slot-value dest 'max) (slot-value dest 'min))
	       (/ (position val 
			    ;; reverse values-list because it is stored
			    ;; in order of highest to lowest, and we
			    ;; need it from lowest to highest here

			    ',(reverse (slot-value src 'values-list)))
		  ,(- (length (slot-value src 'values-list)) 1))))))


      (if (slot-value dest 'values-list)

	  ;; continuous -> discrete
	  `(lambda (val)
	     (setf val (unalias val ',(conf-set-name src)))
	     (if (not (member-confidence val ',(conf-set-name src)))
		 (error "~S is not a member of confidence set ~S."
			val ',(conf-set-name src)))
	     (nth
	      (round
	       (*
		,(- (length (slot-value dest 'values-list)) 1)
		(/
		 (- val
		    ,(slot-value src 'min))
		 ,(- (slot-value src 'max) (slot-value src 'min)))))
	      ',(reverse (slot-value dest 'values-list))))
	

	  ;; continuous -> continuous
	  `(lambda (val)
	     (setf val (unalias val ',(conf-set-name src)))
	     (if (not (member-confidence val ',(conf-set-name src)))
		 (error "~S is not a member of confidence set ~S."
			val ',(conf-set-name src)))
	     (+
	      ,(slot-value dest 'min)
	      (*
	       ,(- (slot-value dest 'max) (slot-value dest 'min))
	       (/
		(- val
		   ,(slot-value src 'min))
		,(- (slot-value src 'max) (slot-value src 'min)))))))))



					  
(DEFun INVERT-form (CONF-SET-INSTANCE)
  (if (symbolp conf-set-instance)
      (setf conf-set-instance (return-generic-instance conf-set-instance)))
  (if (slot-value conf-set-instance 'values-list)
      (RETURN-FROM
       INVERT-form
       `(LAMBDA
	 (VAL)
	 (setf val (unalias val ',(conf-set-name conf-set-instance)))
	 (if (not (member-confidence val ',(conf-set-name conf-set-instance)))
	     (error "~S is not a member of confidence set ~S."
		    val ',(conf-set-name conf-set-instance)))
	 (NTH (1- (- ,(LENGTH (SLOT-VALUE CONF-SET-INSTANCE '
					  VALUES-list))
		     (POSITION VAL ',(SLOT-VALUE CONF-SET-INSTANCE
                                         'VALUES-list))))
	      ',(SLOT-VALUE CONF-SET-INSTANCE 'VALUES-list))))
      (return-from
       invert-form
       `(lambda (val)
	  (setf val (unalias val ',(conf-set-name conf-set-instance)))
	  (if (not (member-confidence val ',(conf-set-name conf-set-instance)))
	      (error "~S is not a member of confidence set ~S."
		     val ',(conf-set-name conf-set-instance)))

	  ;; (max - ((max - min) * (val - min)/(max - min)))
	  (- ,(slot-value conf-set-instance 'max)
	     (* ,(- (slot-value conf-set-instance 'max)
		   (slot-value conf-set-instance 'min))
		(/ (- val ,(slot-value conf-set-instance 'min))
		   ,(- (slot-value conf-set-instance 'max)
		       (slot-value conf-set-instance 'min)))))))))



