;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFMETHOD tracing-controllers
  ((RA DISCRETE-PATTERN-RECOGNITION-AGENT))
  "Build tracing judge for discrete pattern."
  (let
      ((args (cadr (assoc 'judge (slot-value ra 'arguments)))))
  (return-from
   tracing-controllers
    (acons
     'judge
     `(LAMBDA
       ,(append ARGS '(&optional answer-type))
       (DECLARE (SPECIAL *CURRENT-DRAGON*) 
	       (ignore answer-type))
       (BLOCK JUDGE-BLOCK (FLUSH-FEATURE-CACHE)
	     (LET ((K 0)
		   RESULT)
		  (DOTIMES (I ,(SLOT-VALUE RA 'NUMBER-OF-FEATURES))
                           (IF (TRACE-A-TEST I)
                               (SETF K (1+ K)))
                           (IF (>= K ,(SLOT-VALUE RA 'SUCCESS-THRESHOLD))
                               (PROGN (SETF RESULT 
					    (traCE-THE-CONSEQUENT i))
                                      (SETF (SLOT-VALUE 
					     *CURRENT-DRAGON*
					     'CONFIDENCE-VALUE)
                                            RESULT)
                                      (REMEMBER 'PATTERN RESULT)
                                      (EVAL (SLOT-VALUE 
					     *CURRENT-DRAGON*
					     'MATCH-ACTION))
                                      (RETURN-FROM JUDGE-BLOCK RESULT))))
		  (SETF RESULT (TRACED-NO-MATCH))
		  (SETF (SLOT-VALUE *CURRENT-DRAGON* 'CONFIDENCE-VALUE)
			RESULT)
		  (EVAL (SLOT-VALUE *CURRENT-DRAGON* 'NO-MATCH-ACTION))
		  (RETURN-FROM JUDGE-BLOCK RESULT)))) nil))))



(DEFMETHOD controllers ((RA DISCRETE-PATTERN-RECOGNITION-AGENT)) 
  "Build judge lambda for discrete pattern."
    (LET
     ((CLAUSE-BUILDER NIL)
      THRESHOLD NUMBER-OF-TS 
      (ARGS (CADR (ASSOC 'JUDGE (SLOT-VALUE RA 'ARGUMENTS)))))

     (DOTIMES (J (SLOT-VALUE RA 'NUMBER-OF-FEATURES))
	      
	      ;; stuff the tests into the clause builder
	      
	      (PUSH (AREF (SLOT-VALUE RA 'TESTS) J)
		    CLAUSE-BUILDER))
     (SETF CLAUSE-BUILDER (DELETE `T CLAUSE-BUILDER))
       
     ;; number of T's removed
     
     (SETF NUMBER-OF-TS (- (SLOT-VALUE RA 'NUMBER-OF-FEATURES)
			   (LENGTH CLAUSE-BUILDER)))
       
     ;;  threshold is lowered by the number of tests which
     ;; automatically succeed

     (SETF THRESHOLD (- (SLOT-VALUE RA 'SUCCESS-THRESHOLD) NUMBER-OF-TS))
     (COND
       
      ;; if the number of T's is greater than the
      ;; succeess-theshold,
       
      ;; automatically succeed

      ((>= NUMBER-OF-TS (SLOT-VALUE RA 'SUCCESS-THRESHOLD))
       (RETURN-FROM controllers
		    (acons 'judge
			   `(LAMBDA ,(append ARGS '(&optional answer-type))
				    (DECLARE (SPECIAL *CURRENT-DRAGON*))
				    (FLUSH-FEATURE-CACHE)
				    (SETF 
				     (SLOT-VALUE *CURRENT-DRAGON* 
						 'CONFIDENCE-VALUE)
				     ,(SLOT-VALUE RA 'MATCH-CONFIDENCE))
				    (REMEMBER 'PATTERN 0 
					      ,(SLOT-VALUE RA
							   'MATCH-CONFIDENCE))
				    (EVAL ,(SLOT-VALUE RA 'MATCH-ACTION))
				    ,(SLOT-VALUE RA 'MATCH-CONFIDENCE))
			   nil)))
       
       ;; if success-threshold is greater than the number of
       ;; tests remaining (need to try all the tests), make AND
       ;; of the tests

        ((>= THRESHOLD (LENGTH CLAUSE-BUILDER))
         (SETF CLAUSE-BUILDER (NREVERSE CLAUSE-BUILDER))
         (SETF CLAUSE-BUILDER (CONS 'AND CLAUSE-BUILDER))
         (SETF CLAUSE-BUILDER
               (LIST 'IF CLAUSE-BUILDER
                     `(PROGN (SETF (SLOT-VALUE *CURRENT-DRAGON*
                                          'CONFIDENCE-VALUE)
                                   ,(SLOT-VALUE RA 'MATCH-CONFIDENCE))
       
       ;; check how remember works

                             (REMEMBER 'PATTERN ,(SLOT-VALUE 
						   RA 'MATCH-CONFIDENCE))
                             (EVAL ,(SLOT-VALUE RA 'MATCH-ACTION))
                             ,(SLOT-VALUE RA 'MATCH-CONFIDENCE))
                     `(PROGN (SETF (SLOT-VALUE *CURRENT-DRAGON*
                                          'CONFIDENCE-VALUE)
                                   ,(SLOT-VALUE RA 'NO-MATCH-CONFIDENCE))
                             (REMEMBER 'PATTERN ,(SLOT-VALUE
						   RA 'NO-MATCH-CONFIDENCE))
                             (EVAL ,(SLOT-VALUE RA 'NO-MATCH-ACTION))
                             ,(SLOT-VALUE RA 'NO-MATCH-CONFIDENCE))))
         (RETURN-FROM controllers
		      (acons
		       'judge
		       `(LAMBDA ,(append ARGS '(&optional answer-type))
				(DECLARE (SPECIAL *CURRENT-DRAGON*))
				(FLUSH-FEATURE-CACHE)
				,CLAUSE-BUILDER) nil)))
        (T
       
       ;; have to go through it the hard way

         (SETF CLAUSE-BUILDER (NREVERSE CLAUSE-BUILDER))
         (SETF
          CLAUSE-BUILDER
          `(BLOCK JUDGE-BLOCK
                  (DO* ((I ,THRESHOLD)
                        (K 0 (1+ K))
                        (TEST ',(NTH 0 CLAUSE-BUILDER)
                              (NTH K ',CLAUSE-BUILDER)))
       
       ;; loop until you run out of tests or you don't have
       ;; enough tests left to possibly make the threshold

                       ((OR (>= K ,(LENGTH CLAUSE-BUILDER))
                            (< (- ,(LENGTH CLAUSE-BUILDER) K)
                             I)))
                       (IF (EVAL TEST)
                           (SETF I (1- I)))
                       (IF (<= I 0)
                           (PROGN (SETF (SLOT-VALUE *CURRENT-DRAGON*
						    'CONFIDENCE-VALUE)
                                        ,(SLOT-VALUE RA 'MATCH-CONFIDENCE))
                                  (REMEMBER 'PATTERN  
                                         ,(SLOT-VALUE RA 'MATCH-CONFIDENCE))
                                  (EVAL ,(SLOT-VALUE RA 'MATCH-ACTION))
                                  (RETURN-FROM JUDGE-BLOCK ,
                                         (SLOT-VALUE RA 'MATCH-CONFIDENCE)))))
                  (SETF (SLOT-VALUE *CURRENT-DRAGON* 'CONFIDENCE-VALUE)
	     		,(SLOT-VALUE RA 'NO-MATCH-CONFIDENCE))
                  (EVAL ,(SLOT-VALUE RA 'NO-MATCH-ACTION))
                  (RETURN-FROM JUDGE-BLOCK ,(SLOT-VALUE
				    RA 'NO-MATCH-CONFIDENCE))))

         (RETURN-FROM controllers
		      (acons
		       'judge
		       `(LAMBDA ,(append ARGS '(&optional answer-type))
				(DECLARE (SPECIAL *CURRENT-DRAGON*))
				(FLUSH-FEATURE-CACHE)
				,CLAUSE-BUILDER) nil))))))


