;;;-*-Mode:LISP; Package: PCL; Base:10; Syntax:Common-lisp -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;;

(in-package 'pcl)

(defvar *combination-test-classes*
	'((foo ())
	  (bar (foo))
	  (baz (foo))
	  (a   (bar))
	  (j0  (a baz))
	  (j1  (j0))
	  (j2  (baz bar))
	  (d   ())
	  (e   (d bar baz))
	  (i   ())
	  (j   ())
	  (k   ())
	  (l   (i j k))))

(defvar *combination-tests*
	'(
	  (g0
	    ((m1 (d))
	     (m2 (bar)))

	    (((d)   (m1))
	     ((e)   (m1 m2))
	     ((bar) (m2))))

	  (g1
	    ((m1 (d))
	     (m2 (baz)))

	    (((d)   (m1))
	     ((e)   (m1 m2))
	     ((baz) (m2))))

	  
	  (g2
	    ((m1 (bar))
	     (m2 (baz)))

	    (((bar) (m1))
	     ((e)   (m1 m2))
	     ((j2)  (m2 m1))
	     ((j0)  (m1 m2))
	     ((baz) (m2))))
	  
	  (g3
	   ((m1 (foo))
	    (m2 (bar))
	    (m3 (baz)))

	   (((foo) (m1))
	    ((bar) (m2 m1))
	    ((e)   (m2 m3 m1))
	    ((j2)  (m3 m2 m1))
	    ((j0)  (m2 m3 m1))
	    ((baz) (m3 m1)))
	   )

	  (g4
	    ((m1 (d))
	     (m2 (bar)))

	    (((d)   (m1))
	     ((e)   (m1 m2))
	     ((bar) (m2)))
	    )

	  (g5
	    ((m1 (i))
	     (m2 (j))
	     (m3 (k)))

	    (((i) (m1))
	     ((j) (m2))
	     ((l) (m1 m2 m3))
	     ((k) (m3)))
	    )

	  (g6
	    ((m1 (d))
	     (m2 (bar))
	     (m3 (baz)))

	    (((d)   (m1))
	     ((bar) (m2))
	     ((e)   (m1 m2 m3))
	     ((j2)  (m3 m2))
	     ((j0)  (m2 m3))
	     ((baz) (m3)))
	    )

	  (g7
	    ((m1 (bar bar))
	     (m2 (baz baz)))

	    (((bar bar) (m1))
	     ((j0  j0)  (m1 m2))
	     ((j0  j2)  (m1 m2))
	     ((j0  e)   (m1 m2))
	     ((j2  j0)  (m2 m1))
	     ((j2  j2)  (m2 m1))
	     ((j2  e)   (m2 m1))
	     ((e   j0)  (m1 m2))
	     ((e   j2)  (m1 m2))
	     ((e   e)   (m1 m2))
	     ((baz baz) (m2)))
	    )


	  (g8
	    ((m1 (foo foo))
	     (m2 (bar bar)))

	    (((foo foo) (m1))
	     ((bar bar) (m2 m1))))

	  (g9
	    ((m1 (bar bar))
	     (m2 (d d)))

	    (((bar bar) (m1))
	     ((e   e)   (m2 m1))
	     ((d   d)   (m2))))

	  (g10
	    ((m1 (foo))
	     (m2 (bar))
	     (m3 (e))
	     (m4 (d)))

	    (((foo) (m1))
	     ((bar) (m2 m1))
	     ((e)   (m3 m4 m2 m1))
	     ((d)   (m4))))

	  ))



(defvar *combination-test-generic-functions* ())

(defun test-combination-points ()
  (setq *combination-test-generic-functions* ())
  (let ((classes
	  (cons (cons 't (class-named 't))
		(mapcar #'(lambda (x)
			    (cons (car x) (make-instance 'standard-class)))
			*combination-test-classes*))))
    (flet ((get-class (name)
	     (or (cdr (assoc name classes))
		 (error "can't get class ~S." name))))		 
      (dolist (c *combination-test-classes*)
	(let* ((name (car c))
	       (supers (cadr c))
	       (class (get-class name)))	  
	(update-class class :direct-superclasses (mapcar #'get-class supers))
	(setf (slot-value class 'name) name)))
      (dolist (test *combination-tests*)
	(let ((name (car test))
	      (methods (cadr test))
	      (expected-points (caddr test)))
	  (format t "~%Test ~S" name)
	  (let* ((gf (make-instance 'standard-generic-function :name name))
		 (method-objects
		   (mapcar #'(lambda (m)
			       (let* ((name (car m))
				      (specializers (cadr m))
				      (method 
					(make-instance
					  'standard-method
					  :type-specifiers
					  (mapcar #'get-class specializers))))
				 (add-method gf method)
				 (cons name method)))
			   methods)))
	    (push gf *combination-test-generic-functions*)
	    (labels ((get-method (name)
		       (or (cdr (assoc name method-objects))
			   (error "Couldn't get method ~S." name)))
		     (point-lessp (p1 p2)
		       (cond ((eq p1 p2) nil)
			     ((eq (car p1) (car p2))
			      (point-lessp (cdr p1) (cdr p2)))
			     (t
			      (member (rassoc p2 classes)
				      (member p1 classes :key #'cdr)))))
		     (sort-points (points)
		       (sort points #'point-lessp)))
	      (setq expected-points
		    (mapcar #'(lambda (p)
				(list (mapcar #'get-class (car p))
				      (mapcar #'get-method (cadr p))))
			    expected-points))	      
	      (unless (equal (sort-points (compute-combination-points gf))
			     (sort-points expected-points))
		(print (sort-points (compute-combination-points gf)))
		(print (sort-points expected-points))
		(error "compute-combination-points failed test ~S"
		       name)))))))))

#||
(defclass i () ())
(defclass j (i) ())
(defclass k (j) ())

(defclass x () ())
(defclass y (x) ())
(defclass z (y) ())

(defclass l () ())
(defclass m (l) ())
(defclass n (m) ())

(defclass foo () ())
(defclass bar (foo) ())
(defclass baz (bar) ())

(fmakunbound 'foo)

(defmethod foo :before ((x object)) (print 'before-object))
(defmethod foo :after ((x object)) (print 'after-object))
(defmethod foo ((x object)) (print 'object))
(defmethod foo :around ((x object))
  (print 'before-around-object)
  (call-next-method)
  (print 'after-around-object))

(fmakunbound 'bar)

(defmethod bar ((x object)) (print 'object))

(defmethod bar :before ((x i)) (print 'before-i))
(defmethod bar :before ((x j)) (print 'before-j))
(defmethod bar :before ((x k)) (print 'before-k))


(defmethod bar :before ((x l)) (print 'before-l))
(defmethod bar :before ((x m)) (print 'before-m))
(defmethod bar :before ((x n)) (print 'before-n))

(defmethod bar :before ((x x)) (print 'before-x))
(defmethod bar :before ((x y)) (print 'before-y))
(defmethod bar :before ((x z)) (print 'before-z))


(fmakunbound 'baz)

(defmethod baz :before ((x object)) (print 'before-object))
(defmethod baz :after ((x object)) (print 'after-object))
(defmethod baz ((x object)) (print 'object))

(defmethod baz :before ((x i)) (print 'before-i))
(defmethod baz :after ((x i)) (print 'after-i))
(defmethod baz ((x i)) (print 'i))

(defmethod baz :before ((x j)) (print 'before-j))
(defmethod baz :after ((x j)) (print 'after-j))
(defmethod baz ((x j)) (print 'j))

||#