;;
;;
;;      Title : mklex
;;
;;      Function : UNIX level command to make a lexicon
;;
;;      Author :  Alan W Black  November 1985
;;                Dept of Artificial Intelligence
;;                University of Edinburgh
;;
;;      Copyright Graeme Ritchie, Alan Black,
;;                Steve Pulman and Graham Russell  1987
;;
;;         ---------------------------------------------
;;         |    Not to be used for military purposes   |
;;         ---------------------------------------------
;;
;;      Description :
;;         This is designed as a UNIX level command, although written
;;         in lisp the user should be unaware of that fact.  For
;;         details of use see the the laatest version of the user document
;;         "Dictionary and Morphological Analyser"  or type man mklex
;;
;;         This command has the same basic function as the the lisp
;;         function D-MakeLexicon
;;         
;;
;;      Parameters :
;;         filename:  the filename (without .le extension) containing
;;             the lexicon description
;;      Returns :
;;             ?
;;      Side Effect :
;;             writes the file  filename.le.ma and filename.en.ma
;;             to the same directory as the given filename
;;
;;      External references :
;;
;;      System functions used :
;;        Name     type      Args #  type                 Comment
;;
;;      Restrictions :
;;        for version 38.75 of Franz (for vax) you have to change
;;        the quoting of "usemap" to 'usemap
;;
;;

(declare
   (special
      $ldprint
      rcode
   )
)

(princ "Loading lexicon compiler") (terpri)

(include "keywords")

(let ( (usemap (assoc (DK-USEMAP) environment)) )
   (cond
      ((null usemap)   ;;  usemap variable not set
	 nil
      )
      (t               ;; add usemap to search path
         (eval (list 'sstatus 'load-search-path
                   (append
	              (list (cdr usemap))
	              (status load-search-path))))
      )
   )
)
(include "maload.l")  ;; the bootstrap routine 

(defun top-level ()
(setq $ldprint nil)   ;; no loading info 
(sstatus translink on)
(allocate 'list 1000)
(allocate 'symbol 500)
(allocate 'fixnum 100)    ;; it doesn't seem to dynamically increase fixnums
   (setq rcode
   (errset
      (let ()
         (cond
            ((eq (argv -1) 4) ;; if one param is given its the name of the file
	       (d-maloadcomp)
	       (princ "Starting compilation of ")
	       (princ (argv 3))
	       (terpri)
               (D-MakeLexicon (argv 3))
	       0                      ;; return code
            )
            (t                ;; zero or more than 1 param then wrong number of
                              ;; params             
               (princ "mklex: error: should be only one parameter")
               (terpri)
               (princ "usage:  mklex <name>  where <name>.le is the lexicon file")
               (terpri)
               1                ;; exit with error code 
            )
         )
      )
   ))
   (cond
      ((eq (car rcode) 0)
         (exit)             ;; exit with 0 retrun code
      )
      (t                    ;; must have been some error
         (exit 1)
      )
   )
)

(reset)   ;; call the new top-level
