;*------------------------------------------------------------------26/May/89-*
;*                  MAIN-TEST
;* 
;*   A file to be used with "attend.lsp". This provides an alternate run and 
;* main-loop functions so that accuracy and efficiency can be tested over
;* many executions.
;*   To use this file the input data must have every other instance be a 
;* test instance, since learning is OFF when instance-cntr is odd.
;* 
;* 
;*---------------------------------------------------------------------JHG----*

(require "loop" "/ci/ua/gennari/bin/loop")
(use-package "LOOP")

(require "attend2")

#|----------------------------------------------------------------15/Jun/88----
   Function  - run
       
   Inputs    -> input file, optional output file
       
   Returns   -> the final tree.
-------------------------------------------------------------------KThompso--|#


(defun run (&optional
	           (infile nil)
		   (num-atts 0)            ;number of attributes in input set.
	    &key 
		   (outfile nil) 
		   (breaker nil)
		   (acuity 1.0)
		   (testsetfile nil)
		   (threshold 1.0)         ; defaults to no cut-off
		   (min-chance 0.005)
                   (debug nil)
		   (att-type :numeric)
		   (att-names nil)
		   (attention t)
		   (print-function :short)
		   (print-each nil)
                   (tree nil)
                   (learning t)
                   (pred-atts *PRED-ATTS*))

  (unless infile
    (usage)
    (return-from run (values)))

  (setq *LEARNING* learning)     (setq *ATTENTION* attention)
  (setq *ACUITY* acuity)         (setq *THRESHOLD* threshold)
  (setq *MIN-CHANCE* min-chance) (setq *PRED-ATTS* pred-atts)

  (setup-node-printer print-function)

  (let ((input-stream (open infile :direction :input))
	errorlist totalwork
	(outfile-name (if (eq outfile t)                    
			   (concatenate 'string infile ".out")
			    outfile)))

                               ;*setup output files
    (setf *GLOBAL-DEBUG* debug)
    (if testsetfile
          (setq *TEST-SET* (readtestset testsetfile num-atts))
          (setq *TEST-SET* nil))
    (setq
       *OUTPUT-STREAM*
       (if outfile
	 (open outfile-name :direction :output :if-exists :new-version)
	 *standard-output*))

    (print-out-banner infile outfile-name)

			       ;* error-check att-names
    (when att-names
      (assert (and (= num-atts (length att-names))
		   (equal (remove-duplicates att-names) att-names))
	   (att-names)
	   "List of att-names ~A ~% is invalid -- must be length ~
            ~D and have no duplicates~%:r to continue" att-names num-atts))

                               ;* create att-names
    (setq *ATT-NAMES* (or att-names *ATT-NAMES* (make-att-names num-atts)))

    (setq *TYPE-LIST*
       (case att-type
	   (:nominal (make-list num-atts :initial-element :nominal))
	   (:numeric (make-list num-atts :initial-element :numeric))
	   (:mixed (read-att-type input-stream num-atts))))
    (setq *TYPE-LIST*
	  (loop for att in *ATT-NAMES* for type in *TYPE-LIST*
		collect (cons att type)))

			       ;* loop through remaining instances
    (multiple-value-setq
      ( tree errorlist totalwork)
      (main-loop print-each breaker input-stream outfile num-atts tree))

			       ;* finished with instances
    (close input-stream)
    (let ((str (concatenate 'string
		      "********************** Finished with instances at "
		      (get-time))))
      (pr-out "~%~A~2%" str)
      (if outfile (format t "~%~A~2%" str)))
    (if outfile (pr-out "~%~A~%" tree))    ;don't if to term; will be returned.
    (when outfile (close *OUTPUT-STREAM*))

    (values errorlist totalwork) ;return the percentage errors and the work
))

#|----------------------------------------------------------------15/Jun/88----
   Function  - MAIN-LOOP

   Inputs    -> print-each
                breaker
                *ATT-NAMES*
                input-stream
                outfile
                num-atts
                tree
       
   Returns   -> the tree resulting from looping through the instances. Or, 
        if prediction is on, a list of attributes and predicted values.

   Actions   -> Here is the basic incremental loop: an instance is read
        (into the global property list associated with 'obj), and it is 
        incorporated into the hierarchy of concepts. Note that the first
        instance is handled slightly differently.  -JHG 3/13/89
-------------------------------------------------------------------KThompso--|#

(defun main-loop (print-each breaker input-stream outfile num-atts tree)

  (let ((HALT (not (readinstance input-stream num-atts)))
	(instance-cntr 1)
         predicted actual scores)

  (if (null tree) ; the tree is sometimes pre-set by the user.
      (progn
        (setq tree (create-node *ATT-NAMES*))  ;add the first instance to root
        (setq HALT (not (readinstance input-stream num-atts))) ;the 2nd inst.
	(setq instance-cntr (1+ instance-cntr)))
  )

  (loop until HALT do
      
      (setq *LEARNING* t)
      (update-costs :clear t)

      (pr-out "~v%**** INCORPORATING new instance ~4D    ~A~%" 
	      (if print-each 3 1) instance-cntr (given-name 'OBJ))

      (cond ((> instance-cntr 2)
             (setf (node-members tree)
		   (cons (given-name 'OBJ) (node-members tree)))
	     (setf (node-count tree) (1+ (node-count tree))))
      )

      (setq tree (classify tree *ATT-NAMES* 0 ))

      (setq *LEARNING* nil)
    (if *TEST-SET* 
      (loop for testinstance in *TEST-SET* do
        (readinst-test testinstance)
	(setq actual (clear-atts *PRED-ATTS*))
        
        (setq predicted
               (classify tree *ATT-NAMES* 0 ))

	collect (diff actual predicted) into errorscore
      finally
        (setq scores (cons (loop for val in errorscore 
				 if val collect (abs val) into list
			         finally 
				   (return (/ (apply '+ list) (length list)))
			   )
			   scores))
	(pr-out "~%List of scores: ~A~%" errorscore)
        (pr-out "ave. score over test instances: ~4,3F~%" (car scores))
      )
    )

      (if print-each (pr-out "~%~A" tree))
      (if breaker (break "stopping in main(tst)-loop"))

      (setf (symbol-plist 'obj) nil)

      (setq instance-cntr (1+ instance-cntr))
      (setq HALT (not (readinstance input-stream num-atts)))

 when *TEST-SET*
      collect (/ *COST-N* (length *TEST-SET*)) into node-cost
 when *TEST-SET*
      collect (/ *COST-A* (length *TEST-SET*)) into att-cost
 when *TEST-SET*
      collect (/ *WORK* (length *TEST-SET*)) into totalwork

   finally
      (pr-out "Nodes: ~%~A~%" node-cost)
      (pr-out "Attributes: ~%~A~%" att-cost)
      (pr-out "work: ~%~A~%" totalwork)
      (pr-out "list of percentage errors: ~%")
      (loop for score in (reverse scores) do
	    (pr-out "~6,3F" score))

      (return (values tree (reverse scores) totalwork))
  )
))


;*------------------------------------------------------------------19/Jun/89-*
;*  Function  - CLEAR-ATTS
;* 
;*  Inputs    -> the list of attributes (and OBJ).
;* 
;*  Actions   -> Sets the value of these attributes to '?
;*  Returns   -> a list of the original values.
;*---------------------------------------------------------------------JHG----*

(defun clear-atts (attlist)

  (loop for att in attlist
	collect (get 'OBJ att) into saved
	do (putprop 'OBJ '? att)
	finally
	    (return saved)
	)
)

;*------------------------------------------------------------------19/Jun/89-*
;*  Function  - DIFF
;* 
;*  Inputs    -> the list of "actual" values, and the list of predicted 
;*     attributes.
;* 
;*  Returns   -> a list of the differences between the actual and the mean
;*     stored in each attribute. This is where I'll normalize the error. 
;*     (Currently, this means dividing by the expected S.D.)
;*
;*  **SPECIAL PURPOSE** 
;*---------------------------------------------------------------------JHG----*

(defun diff (actual predicted)

  (let* ((pred (car predicted))
	 (value (car actual))
	 mean)
  (cond (pred
	 (if (< (NumAtt-acount pred) 1 ) (break "acount is zero!"))  
         (if (numericp pred) (break "Numeric attribute!"))

	 ;  (setq mean (/ (NumAtt-sum pred) (NumAtt-acount pred)))
         ;  (pr-out "actual: ~5,2F predicted: ~5,2F   %ERROR: ~5,2F~%"
	 ;  value mean (- value mean))
         ;  (- value mean))

	 (cond ((eq value (best-val pred)) 1 ;else
		(pr-out "CORRECT ")
		 1 )
	       ( t
		 (pr-out "WRONG ")
		  0 )
	 ))
	( t
	  (break "predicted attribute is null."))
  ))
)  

;*------------------------------------------------------------------07/Jul/89-*
;*  Function  - READINST-TEST
;* 
;*  Inputs    -> an instance as a list of values (also uses *ATT-NAMES*).
;*     This list should have the "given-name" last, and it's length should 
;*     be equal to length of *Att-names* + 1.
;* 
;*  Actions   -> sets the property list associated with 'OBJ to the 
;*     appropriate attribute - value pairs. 
;*   NOTICE: this is very different from readinstance, which reads instances
;*     from a file. Here, the test set if fixed, and this should be much 
;*     quicker (no file I/O).
;*---------------------------------------------------------------------JHG----*

(defun readinst-test (inst)

   (loop for value in inst
	 for name in *ATT-NAMES* do
	   (putprop 'obj value name)
      finally
         (putprop 'obj (car (last inst)) 'given)
   )
)

;*------------------------------------------------------------------07/Jul/89-*
;*  Function  - READTESTSET
;* 
;*  Inputs    -> filename and number of attributes
;* 
;*  Returns   -> a list of instances, each of which is a list of values
;*     read from the file "filename".
;*---------------------------------------------------------------------JHG----*

(defun readtestset (filename num-atts)

  (let ((fd (open filename :direction :input))
	 one-inst)
  (loop until (null (car (setq one-inst
			 (loop repeat (1+ num-atts)
			       collect (read fd nil nil)))))
	collect one-inst into result
  finally
        (close fd)
	(return result)
  ))
)

