;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

(in-package 'user)

(export '(*brules* *facts*))

(setf *domain* 'qsim-diagnosis)

(setf *brules*
      '(
	(<- (qval cna ?m3 ?d3 ?t) (norm c1)
	                          (qval anp ?m1 ?d1 ?t) (qval awp ?m2 ?d2 ?t)
	                          (holds./ anp awp cna ?m1 ?d1 ?m2 ?d2 ?m3 ?d3))
	(<- (qval cnh ?m2 ?d1 ?t) (norm c2)
	                          (qval awp ?m1 ?d1 ?t)
	                          (holds.m0+ awp cnh ?m1 ?d1 ?m2 ?d1))
	(<- (qval fpu ?m2 ?d1 ?t) (norm c3)
	                          (qval cnh ?m1 ?d1 ?t)
	                          (holds.m0+ cnh fpu ?m1 ?d1 ?m2 ?d1))
	(<- (qval cadh ?m2 ?d1 ?t) (norm c4)
	                           (qval cna ?m1 ?d1 ?t)
	                           (holds.m0+ cna cadh ?m1 ?d1 ?m2 ?d1))
	(<- (qval rfup ?m2 ?d1 ?t) (norm c5)
	                           (qval cadh ?m1 ?d1 ?t)
	                           (holds.m0+ cadh rfup ?m1 ?d1 ?m2 ?d1))
	(<- (qval nfpu ?m3 ?d3 ?t) (norm c6)
	                           (qval fpu ?m1 ?d1 ?t) (qval rfup ?m2 ?d2 ?t)
	                           (holds.- fpu rfup nfpu ?m1 ?d1 ?m2 ?d2 ?m3 ?d3))
	(<- (qval nfop ?m3 ?d3 ?t) (norm c7)
	                           (qval nfip ?m1 ?d1 ?t) (qval nfpu ?m2 ?d2 ?t)
	                           (holds.- nfip nfpu nfop ?m1 ?d1 ?m2 ?d2 ?m3 ?d3))
	
	#|(<- (qval nfop2 ?m2 ?d2 ?t) (norm c8)
	                            (qval awp ?m1 ?d1 ?t)
	                            (holds.d/dt awp nfop2 ?m1 ?d1 ?m2 ?d2))|#

	(<- (qval cnh cnh- std ?t) (stuck-at-low-std c2)
	                           (qval awp ?m1 ?d1 ?t)
				   (pos cnh-))
	(<- (qval cnh cnh+ std ?t) (stuck-at-high-std c2)
	                           (qval awp ?m1 ?d1 ?t)
				   (pos cnh+))

	(<- (qval fpu fpu- std ?t) (stuck-at-low-std c3)
	                           (qval cnh ?m1 ?d1 ?t)
				   (pos fpu-))
	(<- (qval fpu fpu+ std ?t) (stuck-at-high-std c3)
	                           (qval cnh ?m1 ?d1 ?t)
				   (pos fpu+))

	(<- (qval cadh cadh- std ?t) (stuck-at-low-std c4)
	                             (qval cna ?m1 ?d1 ?t)
				     (pos cadh-))
	(<- (qval cadh cadh+ std ?t) (stuck-at-high-std c4)
	                             (qval cna ?m1 ?d1 ?t)
				     (pos cadh+))

	(<- (qval rfup rfup- std ?t) (stuck-at-low-std c5)
	                             (qval cadh ?m1 ?d1 ?t)
				     (pos rfup-))
	(<- (qval rfup rfup+ std ?t) (stuck-at-high-std c5)
	                             (qval cadh ?m1 ?d1 ?t)
				     (pos rfup+))

	(<- (qval anp ?m1 ?d1 ?t) (given-qval anp ?m1 ?d1 ?t))
	(<- (qval awp ?m1 ?d1 ?t) (given-qval awp ?m1 ?d1 ?t))
	(<- (qval nfip ?m1 ?d1 ?t) (given-qval nfip ?m1 ?d1 ?t))
	

	(<- (holds.m0+ ?f ?g ?m1 inc ?m2 inc)
	    (pos ?m1) (pos ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	(<- (holds.m0+ ?f ?g ?m1 std ?m2 std)
	    (pos ?m1) (pos ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	(<- (holds.m0+ ?f ?g ?m1 dec ?m2 dec)
	    (pos ?m1) (pos ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	
	(<- (holds.m0+ ?f ?g ?m1 inc ?m2 inc)
	    (neg ?m1) (neg ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	(<- (holds.m0+ ?f ?g ?m1 std ?m2 std)
	    (neg ?m1) (neg ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))
	(<- (holds.m0+ ?f ?g ?m1 dec ?m2 dec)
	    (neg ?m1) (neg ?m2) (corr-mag.m0+ ?f ?g ?m1 ?m2))

	(<- (holds.- ?f ?g ?h ?m inc ?m inc 0 inc)
	    (corr-val.- ?f ?g ?h ?m inc ?m inc 0 inc))
	(<- (holds.- ?f ?g ?h ?m inc ?m inc 0 std)
	    (corr-val.- ?f ?g ?h ?m inc ?m inc 0 std))
	(<- (holds.- ?f ?g ?h ?m inc ?m inc 0 dec)
	    (corr-val.- ?f ?g ?h ?m inc ?m inc 0 dec))
	(<- (holds.- ?f ?g ?h ?m dec ?m dec 0 inc)
	    (corr-val.- ?f ?g ?h ?m dec ?m dec 0 inc))
	(<- (holds.- ?f ?g ?h ?m dec ?m dec 0 std)
	    (corr-val.- ?f ?g ?h ?m dec ?m dec 0 std))
	(<- (holds.- ?f ?g ?h ?m dec ?m dec 0 dec)
	    (corr-val.- ?f ?g ?h ?m dec ?m dec 0 dec))

	(<- (holds.- ?f ?g ?h ?m inc 0 inc ?m inc)
	    (corr-val.- ?f ?g ?h ?m inc 0 inc ?m inc))
	(<- (holds.- ?f ?g ?h ?m inc 0 inc ?m std)
	    (corr-val.- ?f ?g ?h ?m inc 0 inc ?m std))
	(<- (holds.- ?f ?g ?h ?m inc 0 inc ?m dec)
	    (corr-val.- ?f ?g ?h ?m inc 0 inc ?m dec))
	(<- (holds.- ?f ?g ?h ?m dec 0 dec ?m inc)
	    (corr-val.- ?f ?g ?h ?m dec 0 dec ?m inc))
	(<- (holds.- ?f ?g ?h ?m dec 0 dec ?m std)
	    (corr-val.- ?f ?g ?h ?m dec 0 dec ?m std))
	(<- (holds.- ?f ?g ?h ?m dec 0 dec ?m dec)
	    (corr-val.- ?f ?g ?h ?m dec 0 dec ?m dec))

	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))
	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (<> ?m1 ?m2) (<> ?m1 ?m3) (corr-val.- ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))
	
	(<- (holds.* ?f ?g ?h 0 inc ?m inc 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 inc ?m std 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 inc ?m dec 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m inc 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m std 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m dec 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m inc 0 dec)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m std 0 dec)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m dec 0 dec)
	    (pos ?m))

	(<- (holds.* ?f ?g ?h 0 inc ?m inc 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 inc ?m std 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 inc ?m dec 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m inc 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m std 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 std ?m dec 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m inc 0 inc)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m std 0 inc)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h 0 dec ?m dec 0 inc)
	    (neg ?m))

	(<- (holds.* ?f ?g ?h ?m inc 0 inc 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m inc 0 std 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m inc 0 dec 0 dec)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 inc 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 std 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 dec 0 dec)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 inc 0 inc)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 std 0 std)
	    (pos ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 dec 0 dec)
	    (pos ?m))
	
	(<- (holds.* ?f ?g ?h ?m inc 0 inc 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m inc 0 std 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m inc 0 dec 0 inc)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 inc 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 std 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m std 0 dec 0 inc)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 inc 0 dec)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 std 0 std)
	    (neg ?m))
	(<- (holds.* ?f ?g ?h ?m dec 0 dec 0 inc)
	    (neg ?m))
	
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 inc ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 dec ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 std ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 inc ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 dec ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 std ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))
	
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))
	
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 std ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 std))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val.* ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 std ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds.* ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag.* ?f ?g ?h ?m1 ?m2 ?m3))


	(<- (holds./ ?f ?g ?h 0 inc ?m inc 0 inc)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 inc ?m std 0 inc)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 inc ?m dec 0 inc)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m inc 0 std)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m std 0 std)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m dec 0 std)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m inc 0 dec)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m std 0 dec)
	    (pos ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m dec 0 dec)
	    (pos ?m))
	    
	(<- (holds./ ?f ?g ?h 0 inc ?m inc 0 dec)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 inc ?m std 0 dec)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 inc ?m dec 0 dec)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m inc 0 std)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m std 0 std)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 std ?m dec 0 std)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m inc 0 inc)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m std 0 inc)
	    (neg ?m))
	(<- (holds./ ?f ?g ?h 0 dec ?m dec 0 inc)
	    (neg ?m))

	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (pos ?m1) (pos ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))
	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 std ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 inc ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 dec ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 std)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 std ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))	
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (pos ?m1) (neg ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 std ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 inc ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 dec ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 std)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 std ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (neg ?m1) (pos ?m2) (neg ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 inc ?m2 inc ?m3 dec))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 std ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 inc ?m2 dec ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))	
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 inc ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 std ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 std ?m2 dec ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 inc ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))	
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 std ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-mag./ ?f ?g ?h ?m1 ?m2 ?m3))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 inc))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 std)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 std))
	(<- (holds./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec)
	    (neg ?m1) (neg ?m2) (pos ?m3)
	    (corr-val./ ?f ?g ?h ?m1 dec ?m2 dec ?m3 dec))

	(<- (holds.d/dt ?f ?g ?m1 inc ?m2 inc)
	    (pos ?m2) (corr-val.d/dt ?f ?g ?m1 inc ?m2 inc))
	(<- (holds.d/dt ?f ?g ?m1 inc ?m2 std)
	    (pos ?m2) (corr-val.d/dt ?f ?g ?m1 inc ?m2 std))
	(<- (holds.d/dt ?f ?g ?m1 inc ?m2 dec)
	    (pos ?m2) (corr-val.d/dt ?f ?g ?m1 inc ?m2 dec))
	(<- (holds.d/dt ?f ?g ?m1 std 0 inc)
	    (corr-val.d/dt ?f ?g ?m1 std 0 inc))
	(<- (holds.d/dt ?f ?g ?m1 std 0 std)
	    (corr-val.d/dt ?f ?g ?m1 std 0 std))
	(<- (holds.d/dt ?f ?g ?m1 std 0 dec)
	    (corr-val.d/dt ?f ?g ?m1 std 0 dec))
	(<- (holds.d/dt ?f ?g ?m1 dec ?m2 inc)
	    (neg ?m2) (corr-val.d/dt ?f ?g ?m1 dec ?m2 inc))
	(<- (holds.d/dt ?f ?g ?m1 dec ?m2 std)
	    (neg ?m2) (corr-val.d/dt ?f ?g ?m1 dec ?m2 std))
	(<- (holds.d/dt ?f ?g ?m1 dec ?m2 dec)
	    (neg ?m2) (corr-val.d/dt ?f ?g ?m1 dec ?m2 dec))
	))

(setf *facts*
      '((holds.m0+ ?f ?g 0 inc 0 inc)
	(holds.m0+ ?f ?g 0 std 0 std)
	(holds.m0+ ?f ?g 0 dec 0 dec)
	
	(holds.- ?f ?g ?h ?m inc ?m std 0 inc)
	(holds.- ?f ?g ?h ?m inc ?m dec 0 inc)
	(holds.- ?f ?g ?h ?m std ?m inc 0 dec)
	(holds.- ?f ?g ?h ?m std ?m std 0 std)
	(holds.- ?f ?g ?h ?m std ?m dec 0 inc)
	(holds.- ?f ?g ?h ?m dec ?m inc 0 dec)
	(holds.- ?f ?g ?h ?m dec ?m std 0 dec)
	
	(holds.- ?f ?g ?h ?m inc 0 std ?m inc)
	(holds.- ?f ?g ?h ?m inc 0 dec ?m inc)
	(holds.- ?f ?g ?h ?m std 0 inc ?m dec)
	(holds.- ?f ?g ?h ?m std 0 std ?m std)
	(holds.- ?f ?g ?h ?m std 0 dec ?m inc)
	(holds.- ?f ?g ?h ?m dec 0 inc ?m dec)
	(holds.- ?f ?g ?h ?m dec 0 std ?m dec)
	
	(holds.* ?f ?g ?h 0 inc 0 inc 0 std)
	(holds.* ?f ?g ?h 0 inc 0 std 0 std)
	(holds.* ?f ?g ?h 0 inc 0 dec 0 std)
	(holds.* ?f ?g ?h 0 std 0 inc 0 std)
	(holds.* ?f ?g ?h 0 std 0 std 0 std)
	(holds.* ?f ?g ?h 0 std 0 dec 0 std)
	(holds.* ?f ?g ?h 0 dec 0 inc 0 std)
	(holds.* ?f ?g ?h 0 dec 0 std 0 std)
	(holds.* ?f ?g ?h 0 dec 0 dec 0 std)
	))

(setf *nogoods*
      '(((pos 0))
	((neg 0))
	((pos ?m) (neg ?m))

	((corr-val.- ?f ?g ?h ?m1 ?d1 ?m2 ?d2 0 ?d3) (<> ?m1 ?m2))
	((corr-mag.- ?f ?g ?h ?m1 ?m2 0) (<> ?m1 ?m2))
	((corr-val.- ?f ?g ?h ?m1 ?d1 0 ?d2 ?m3 ?d3) (<> ?m1 ?m3))
	((corr-mag.- ?f ?g ?h ?m1 0 ?m3) (<> ?m1 ?m3))

	((corr-val.- ?f ?g ?h ?m1 ?d1 ?m2 ?d2 ?m3 ?d3) (> ?m2 ?m1) (pos ?m3))
	((corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3) (> ?m2 ?m1) (pos ?m3))
	((corr-val.- ?f ?g ?h ?m1 ?d1 ?m2 ?d2 ?m3 ?d3) (> ?m1 ?m2) (neg ?m3))
	((corr-mag.- ?f ?g ?h ?m1 ?m2 ?m3) (> ?m1 ?m2) (neg ?m3))
	
	((corr-val.- ?f ?g ?h 0 ?d1 ?m2 ?d2 ?m3 ?d3) (pos ?m2) (pos ?m3))
	((corr-mag.- ?f ?g ?h 0 ?m2 ?m3) (pos ?m2) (pos ?m3))
	((corr-val.- ?f ?g ?h 0 ?d1 ?m2 ?d2 ?m3 ?d3) (neg ?m2) (neg ?m3))
	((corr-mag.- ?f ?g ?h 0 ?m2 ?m3) (neg ?m2) (neg ?m3))
	))

(setf *assumption-nogoods* nil)

(setf *corr-mags*
      '((corr-mag.m0+ awp cnh awp* cnh*)
	(corr-mag.m0+ awp cnh awp+ cnh+)
	(corr-mag.m0+ awp cnh awp- cnh-)
	(corr-mag.m0+ cnh fpu cnh* fpu*)
	(corr-mag.m0+ cnh fpu cnh+ fpu+)
	(corr-mag.m0+ cnh fpu cnh- fpu-)
	(corr-mag.m0+ cna cadh cna* cadh*)
	(corr-mag.m0+ cna cadh cna+ cadh+)
	(corr-mag.m0+ cna cadh cna- cadh-)
	(corr-mag.m0+ cadh rfup cadh* rfup*)
	(corr-mag.m0+ cadh rfup cadh+ rfup+)
	(corr-mag.m0+ cadh rfup cadh- rfup-)))

; case specific observations for kidney water balance mechanism

(setf *wb-obs*
      '(
	(pos anp*)
	(pos awp+)
	(pos nfip+)
	(qval anp anp* std t0)
	(qval awp awp+ inc t0)
	(qval nfip nfip+ std t0)

	(pos n0)
	(qval nfop n0 dec t0)
	(qval nfop2 n0 dec t0)
	(pos cadh+)
	(qval cadh cadh+ std t0)
	))

(setf *inter-batch-beam-width* 30)
(setf *intra-batch-beam-width* 30)
(setf *bchain-depth* 7)
(setf *caching* t)
(setf *factoring* nil)
(setf *remove-superset?* nil)
(setf *explanation-eval-metric* #'diag-simplicity)
(setf *compute-estimate-fn* #'diag-compute-estimate)
(setf *combine-estimates-fn* #'diag-combine-estimates)

(setf *predicate-specific-abduction* t)
(setf *assumable-predicates*
      '(norm stuck-at-high-std stuck-at-low-std given-qval
	     pos neg corr-mag.m0+
	     corr-mag.- corr-val.- corr-mag.* corr-val.*
	     corr-mag./ corr-val./ corr-val.d/dt <> >))
(setf *free-assumption-predicates*
      '(norm given-qval
	     pos neg corr-mag.m0+
	     corr-mag.- corr-val.- corr-mag.* corr-val.*
	     corr-mag./ corr-val./ corr-val.d/dt <> >))
(setf *fault-mode-predicates*
      '(stuck-at-high-std stuck-at-low-std))
(setf *components* '(c1 c2 c3 c4 c5 c6 c7))
