;;; -*- Mode:Common-Lisp; Package:user; Base:10 -*-

;;;; Copyright (c) 1992 by Hwee Tou Ng. This program may be freely
;;;; copied, used, or modified provided that this copyright notice 
;;;; is included in each copy of this code and parts thereof.

(in-package :user)

(proclaim '(optimize (speed 3) (compilation-speed 0)))

(defvar *mode-probs*)
(defvar *configs*)
(defvar *experiments*)

; Given port (eg. in1), gate (eg. x1), and state,
; return the correspoding atom (eg. (in1 x1 0 t0)).

(defun get-port-atom (port gate state)
  (dolist (a state)
    (when (and (eq (first a) port)
	       (eq (second a) gate))
      (return a))))

(defun run-adder-expt (expt &aux result
		       (num-io-tuples 0) (atom-count 0))
  (format t "~%Experiment #~d~%" (first expt))
  (format t "~%Configuration:~%~a~%" (second expt))
  (aaa::init-abduce)
  (dolist (state (cddr expt))
    (incf num-io-tuples)
    (aaa::inc-abduce (get-port-atom 'in1 'x1 state) (incf atom-count) nil)
    (aaa::inc-abduce (get-port-atom 'in2 'x1 state) (incf atom-count) nil)
    (aaa::inc-abduce (get-port-atom 'in1 'a2 state) (incf atom-count) nil)
    (aaa::inc-abduce (get-port-atom 'out 'x2 state) (incf atom-count) nil)
    (dolist (c '(o1 x1 a1 a2))
      (setf result
	    (check-diagnosis
	      (aaa::inc-abduce (get-port-atom 'out c state) (incf atom-count) nil)
	      (second expt)))
      (when result
	(aaa::remove-current-indices)
	(return-from run-adder-expt
	  (if (eq result 'done) num-io-tuples 'fail))))
    )
  (aaa::remove-current-indices)
  nil)

; Return two values:
; 1. one of: done, fail (no diagnosis), or nil (not found yet);
; 2. run time.

(defun check-diagnosis (final-goal config &aux best-envs run-time)
  (format t "~%Total number of explanations = ~d~%"
	  (length (aaa::node-label final-goal)))
  ;(aaa::print-envs (aaa::node-label final-goal))
  (setf best-envs (aaa::select-best-environments (aaa::node-label final-goal)))
  ;(format t "~%Best explanations:~%")
  ;(aaa::print-envs best-envs)
  (setf run-time (compute-run-time aaa::*start-time*))
  (when (null best-envs)
    (format t "~%Failure: no diagnosis found.~%")
    (return-from check-diagnosis (values 'fail run-time)))
  (when (and (null (rest best-envs))
	     (correct-diagnosis? (first best-envs) config))
    (format t "~%Run Time = ~,2F min~%" run-time)
    (format t "~%Correct diagnosis found.~%")
    (aaa::print-envs best-envs)
    (return-from check-diagnosis (values 'done run-time)))
  (values nil run-time))

(defun correct-diagnosis? (env config &aux as)
  (dolist (a (aaa::environment-assumptions env))
    (when (behavior-mode-assumption? a)
      (push a as)))
  (dolist (a as)
    (when (notany #'(lambda (c) (and (eq (first a) (first c))
				     (eq (second a) (second c))))
		  config)
      (return-from correct-diagnosis? nil)))
  (dolist (c config t)
    (when (notany #'(lambda (a) (and (eq (first a) (first c))
				     (eq (second a) (second c))))
		  as)
      (return-from correct-diagnosis? nil))))

(defun run-expts (expts &aux results time)
  (dolist (expt expts)
    (setf time (with-profiling (aaa::compute-label)
			       (run-expt (eval expt))))
    (push (list (string expt) *inf-count* time)
	  results))
  (terpri)
  (dolist (result (reverse results))
    (format t "(~a  ~5d ~,2f)~%"
	    (first result) (second result) (third result)))
  (format t "~%Averages:~%")
  (format t "Inference count = ~,2f~%"
	  (average (mapcar #'second results)))
  (format t "Run time = ~,2f minutes~%"
	  (average (mapcar #'third results)))
  (values))

; Return the run time for this experiment.

(defun run-expt (expt &aux (atom-count 0) result run-time)
  (format t "~%Experiment ~a~%" (first expt))
  (format t "~%Configuration:~%~a~%" (second expt))
  (aaa::init-abduce)
  (dolist (state (cddr expt))
    (dolist (atom state)
      (multiple-value-setq (result run-time)
	(check-diagnosis
	  (aaa::inc-abduce atom (incf atom-count) nil)
	  (second expt)))
      (when result
	(aaa::remove-current-indices)
	(return-from run-expt run-time))))
  (aaa::print-envs
    (aaa::node-label
      (aaa::query-cache (final-goal-datum atom-count nil) *bchain-depth*)))
  (aaa::remove-current-indices)
  run-time)
