/*=============================================================================

 F U Z Z Y   A R T M A P  (1 9 9 1)                  CAS/CNS Boston University 

  ** written by Ah-Hwee Tan  **

  ** Documented Oct 18, 1991 **
  ** revised    Dec 26, 1991 **

=============================================================================*/

#include "ARTMAP.h"

extern int    ART ();
extern int    ARTreset ();
extern float  choiceOrderFunction ();
extern float  matchFunction ();

void init_system ()
{
    if (randomInit == 1)
      srand(time(NULL));
    else 
      srand(randomInit);
}

void init_ARTMAP ()
{
    int init_ARTMAP_x;
    int init_ARTMAP_y;

    for (init_ARTMAP_x = 0; init_ARTMAP_x < num_category[ARTa]+1; init_ARTMAP_x++)
      {
	confidence[init_ARTMAP_x] = 1.;
	makes_prediction[init_ARTMAP_x] = FALSE;
	for (init_ARTMAP_y = 0; init_ARTMAP_y < num_category[ARTb]+1; init_ARTMAP_y++)
	  IAMI[init_ARTMAP_x][init_ARTMAP_y] = 0;
      }
}

void init_series ()
{
  int ps_x, ps_y, i, j, v;

  min_times_through_training = 100;
  max_times_through_training = 0;
  tot_times_through_training = 0;
  tot_committed_nodes = 0;
  min_committed_node = 99999;
  max_committed_node = -1;
  min_rate_on_test = 100.0;
  max_rate_on_test = 0.0;
  tot_no_prediction = 0;
  sum_rate_on_test = 0.0;
  sum_sq_rate_on_test = 0.0;

  for (v=0; v<num_voters; v++)
    for (i=0; i<2; i++)
      for (j=0; j<num_data_category; j++)
	right_wrong[v][i][j] = 0;

  for (v=0; v<num_voters; v++)
    {
      sum_rate[v] = 0.0;
      sum_sq_rate[v] = 0.0;
    }

  if (display_confusion_matrix)
    {
      for (v=0; v<num_voters; v++)
	for(ps_x = 0; ps_x < num_data_category+1; ps_x++)
	  for(ps_y = 0; ps_y < num_data_category; ps_y++)
	    p_table[v][ps_x][ps_y] = 0;
    }
  
}

int   data_category (v, n, pc)
float *v;
int   n, pc;
{
  int  i, num_cat, cat;
  
  num_cat = 0;
  for (i=0; i<n; i++)
    if (v[i]>0.5)
      {
	cat = i;
	num_cat++;
      }

  if (num_cat==1)
    return (cat);
  else
    {
      printf ("Warning: Error in class of pattern %d.\n", pc);
      return (-1);
    }
}

void pre_scan_data ()
{
  int i, j, B_winner, found;

  for (i=0; i<tot_pats; i++)
    Index[i] = i;

  for (i=0; i<=num_data_category; i++)
    frequency[i] = 0;

  for (i=0; i<tot_pats; i++)
    {
      read_pattern (i);
      B_winner = data_category (pattern[ARTb],b_length,i);
      if (B_winner==-1)
	B_winner = num_data_category;
      frequency[B_winner]++;
    }

  printf ("Number of Data Category = %d\n", num_data_category);
  for (i=0; i<num_data_category; i++)
    printf ("Frequency of Category %d = %d\n", i+1, frequency[i]);
  printf ("\n");

  free_memory ();
}

int present (whichART)
int whichART;
{
    int present_x;

    for (present_x = 0; present_x < num_att[whichART]; present_x++)
      if(pattern[whichART][present_x] > 0.00000000000001)
	    return 1;
    return 0;
}

void destroy (A_node)
int   A_node;
{
    int destx;

    for (destx = 0; destx < num_att[ARTa]; destx++)
      dn[ARTa][A_node][destx] = dnInit;

    for (destx = 0; destx < num_category[ARTb]+1; destx++)
      IAMI[A_node][destx] = 0;

    confidence[A_node] = 1.;
    makes_prediction[A_node] = FALSE;
    committed[ARTa][A_node] = FALSE;
}

void change_confidence (A_node, reduce_confidence, phase)
int A_node, reduce_confidence, phase;
{
  /* This subroutine adjusts the confidence of nodes according to whether 
     they just made a correct prediction (reduce_confidence = 0)
     or an incorrect prediction (reduce_confidence = 1). */
  
   if (phase == TRAIN)
    {
      confidence[A_node] += noise_rate * (1. - confidence[A_node] - reduce_confidence);
      if (confidence[A_node] < noise_tolerance)
	destroy (A_node);
    } 
}

void IA_reset (A_node, phase, pat_id)
int A_node, phase, pat_id;
{
  int  subset_choice=FALSE;
  float match;

  wrong = TRUE;
  
  /*    fprintf(pgm,"%3.3f\n",choiceOrderFunction(0,A_node));*/
  
  if (track_on_choice)
    if (choiceOrderFunction (ARTa,A_node) >= .99)
      subset_choice = TRUE;
  
  match = matchFunction(ARTa,A_node);
  
  if (track_on_choice)
    {
      if (subset_choice && rho[0] < match+epsilon)
	rho[0] = match + epsilon;
    }
  else
    {
      if (rho[0] < match+epsilon)
	rho[0] = match + epsilon;
    /*  else
	fprintf(temp,"Currently A_node = %d with matchfunction(%d,%d) = %3.3f, choice %3.3f.  Can't raise rho[0] = %3.3f.\n",A_node,0,A_node,matchFunction(0,A_node),choiceOrderFunction(0,A_node),rho[0]); */
    }
  
  if (rho[0] >= 1.)
    {
      perfect_mismatch = TRUE;
      printf("WARNING: PERFECT_MISMATCH ON PATTERN %d:(%d)\n\n",pat_id+1,Index[pat_id]+1);
      num_perfect_mismatch++;
    }
  else
    {
      if (phase == TRAIN)
	got_all_train_right = FALSE;
      F2[0][A_node] = -1;
    }
}

void learn_prediction (A_node, B_node)
int A_node, B_node;
{
    int learn_prediction_x;
    int learn_prediction_y;

    for (learn_prediction_x = 0; learn_prediction_x < num_category[1]+1; learn_prediction_x++)
      IAMI[A_node][learn_prediction_x] = 0;

    IAMI[A_node][B_node] = 1;
/*    fprintf(temp,"ART-A %d predicts ART-B %d.\n",A_node,B_node);*/
    makes_prediction[A_node] = TRUE;
}

int  B_then_A (phase, pat_id)
int  phase, pat_id;
{
  int A_winner, B_winner;
  int B_then_A_x;
  int predict=FALSE, reset=FALSE;

  perfect_mismatch=FALSE;

  if (trace >= 2)
    printf ("\nPattern %d :\n", pat_id);

  B_winner = ART (ARTb,phase);

  if (phase == TRAIN)
    learn(ARTb,B_winner);
  actual_result = B_winner;
  
  do {
    A_winner = ART (ARTa,phase);
    if (trace >= 2)
      printf ("A_winner %d B_winner %d\n", A_winner, B_winner);
	    
    if (makes_prediction[A_winner])
      {
	predict = TRUE;
	no_prediction = FALSE;

	for (B_then_A_x=0; B_then_A_x<num_category[1]+1; B_then_A_x++)
	  if(IAMI[A_winner][B_then_A_x])
	    {
	      if (first_prediction == -1)
		first_prediction = B_then_A_x;
	    }
	
	if (IAMI[A_winner][B_winner])
	  {
	    if (trace >= 2)
	      printf ("Expectation confirmed\n");
	    reset = FALSE;
	    /* expectation confirmed */
	    if (phase == TRAIN)
	      {
		learn (ARTa,A_winner);
		change_confidence (A_winner,0,phase);
	      }
	  }
	else
	  {
	    if (trace >= 2)
	      printf ("Expectation mismatched\n");
	    reset = TRUE;
	    wrong = TRUE;
	    /* expectation mismatch */
	    IA_reset (A_winner,phase,pat_id);
	    if (phase==TRAIN)
	      change_confidence (A_winner,1,phase);
	  }
      }
    else  /* No prediction was made. */
      {
	if (trace >= 2)
	  printf ("No prediction\n");
	wrong = TRUE;
	predict = FALSE;
	if (phase == TRAIN)
	  {
	    learn(ARTa,A_winner);          	  /* learn ART_A pattern. */
	    learn(ARTb,B_winner);	          /* learn ART_B pattern. */
	    learn_prediction(A_winner, B_winner); /* learn new prediction. */
	  }
      }
  } while (predict && reset && !perfect_mismatch);
  return (first_prediction);
}

void A_then_B (phase, pat_id)
int  phase, pat_id;
{
  int  A_winner, B_winner;
  int prediction;                         /* index of predicted ART-B node */
  int A_then_B_x;
  
  A_winner = ART (ARTa,phase);
  
  if (makes_prediction[A_winner])
    {
      for (A_then_B_x=0; A_then_B_x<num_category[1]+1; A_then_B_x++)
	if(IAMI[A_winner][A_then_B_x])
	  prediction = A_then_B_x;
      
      if (first_prediction == -1)
	{
	  first_prediction = prediction;
	  no_prediction = FALSE;
	}
      
      if (!ARTreset(prediction))
	{
	  /* expectation confirmed */
	  wrong = FALSE;
	  if (phase == TRAIN)
	    {
	      learn (ARTa,A_winner);
	      learn (ARTb,prediction);
	    }
	}
      else
	{
	  /* expectation mismatch */
	  wrong = TRUE;
	  IA_reset (A_winner,phase,pat_id);
	  if (!perfect_mismatch)
	    B_then_A (phase,pat_id);
	}
    }
  
  else  /* No prediction was made. */
    {
      B_winner = ART (ARTb,phase);
      if (phase == TRAIN)
	{
	  learn (ARTa,A_winner);       		/* learn ART_A pattern. */
	  learn (ARTb,B_winner);	       	/* learn ART_B pattern. */
	  learn_prediction (A_winner, B_winner); /* learn new prediction. */
	}
    }
}

void A_only (phase)
int  phase;
{
  if (phase == TRAIN)
    learn (ARTa,ART(ARTa,TRAIN));
}

void B_only (phase)
int  phase;
{
  if (phase == TRAIN)
    learn (ARTb,ART(ARTb,TRAIN));
}

void no_input()
{
  fprintf(temp,"No input presented at either ART module.\n");
}


void predict (flag,pat_id)                /* assigns activities to all map field nodes */
int flag, pat_id;                                  /* and reads out the activities there */
{
  if (present (0))
    {
      if (present (1))
	{
	  if (order==BA)       /* binary: 0 = ART-A pattern presented first.
			      1 = ART-B pattern presented first. */
	    B_then_A (flag,pat_id);
	  else
	    A_then_B (flag,pat_id);
	}
      else
	A_only (flag);
    }
  else            /* ART--A not presented */
    {
      if (present (1))
	B_only (flag);
      else
	no_input();
    }
}

void refresh_system()
{
  first_prediction = -1;  /* when makes first prediction, this is set to the index of the 
			       predicted ART-B node. It is used to keep track of errors by prediction 
			       type */
  wrong = FALSE;
  no_prediction = TRUE;
  rho[ARTa] = min_arho;
  order = BA;            
  /* If AB, ART-A receives input first.  After an inter-ART mismatch reset, order is set to BA
     indicating that ART-B has identified a winner while ART-A returns to its search cycle.
     It is possible to allow ART-B to initially receive its pattern first by setting order
     to BA here.*/
  refresh_F2 ();
}

void record_train_performance()
{
  if (no_prediction)
    num_no_prediction++;
  else
    if (wrong)
      num_wrong++;
    else
      num_right++;
}

void record_test_performance(pat, predict)
int  pat, predict;
{
  if (no_prediction)
    {
      if (predict !=-1)
	printf ("Error");
      num_no_prediction++;
      num_votes[pat][num_data_category]++;
    }
  else
    {
      num_votes[pat][predict]++;
      if (wrong)
	num_wrong++;
      else
	num_right++;
    }
}

setup_index (num_pats)
int num_pats;
{
  int firstIndex;
  int secondIndex;
  int holdingTank;
  
  for (firstIndex = 0; firstIndex < num_pats; firstIndex++)
    {
      secondIndex = rand()%num_pats;
      holdingTank = Index[firstIndex];
      Index[firstIndex] = Index[secondIndex];
      Index[secondIndex] = holdingTank;
    }
}

collect_statistics ()
{
  float rate_on_test;

  tot_times_through_training += times_through_training;
  if (times_through_training > max_times_through_training)
    max_times_through_training = times_through_training;
  if (times_through_training < min_times_through_training)
    min_times_through_training = times_through_training;
  
  if (min_committed_node > num_category[0])
    min_committed_node = num_category[0];
  if (max_committed_node < num_category[0])
    max_committed_node = num_category[0];
  tot_committed_nodes += num_category[0];

  rate_on_test = 100*num_right/(float)test_pats;
  sum_rate_on_test += rate_on_test;
  sum_sq_rate_on_test += rate_on_test*rate_on_test;
  if (rate_on_test < min_rate_on_test)
    min_rate_on_test = rate_on_test;
  if (rate_on_test > max_rate_on_test)
    max_rate_on_test = rate_on_test;
}

void   init_votes ()
{
  int  pat_count, i;

  for (pat_count=0; pat_count<test_pats; pat_count++)
    {
      for (i=0; i<=num_data_category; i++)
	num_votes[pat_count][i] = 0;
      actual_category[pat_count] = 0;
    }
}

void   count_votes (v)
int    v;
{
  int  pat_count, i;
  int  max, max_vote;
  int  right;
  float rate;

  right = 0;
  for (pat_count=0; pat_count<test_pats; pat_count++)
    {
      max_vote = num_votes[pat_count][0];
      max = 0;
      for (i=1; i<=num_data_category; i++)
	if (num_votes[pat_count][i] > max_vote ||
	    (num_votes[pat_count][i]==max_vote && frequency[i]>frequency[max]))
	  {
	    max_vote = num_votes[pat_count][i];
	    max = i;
	  }

      if (max==num_data_category)
	tot_no_prediction++;
      else if (max==actual_category[pat_count])
	{
	  right++;
	  right_wrong[v][0][max]++;
	}
      else
	right_wrong[v][1][max]++;

      if (display_confusion_matrix)
	p_table[v][max][actual_category[pat_count]]++;
    }
  rate = 100*right/(float)test_pats;
  sum_rate[v] += rate;
  sum_sq_rate[v] += rate*rate;
}

calculate_correlation_coeff ()
{
  int  i, j, v;
  int  p, n, u, o;

  for (v=0; v<num_voters; v++)
    for (i=0; i<num_data_category; i++)
      {
	p = p_table[v][i][i];
	
	o = 0;
	for (j=0; j<num_data_category; j++)
	  o += p_table[v][i][j];
	o -= p;

	u = 0;
	for (j=0; j<num_data_category+1; j++)
	  u += p_table[v][j][i];
	u -= p;
	
	n = num_runs*test_pats - u - p - o;
	
	C[v][i] = p*n-u*o;
	C[v][i] /= sqrt ((double)(n+u)*(n+o)*(p+u)*(p+o));
      }
}

void train_process ()
{
  int done_training = FALSE;
  int phase, pat_count, v, i, predict_category;

  times_through_training = 0;
  
  while (!done_training)
    {
      num_wrong = 0;
      num_right = 0;
      num_perfect_mismatch = 0;
      num_no_prediction = 0;
      done_training = TRUE;
      got_all_train_right = TRUE;
      
      if (trace >= 1)	     
	printf ("-- Learning Iteration %d\n\n", times_through_training+1);
      
      for (pat_count=0; pat_count<train_pats; pat_count++)
	{
	  refresh_system();
	  read_pattern (pat_count);
	  predict_category = B_then_A (TRAIN, pat_count);
	  record_train_performance (predict_category);
	}
      
      if (trace >=1)
	report_train_performance ();
      
      times_through_training++;
      
      if (!on_line)  /* If the system is doing "offline learning" - repeatedly going through training patterns */
	if (times_through_training < max_iterations && num_right+num_perfect_mismatch!=train_pats)
	  done_training = FALSE;
	else if (num_right!=train_pats)
	  printf ("WARNING : Training stopped when 100%% recognition not achieved\n");
      
    }
}

void test_process ()
{  
  int done_training = FALSE;
  int phase, pat_count, v, i, predict_category;

  if (trace >=1 )
    printf ("Testing ...\n\n");
  
  num_wrong = 0;
  num_right = 0;
  num_perfect_mismatch = 0;
  num_no_prediction = 0;
  
  for (pat_count=0; pat_count<test_pats; pat_count++)
    {
      refresh_system ();
      read_pattern (pat_count);
      predict_category = B_then_A (TEST, pat_count);
      record_test_performance (pat_count, predict_category);
      actual_category[pat_count] = ART (ARTb,TEST);
    }
  report_test_performance ();
}

void process ()    /* governs overall processing during both training and testing */
{
  int done_training = FALSE;
  int phase, pat_count, v, i, predict_category;

  times_through_training = 0;
  
  while (!done_training)
    {
      num_wrong = 0;
      num_right = 0;
      num_perfect_mismatch = 0;
      num_no_prediction = 0;
      done_training = TRUE;
      got_all_train_right = TRUE;
      
      if (trace >= 1)	     
	printf ("-- Learning Iteration %d\n\n", times_through_training+1);
      
      for (pat_count=0; pat_count<train_pats; pat_count++)
	{
	  refresh_system();
	  read_pattern (pat_count);
	  predict_category = B_then_A (TRAIN, pat_count);
	  record_train_performance (predict_category);
	}
      
      if (trace >=1)
	report_train_performance ();
      
      times_through_training++;
      
      if (!on_line)  /* If the system is doing "offline learning" - repeatedly going through training patterns */
	if (times_through_training < max_iterations && num_right+num_perfect_mismatch!=train_pats)
	  done_training = FALSE;
	else if (num_right!=train_pats)
	  printf ("WARNING : Training stopped when 100%% recognition not achieved\n");
      
    }
  
  if (trace >=1 )
    printf ("Testing ...\n\n");
  
  num_wrong = 0;
  num_right = 0;
  num_perfect_mismatch = 0;
  num_no_prediction = 0;
  
  for (pat_count=0; pat_count<test_pats; pat_count++)
    {
      refresh_system ();
      read_pattern (pat_count+train_pats);
      predict_category = B_then_A (TEST, pat_count);
      record_test_performance (pat_count, predict_category);
      actual_category[pat_count] = ART (ARTb,TEST);
    }
  
  if (trace >=1)
    report_test_performance ();
      
  collect_statistics ();
  if (trace_weight)
    display_weight ();
}








