/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: stream.c,v 2.1 91/06/18 22:02:27 dick Exp $
*/

#define		LINT_ARGS
#include	<stdio.h>
#include	"token.h"
#include	"stream.h"

/* imports from the lex module */
extern int yylex();
extern yystart();
extern FILE *yyin;

/*	This level implements the direct interaction with the lexical
	module.  It supplies the routines below.
*/

TOKEN lex_token;			/* token produced */
unsigned int lex_nl_cnt;		/* line count */
unsigned int lex_tk_cnt;		/* token position */
long lex_fs_pos;			/* fseek position */

int
OpenStream(fname)
	char *fname;
{
	lex_nl_cnt = 1;
	lex_tk_cnt = 0;
	lex_fs_pos = 0L;
	
	/* start the lex machine */
	yyin = fopen(fname, "r");
	yystart();
	return yyin != 0;
}

int
NextStrToken() {
	return yylex();
}

CloseStream() {
	if (yyin) {
		fclose(yyin);
		yyin = 0;
	}
}
