/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: sim.c,v 2.2 91/09/17 21:33:18 dick Exp $
*/

#define		LINT_ARGS
#include	<stdio.h>
#include	"cport.h"
#include	"private.h"
#include	"params.h"
#include	"option.h"

int min_run_size = DFLT_MIN_RUN_SIZE;
int page_width = DFLT_PAGE_WIDTH;

PRIVATE
CONST struct option optlist[] = {
	{'r', "minimum run size", &min_run_size},
	{'w', "page width", &page_width},
	{'f', "function-like forms only", 0},
	{'d', "use diff format for output", 0},
	{'e', "compare each file to each file separately", 0},
	{'s', "do not compare file to itself", 0},
	{'S', "compare new files to old files only", 0},
	{'F', "keep function identifiers in tact", 0},
	{'n', "display headings only", 0},
	{'x', "do not use hashing", 0},
	{'-', "language processor output", 0},
	{0, 0, 0}
};

char *progname;				/* for error reporting */
extern char options[128];

main(argc, argv)
	char *argv[];
{
	PRIVATE char stdout_buffer[BUFSIZ];
	int nop;			/* number of options */
	
	progname = argv[0];		/* save program name */
	argv++, argc--;			/* and skip it */

	/* get command line options */
	nop = do_options(progname, optlist, argc, argv);
	argc -= nop, argv += nop;	/* and skip them */

	/* check the options */
	if (min_run_size == 0) fatal("bad run size; form is: -r N");
	if (page_width == 0) fatal("bad page width; form is: -w N");

	if (options['-']) {
		/* it is the language processor only */
		setbuf(stdout, (char *)0);
		while (argv[0]) {
			lang(argv[0]);
			argv++;
		}
		exit(0);
	}
	
	init_buff();
	InitLanguage();
	setbuf(stdout, (char *)0);	/* print carefully */
	
	/* Read the files */
	pass1(argv, argc);
	
	/* Set up the forward reference table */
	make_forw_ref();
	
	/* Compare various files */
	compare();
	
	/* Delete forward reference table */
	free_forw_ref();

	/* Find positions of found runs */
	pass2();
	
	/* Print the similarities */
	setbuf(stdout, stdout_buffer);
	pass3();
	exit(0);
}
